/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson.internal;

import com.qb.gson.internal.$Gson$Preconditions;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class $Gson$Types {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private $Gson$Types() {
    }

    public static GenericArrayType arrayOf(Type type) {
        return new GenericArrayTypeImpl(type);
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            type = clazz;
            if (clazz.isArray()) {
                type = new GenericArrayTypeImpl($Gson$Types.canonicalize(clazz.getComponentType()));
            }
            return type;
        }
        if (type instanceof ParameterizedType) {
            type = (ParameterizedType)type;
            return new ParameterizedTypeImpl(type.getOwnerType(), type.getRawType(), type.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            type = (WildcardType)type;
            return new WildcardTypeImpl(type.getUpperBounds(), type.getLowerBounds());
        }
        return type;
    }

    private static void checkNotPrimitive(Type type) {
        boolean bl = !(type instanceof Class) || !((Class)type).isPrimitive();
        $Gson$Preconditions.checkArgument(bl);
    }

    private static Class<?> declaringClassOf(TypeVariable<?> type) {
        type = (type = type.getGenericDeclaration()) instanceof Class ? (Class)type : null;
        return type;
    }

    static boolean equal(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    public static boolean equals(Type type, Type type2) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (type == type2) {
            return true;
        }
        if (type instanceof Class) {
            return type.equals(type2);
        }
        if (type instanceof ParameterizedType) {
            if (!(type2 instanceof ParameterizedType)) {
                return false;
            }
            type = (ParameterizedType)type;
            type2 = (ParameterizedType)type2;
            if (!($Gson$Types.equal(type.getOwnerType(), type2.getOwnerType()) && type.getRawType().equals(type2.getRawType()) && Arrays.equals(type.getActualTypeArguments(), type2.getActualTypeArguments()))) {
                bl3 = false;
            }
            return bl3;
        }
        if (type instanceof GenericArrayType) {
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            type = (GenericArrayType)type;
            type2 = (GenericArrayType)type2;
            return $Gson$Types.equals(type.getGenericComponentType(), type2.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            if (!(type2 instanceof WildcardType)) {
                return false;
            }
            type = (WildcardType)type;
            type2 = (WildcardType)type2;
            bl3 = Arrays.equals(type.getUpperBounds(), type2.getUpperBounds()) && Arrays.equals(type.getLowerBounds(), type2.getLowerBounds()) ? bl : false;
            return bl3;
        }
        if (type instanceof TypeVariable) {
            if (!(type2 instanceof TypeVariable)) {
                return false;
            }
            type = (TypeVariable)type;
            type2 = (TypeVariable)type2;
            bl3 = type.getGenericDeclaration() == type2.getGenericDeclaration() && type.getName().equals(type2.getName()) ? bl2 : false;
            return bl3;
        }
        return false;
    }

    public static Type getArrayComponentType(Type type) {
        type = type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : ((Class)type).getComponentType();
        return type;
    }

    public static Type getCollectionElementType(Type type, Class<?> type2) {
        type = type2 = $Gson$Types.getSupertype(type, type2, Collection.class);
        if (type2 instanceof WildcardType) {
            type = ((WildcardType)type2).getUpperBounds()[0];
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    static Type getGenericSupertype(Type object, Class<?> object2, Class<?> clazz) {
        if (clazz == object2) {
            return object;
        }
        if (clazz.isInterface()) {
            object = ((Class)object2).getInterfaces();
            int n = ((Class<?>[])object).length;
            for (int i = 0; i < n; ++i) {
                if (object[i] == clazz) {
                    return ((Class)object2).getGenericInterfaces()[i];
                }
                if (!clazz.isAssignableFrom(object[i])) continue;
                return $Gson$Types.getGenericSupertype(((Class)object2).getGenericInterfaces()[i], object[i], clazz);
            }
        }
        if (!((Class)object2).isInterface()) {
            while (object2 != Object.class) {
                object = ((Class)object2).getSuperclass();
                if (object == clazz) {
                    return ((Class)object2).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object)) {
                    return $Gson$Types.getGenericSupertype(((Class)object2).getGenericSuperclass(), object, clazz);
                }
                object2 = object;
            }
        }
        return clazz;
    }

    public static Type[] getMapKeyAndValueTypes(Type type, Class<?> clazz) {
        if (type == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        if ((type = $Gson$Types.getSupertype(type, clazz, Map.class)) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
            $Gson$Preconditions.checkArgument(type instanceof Class);
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance($Gson$Types.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return $Gson$Types.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String string2 = type == null ? "null" : type.getClass().getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a Class, ParameterizedType, or GenericArrayType, but <");
        stringBuilder.append(type);
        stringBuilder.append("> is of type ");
        stringBuilder.append(string2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    static Type getSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        $Gson$Preconditions.checkArgument(clazz2.isAssignableFrom(clazz));
        return $Gson$Types.resolve(type, clazz, $Gson$Types.getGenericSupertype(type, clazz, clazz2));
    }

    private static int hashCodeOrZero(Object object) {
        int n = object != null ? object.hashCode() : 0;
        return n;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type type, Type type2, Type ... typeArray) {
        return new ParameterizedTypeImpl(type, type2, typeArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type resolve(Type type, Class<?> clazz, Type type2) {
        Type type3;
        while (type2 instanceof TypeVariable) {
            type3 = (TypeVariable)type2;
            if ((type2 = $Gson$Types.resolveTypeVariable(type, clazz, type3)) != type3) continue;
            return type2;
        }
        if (type2 instanceof Class && ((Class)(type3 = (Class)type2)).isArray()) {
            type2 = ((Class)type3).getComponentType();
            if (type2 != (type = $Gson$Types.resolve(type, clazz, type2))) return $Gson$Types.arrayOf(type);
            return type3;
        }
        if (type2 instanceof GenericArrayType) {
            type3 = (type2 = (GenericArrayType)type2).getGenericComponentType();
            if (type3 != (type = $Gson$Types.resolve(type, clazz, type3))) return $Gson$Types.arrayOf(type);
            return type2;
        }
        boolean bl = type2 instanceof ParameterizedType;
        if (bl) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Type type4 = $Gson$Types.resolve(type, clazz, type2 = parameterizedType.getOwnerType());
            boolean bl2 = type4 != type2;
            type2 = parameterizedType.getActualTypeArguments();
            int n = ((Type)type2).length;
            for (int i = 0; i < n; ++i) {
                Type type5 = $Gson$Types.resolve(type, clazz, type2[i]);
                boolean bl3 = bl2;
                type3 = type2;
                if (type5 != type2[i]) {
                    bl3 = bl2;
                    type3 = type2;
                    if (!bl2) {
                        type3 = (Type[])type2.clone();
                        bl3 = true;
                    }
                    type3[i] = type5;
                }
                bl2 = bl3;
                type2 = type3;
            }
            type = parameterizedType;
            if (!bl2) return type;
            return $Gson$Types.newParameterizedTypeWithOwner(type4, parameterizedType.getRawType(), (Type[])type2);
        }
        type3 = type2;
        if (!(type2 instanceof WildcardType)) return type3;
        type2 = (WildcardType)type2;
        Type[] typeArray = type2.getLowerBounds();
        Type[] typeArray2 = type2.getUpperBounds();
        if (typeArray.length == 1) {
            type = $Gson$Types.resolve(type, clazz, typeArray[0]);
            type3 = type2;
            if (type == typeArray[0]) return type3;
            return $Gson$Types.supertypeOf(type);
        }
        type3 = type2;
        if (typeArray2.length != 1) return type3;
        type3 = typeArray2[0];
        type = $Gson$Types.resolve(type, clazz, type3);
        type3 = type2;
        if (type == typeArray2[0]) return type3;
        return $Gson$Types.subtypeOf(type);
    }

    static Type resolveTypeVariable(Type type, Class<?> clazz, TypeVariable<?> typeVariable) {
        Class<?> clazz2 = $Gson$Types.declaringClassOf(typeVariable);
        if (clazz2 == null) {
            return typeVariable;
        }
        if ((type = $Gson$Types.getGenericSupertype(type, clazz, clazz2)) instanceof ParameterizedType) {
            int n = $Gson$Types.indexOf(clazz2.getTypeParameters(), typeVariable);
            return ((ParameterizedType)type).getActualTypeArguments()[n];
        }
        return typeVariable;
    }

    public static WildcardType subtypeOf(Type type) {
        Type[] typeArray = EMPTY_TYPE_ARRAY;
        return new WildcardTypeImpl(new Type[]{type}, typeArray);
    }

    public static WildcardType supertypeOf(Type type) {
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{type});
    }

    public static String typeToString(Type object) {
        object = object instanceof Class ? ((Class)object).getName() : object.toString();
        return object;
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Type componentType;

        public GenericArrayTypeImpl(Type type) {
            this.componentType = $Gson$Types.canonicalize(type);
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof GenericArrayType && $Gson$Types.equals(this, (GenericArrayType)object);
            return bl;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append($Gson$Types.typeToString(this.componentType));
            stringBuilder.append("[]");
            return stringBuilder.toString();
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;

        public ParameterizedTypeImpl(Type object, Type type, Type ... typeArray) {
            boolean bl = type instanceof Class;
            int n = 0;
            if (bl) {
                Class clazz = (Class)type;
                boolean bl2 = true;
                bl = object != null || clazz.getEnclosingClass() == null;
                $Gson$Preconditions.checkArgument(bl);
                bl = bl2;
                if (object != null) {
                    bl = clazz.getEnclosingClass() != null ? bl2 : false;
                }
                $Gson$Preconditions.checkArgument(bl);
            }
            object = object == null ? null : $Gson$Types.canonicalize((Type)object);
            this.ownerType = object;
            this.rawType = $Gson$Types.canonicalize(type);
            this.typeArguments = (Type[])typeArray.clone();
            while (n < ((Type[])(object = this.typeArguments)).length) {
                $Gson$Preconditions.checkNotNull(object[n]);
                $Gson$Types.checkNotPrimitive(this.typeArguments[n]);
                object = this.typeArguments;
                object[n] = $Gson$Types.canonicalize(object[n]);
                ++n;
            }
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof ParameterizedType && $Gson$Types.equals(this, (ParameterizedType)object);
            return bl;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ $Gson$Types.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            int n = this.typeArguments.length;
            StringBuilder stringBuilder = new StringBuilder((n + 1) * 30);
            stringBuilder.append($Gson$Types.typeToString(this.rawType));
            if (this.typeArguments.length == 0) {
                return stringBuilder.toString();
            }
            stringBuilder.append("<");
            stringBuilder.append($Gson$Types.typeToString(this.typeArguments[0]));
            for (int i = 1; i < this.typeArguments.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append($Gson$Types.typeToString(this.typeArguments[i]));
            }
            stringBuilder.append(">");
            return stringBuilder.toString();
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Type lowerBound;
        private final Type upperBound;

        public WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            int n = typeArray2.length;
            boolean bl = true;
            boolean bl2 = n <= 1;
            $Gson$Preconditions.checkArgument(bl2);
            bl2 = typeArray.length == 1;
            $Gson$Preconditions.checkArgument(bl2);
            if (typeArray2.length == 1) {
                $Gson$Preconditions.checkNotNull(typeArray2[0]);
                $Gson$Types.checkNotPrimitive(typeArray2[0]);
                bl2 = typeArray[0] == Object.class ? bl : false;
                $Gson$Preconditions.checkArgument(bl2);
                this.lowerBound = $Gson$Types.canonicalize(typeArray2[0]);
                this.upperBound = Object.class;
            } else {
                $Gson$Preconditions.checkNotNull(typeArray[0]);
                $Gson$Types.checkNotPrimitive(typeArray[0]);
                this.lowerBound = null;
                this.upperBound = $Gson$Types.canonicalize(typeArray[0]);
            }
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof WildcardType && $Gson$Types.equals(this, (WildcardType)object);
            return bl;
        }

        @Override
        public Type[] getLowerBounds() {
            Type type = this.lowerBound;
            Type[] typeArray = type != null ? new Type[]{type} : EMPTY_TYPE_ARRAY;
            return typeArray;
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        public int hashCode() {
            Type type = this.lowerBound;
            int n = type != null ? type.hashCode() + 31 : 1;
            return n ^ this.upperBound.hashCode() + 31;
        }

        public String toString() {
            if (this.lowerBound != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("? super ");
                stringBuilder.append($Gson$Types.typeToString(this.lowerBound));
                return stringBuilder.toString();
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("? extends ");
            stringBuilder.append($Gson$Types.typeToString(this.upperBound));
            return stringBuilder.toString();
        }
    }
}

