/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson.internal;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;

public final class StringMap<V>
extends AbstractMap<String, V> {
    private static final Map.Entry[] EMPTY_TABLE = new LinkedEntry[2];
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int seed = new Random().nextInt();
    private Set<Map.Entry<String, V>> entrySet;
    private LinkedEntry<V> header;
    private Set<String> keySet;
    private int size;
    private LinkedEntry<V>[] table = (LinkedEntry[])EMPTY_TABLE;
    private int threshold = -1;
    private Collection<V> values;

    public StringMap() {
        this.header = new LinkedEntry();
    }

    private void addNewEntry(String object, V object2, int n, int n2) {
        LinkedEntry<V> linkedEntry = this.header;
        LinkedEntry linkedEntry2 = linkedEntry.prv;
        object = new LinkedEntry<V>((String)object, object2, n, this.table[n2], linkedEntry, linkedEntry2);
        object2 = this.table;
        linkedEntry.prv = object;
        linkedEntry2.nxt = object;
        object2[n2] = object;
    }

    private LinkedEntry<V>[] doubleCapacity() {
        LinkedEntry<V>[] linkedEntryArray = this.table;
        int n = linkedEntryArray.length;
        if (n == 0x40000000) {
            return linkedEntryArray;
        }
        LinkedEntry<V>[] linkedEntryArray2 = this.makeTable(n * 2);
        if (this.size == 0) {
            return linkedEntryArray2;
        }
        for (int i = 0; i < n; ++i) {
            LinkedEntry<V> linkedEntry = linkedEntryArray[i];
            if (linkedEntry == null) continue;
            int n2 = linkedEntry.hash & n;
            linkedEntryArray2[i | n2] = linkedEntry;
            LinkedEntry linkedEntry2 = linkedEntry.next;
            LinkedEntry linkedEntry3 = null;
            while (linkedEntry2 != null) {
                int n3 = linkedEntry2.hash & n;
                int n4 = n2;
                LinkedEntry linkedEntry4 = linkedEntry3;
                if (n3 != n2) {
                    if (linkedEntry3 == null) {
                        linkedEntryArray2[i | n3] = linkedEntry2;
                    } else {
                        linkedEntry3.next = linkedEntry2;
                    }
                    n4 = n3;
                    linkedEntry4 = linkedEntry;
                }
                linkedEntry3 = linkedEntry2.next;
                linkedEntry = linkedEntry2;
                linkedEntry2 = linkedEntry3;
                n2 = n4;
                linkedEntry3 = linkedEntry4;
            }
            if (linkedEntry3 == null) continue;
            linkedEntry3.next = null;
        }
        return linkedEntryArray2;
    }

    private LinkedEntry<V> getEntry(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = StringMap.hash(string2);
        Object object = this.table;
        object = object[((LinkedEntry<V>[])object).length - 1 & n];
        while (object != null) {
            String string3 = object.key;
            if (!(string3 == string2 || object.hash == n && string2.equals(string3))) {
                object = object.next;
                continue;
            }
            return object;
        }
        return null;
    }

    private static int hash(String string2) {
        int n;
        int n2 = seed;
        for (n = 0; n < string2.length(); ++n) {
            n2 += string2.charAt(n);
            n2 = n2 + n2 << 10;
            n2 ^= n2 >>> 6;
        }
        n = n2 >>> 20 ^ n2 >>> 12 ^ n2;
        return n >>> 4 ^ (n >>> 7 ^ n);
    }

    private LinkedEntry<V>[] makeTable(int n) {
        LinkedEntry[] linkedEntryArray = new LinkedEntry[n];
        this.table = linkedEntryArray;
        this.threshold = (n >> 1) + (n >> 2);
        return linkedEntryArray;
    }

    private boolean removeMapping(Object object, Object object2) {
        if (object != null && object instanceof String) {
            int n = StringMap.hash((String)object);
            LinkedEntry<V>[] linkedEntryArray = this.table;
            int n2 = linkedEntryArray.length - 1 & n;
            LinkedEntry<V> linkedEntry = linkedEntryArray[n2];
            LinkedEntry<V> linkedEntry2 = null;
            while (linkedEntry != null) {
                if (linkedEntry.hash == n && object.equals(linkedEntry.key)) {
                    object = linkedEntry.value;
                    if (object2 == null ? object != null : !object2.equals(object)) {
                        return false;
                    }
                    if (linkedEntry2 == null) {
                        linkedEntryArray[n2] = linkedEntry.next;
                    } else {
                        linkedEntry2.next = linkedEntry.next;
                    }
                    --this.size;
                    this.unlink(linkedEntry);
                    return true;
                }
                LinkedEntry linkedEntry3 = linkedEntry.next;
                linkedEntry2 = linkedEntry;
                linkedEntry = linkedEntry3;
            }
        }
        return false;
    }

    private void unlink(LinkedEntry<V> linkedEntry) {
        linkedEntry.prv.nxt = linkedEntry.nxt;
        linkedEntry.nxt.prv = linkedEntry.prv;
        linkedEntry.prv = null;
        linkedEntry.nxt = null;
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            Arrays.fill(this.table, null);
            this.size = 0;
        }
        LinkedEntry<V> linkedEntry = this.header;
        LinkedEntry linkedEntry2 = linkedEntry.nxt;
        while (linkedEntry2 != linkedEntry) {
            LinkedEntry linkedEntry3 = linkedEntry2.nxt;
            linkedEntry2.prv = null;
            linkedEntry2.nxt = null;
            linkedEntry2 = linkedEntry3;
        }
        linkedEntry.prv = linkedEntry;
        linkedEntry.nxt = linkedEntry;
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl = object instanceof String && this.getEntry((String)object) != null;
        return bl;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet();
        }
        return entrySet;
    }

    @Override
    public V get(Object linkedEntry) {
        V v;
        boolean bl = linkedEntry instanceof String;
        V v2 = v = null;
        if (bl) {
            linkedEntry = this.getEntry((String)((Object)linkedEntry));
            v2 = v;
            if (linkedEntry != null) {
                v2 = linkedEntry.value;
            }
        }
        return v2;
    }

    @Override
    public Set<String> keySet() {
        KeySet keySet = this.keySet;
        if (keySet == null) {
            this.keySet = keySet = new KeySet();
        }
        return keySet;
    }

    @Override
    public V put(String string2, V v) {
        Objects.requireNonNull(string2, "key == null");
        int n = StringMap.hash(string2);
        Object object = this.table;
        int n2 = ((LinkedEntry<V>[])object).length - 1 & n;
        object = object[n2];
        while (object != null) {
            if (object.hash == n && string2.equals(object.key)) {
                string2 = object.value;
                object.value = v;
                return (V)string2;
            }
            object = object.next;
        }
        int n3 = this.size;
        this.size = n3 + 1;
        if (n3 > this.threshold) {
            n2 = n & this.doubleCapacity().length - 1;
        }
        this.addNewEntry(string2, v, n, n2);
        return null;
    }

    @Override
    public V remove(Object object) {
        if (object != null && object instanceof String) {
            int n = StringMap.hash((String)object);
            LinkedEntry<V>[] linkedEntryArray = this.table;
            int n2 = linkedEntryArray.length - 1 & n;
            LinkedEntry<V> linkedEntry = linkedEntryArray[n2];
            LinkedEntry<V> linkedEntry2 = null;
            while (linkedEntry != null) {
                if (linkedEntry.hash == n && object.equals(linkedEntry.key)) {
                    if (linkedEntry2 == null) {
                        linkedEntryArray[n2] = linkedEntry.next;
                    } else {
                        linkedEntry2.next = linkedEntry.next;
                    }
                    --this.size;
                    this.unlink(linkedEntry);
                    return linkedEntry.value;
                }
                LinkedEntry linkedEntry3 = linkedEntry.next;
                linkedEntry2 = linkedEntry;
                linkedEntry = linkedEntry3;
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<V> values() {
        Values values2 = this.values;
        if (values2 == null) {
            this.values = values2 = new Values();
        }
        return values2;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            StringMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Map.Entry;
            boolean bl2 = false;
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            object = StringMap.this.get(entry.getKey());
            bl = bl2;
            if (object != null) {
                bl = bl2;
                if (object.equals(entry.getValue())) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new LinkedHashIterator<Map.Entry<String, V>>(){

                @Override
                public final Map.Entry<String, V> next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            object = (Map.Entry)object;
            return StringMap.this.removeMapping(object.getKey(), object.getValue());
        }

        @Override
        public int size() {
            return StringMap.this.size;
        }
    }

    private final class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public void clear() {
            StringMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return StringMap.this.containsKey(object);
        }

        @Override
        public Iterator<String> iterator() {
            return new LinkedHashIterator<String>(){

                @Override
                public final String next() {
                    return this.nextEntry().key;
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            int n = StringMap.this.size;
            StringMap.this.remove(object);
            boolean bl = StringMap.this.size != n;
            return bl;
        }

        @Override
        public int size() {
            return StringMap.this.size;
        }
    }

    static class LinkedEntry<V>
    implements Map.Entry<String, V> {
        final int hash;
        final String key;
        LinkedEntry<V> next;
        LinkedEntry<V> nxt;
        LinkedEntry<V> prv;
        V value;

        LinkedEntry() {
            this(null, null, 0, null, null, null);
            this.prv = this;
            this.nxt = this;
        }

        LinkedEntry(String string2, V v, int n, LinkedEntry<V> linkedEntry, LinkedEntry<V> linkedEntry2, LinkedEntry<V> linkedEntry3) {
            this.key = string2;
            this.value = v;
            this.hash = n;
            this.next = linkedEntry;
            this.nxt = linkedEntry2;
            this.prv = linkedEntry3;
        }

        @Override
        public final boolean equals(Object object) {
            boolean bl;
            block4: {
                block6: {
                    Map.Entry entry;
                    boolean bl2;
                    block5: {
                        bl = object instanceof Map.Entry;
                        bl2 = false;
                        if (!bl) {
                            return false;
                        }
                        entry = (Map.Entry)object;
                        object = entry.getValue();
                        bl = bl2;
                        if (!this.key.equals(entry.getKey())) break block4;
                        entry = this.value;
                        if (entry != null) break block5;
                        bl = bl2;
                        if (object != null) break block4;
                        break block6;
                    }
                    bl = bl2;
                    if (!((Object)entry).equals(object)) break block4;
                }
                bl = true;
            }
            return bl;
        }

        @Override
        public final String getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final int hashCode() {
            String string2 = this.key;
            int n = 0;
            int n2 = string2 == null ? 0 : string2.hashCode();
            string2 = this.value;
            if (string2 != null) {
                n = string2.hashCode();
            }
            return n2 ^ n;
        }

        @Override
        public final V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        LinkedEntry<V> lastReturned;
        LinkedEntry<V> next;

        private LinkedHashIterator() {
            this.next = ((StringMap)StringMap.this).header.nxt;
            this.lastReturned = null;
        }

        @Override
        public final boolean hasNext() {
            boolean bl = this.next != StringMap.this.header;
            return bl;
        }

        final LinkedEntry<V> nextEntry() {
            LinkedEntry linkedEntry = this.next;
            if (linkedEntry != StringMap.this.header) {
                this.next = linkedEntry.nxt;
                this.lastReturned = linkedEntry;
                return linkedEntry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            LinkedEntry linkedEntry = this.lastReturned;
            if (linkedEntry != null) {
                StringMap.this.remove(linkedEntry.key);
                this.lastReturned = null;
                return;
            }
            throw new IllegalStateException();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public void clear() {
            StringMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return StringMap.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return new LinkedHashIterator<V>(){

                @Override
                public final V next() {
                    return this.nextEntry().value;
                }
            };
        }

        @Override
        public int size() {
            return StringMap.this.size;
        }
    }
}

