/*
 * Decompiled with CFR 0.152.
 */
package com.qb.gson.internal.bind;

import com.qb.gson.Gson;
import com.qb.gson.JsonArray;
import com.qb.gson.JsonElement;
import com.qb.gson.JsonIOException;
import com.qb.gson.JsonNull;
import com.qb.gson.JsonObject;
import com.qb.gson.JsonPrimitive;
import com.qb.gson.JsonSyntaxException;
import com.qb.gson.TypeAdapter;
import com.qb.gson.TypeAdapterFactory;
import com.qb.gson.annotations.SerializedName;
import com.qb.gson.internal.LazilyParsedNumber;
import com.qb.gson.reflect.TypeToken;
import com.qb.gson.stream.JsonReader;
import com.qb.gson.stream.JsonToken;
import com.qb.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;

public final class TypeAdapters {
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL;
    public static final TypeAdapter<BigInteger> BIG_INTEGER;
    public static final TypeAdapter<BitSet> BIT_SET;
    public static final TypeAdapterFactory BIT_SET_FACTORY;
    public static final TypeAdapter<Boolean> BOOLEAN;
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING;
    public static final TypeAdapterFactory BOOLEAN_FACTORY;
    public static final TypeAdapter<Number> BYTE;
    public static final TypeAdapterFactory BYTE_FACTORY;
    public static final TypeAdapter<Calendar> CALENDAR;
    public static final TypeAdapterFactory CALENDAR_FACTORY;
    public static final TypeAdapter<Character> CHARACTER;
    public static final TypeAdapterFactory CHARACTER_FACTORY;
    public static final TypeAdapter<Class> CLASS;
    public static final TypeAdapterFactory CLASS_FACTORY;
    public static final TypeAdapter<Number> DOUBLE;
    public static final TypeAdapterFactory ENUM_FACTORY;
    public static final TypeAdapter<Number> FLOAT;
    public static final TypeAdapter<InetAddress> INET_ADDRESS;
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY;
    public static final TypeAdapter<Number> INTEGER;
    public static final TypeAdapterFactory INTEGER_FACTORY;
    public static final TypeAdapter<JsonElement> JSON_ELEMENT;
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY;
    public static final TypeAdapter<Locale> LOCALE;
    public static final TypeAdapterFactory LOCALE_FACTORY;
    public static final TypeAdapter<Number> LONG;
    public static final TypeAdapter<Number> NUMBER;
    public static final TypeAdapterFactory NUMBER_FACTORY;
    public static final TypeAdapter<Number> SHORT;
    public static final TypeAdapterFactory SHORT_FACTORY;
    public static final TypeAdapter<String> STRING;
    public static final TypeAdapter<StringBuffer> STRING_BUFFER;
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY;
    public static final TypeAdapter<StringBuilder> STRING_BUILDER;
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY;
    public static final TypeAdapterFactory STRING_FACTORY;
    public static final TypeAdapterFactory TIMESTAMP_FACTORY;
    public static final TypeAdapter<URI> URI;
    public static final TypeAdapterFactory URI_FACTORY;
    public static final TypeAdapter<URL> URL;
    public static final TypeAdapterFactory URL_FACTORY;
    public static final TypeAdapter<UUID> UUID;
    public static final TypeAdapterFactory UUID_FACTORY;

    static {
        TypeAdapter<Object> typeAdapter;
        CLASS = typeAdapter = new TypeAdapter<Class>(){

            @Override
            public Class read(JsonReader jsonReader) throws IOException {
                throw new UnsupportedOperationException("Attempted to deserialize a java.lang.Class. Forgot to register a type adapter?");
            }

            @Override
            public void write(JsonWriter object, Class clazz) throws IOException {
                object = new StringBuilder();
                ((StringBuilder)object).append("Attempted to serialize java.lang.Class: ");
                ((StringBuilder)object).append(clazz.getName());
                ((StringBuilder)object).append(". Forgot to register a type adapter?");
                throw new UnsupportedOperationException(((StringBuilder)object).toString());
            }
        };
        CLASS_FACTORY = TypeAdapters.newFactory(Class.class, typeAdapter);
        BIT_SET = typeAdapter = new TypeAdapter<BitSet>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public BitSet read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                BitSet bitSet = new BitSet();
                ((JsonReader)object).beginArray();
                JsonToken jsonToken = ((JsonReader)object).peek();
                int n = 0;
                while (true) {
                    boolean bl;
                    block16: {
                        block14: {
                            block15: {
                                void var3_6;
                                if (var3_6 == JsonToken.END_ARRAY) {
                                    ((JsonReader)object).endArray();
                                    return bitSet;
                                }
                                int n2 = 32.$SwitchMap$com$google$gson$stream$JsonToken[var3_6.ordinal()];
                                bl = true;
                                if (n2 == 1) break block15;
                                if (n2 != 2) {
                                    if (n2 != 3) {
                                        object = new StringBuilder();
                                        ((StringBuilder)object).append("Invalid bitset value type: ");
                                        ((StringBuilder)object).append(var3_6);
                                        throw new JsonSyntaxException(((StringBuilder)object).toString());
                                    }
                                    String string2 = ((JsonReader)object).nextString();
                                    try {
                                        n2 = Integer.parseInt(string2);
                                        if (n2 != 0) {
                                        }
                                        break block14;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        StringBuilder stringBuilder = new StringBuilder();
                                        stringBuilder.append("Error: Expecting: bitset number value (1, 0), Found: ");
                                        stringBuilder.append(string2);
                                        throw new JsonSyntaxException(stringBuilder.toString());
                                    }
                                }
                                bl = ((JsonReader)object).nextBoolean();
                                break block16;
                            }
                            if (((JsonReader)object).nextInt() != 0) break block16;
                        }
                        bl = false;
                    }
                    if (bl) {
                        bitSet.set(n);
                    }
                    ++n;
                    JsonToken jsonToken2 = ((JsonReader)object).peek();
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, BitSet bitSet) throws IOException {
                if (bitSet == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.beginArray();
                for (int i = 0; i < bitSet.length(); ++i) {
                    jsonWriter.value((long)bitSet.get(i));
                }
                jsonWriter.endArray();
            }
        };
        BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, typeAdapter);
        BOOLEAN = typeAdapter = new TypeAdapter<Boolean>(){

            @Override
            public Boolean read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                if (jsonReader.peek() == JsonToken.STRING) {
                    return Boolean.parseBoolean(jsonReader.nextString());
                }
                return jsonReader.nextBoolean();
            }

            @Override
            public void write(JsonWriter jsonWriter, Boolean bl) throws IOException {
                if (bl == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.value(bl);
            }
        };
        BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

            @Override
            public Boolean read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Boolean.valueOf(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, Boolean object) throws IOException {
                object = object == null ? "null" : ((Boolean)object).toString();
                jsonWriter.value((String)object);
            }
        };
        BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, typeAdapter);
        BYTE = typeAdapter = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                byte by;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    by = (byte)jsonReader.nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return by;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, typeAdapter);
        SHORT = typeAdapter = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                short s;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    s = (short)jsonReader.nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return s;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, typeAdapter);
        INTEGER = typeAdapter = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                int n;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    n = jsonReader.nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return n;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, typeAdapter);
        LONG = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                long l;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    l = jsonReader.nextLong();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return l;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        FLOAT = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        DOUBLE = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        NUMBER = typeAdapter = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader object) throws IOException {
                JsonToken jsonToken = ((JsonReader)object).peek();
                int n = 32.$SwitchMap$com$google$gson$stream$JsonToken[jsonToken.ordinal()];
                if (n != 1) {
                    if (n == 4) {
                        ((JsonReader)object).nextNull();
                        return null;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Expecting number, got: ");
                    ((StringBuilder)object).append((Object)jsonToken);
                    throw new JsonSyntaxException(((StringBuilder)object).toString());
                }
                return new LazilyParsedNumber(((JsonReader)object).nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        NUMBER_FACTORY = TypeAdapters.newFactory(Number.class, typeAdapter);
        CHARACTER = typeAdapter = new TypeAdapter<Character>(){

            @Override
            public Character read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                if (((String)(object = ((JsonReader)object).nextString())).length() == 1) {
                    return Character.valueOf(((String)object).charAt(0));
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expecting character, got: ");
                stringBuilder.append((String)object);
                throw new JsonSyntaxException(stringBuilder.toString());
            }

            @Override
            public void write(JsonWriter jsonWriter, Character object) throws IOException {
                object = object == null ? null : String.valueOf(object);
                jsonWriter.value((String)object);
            }
        };
        CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, typeAdapter);
        STRING = typeAdapter = new TypeAdapter<String>(){

            @Override
            public String read(JsonReader jsonReader) throws IOException {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                if (jsonToken == JsonToken.BOOLEAN) {
                    return Boolean.toString(jsonReader.nextBoolean());
                }
                return jsonReader.nextString();
            }

            @Override
            public void write(JsonWriter jsonWriter, String string2) throws IOException {
                jsonWriter.value(string2);
            }
        };
        BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

            @Override
            public BigDecimal read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    object = new BigDecimal(((JsonReader)object).nextString());
                    return object;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, BigDecimal bigDecimal) throws IOException {
                jsonWriter.value(bigDecimal);
            }
        };
        BIG_INTEGER = new TypeAdapter<BigInteger>(){

            @Override
            public BigInteger read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    object = new BigInteger(((JsonReader)object).nextString());
                    return object;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, BigInteger bigInteger) throws IOException {
                jsonWriter.value(bigInteger);
            }
        };
        STRING_FACTORY = TypeAdapters.newFactory(String.class, typeAdapter);
        STRING_BUILDER = typeAdapter = new TypeAdapter<StringBuilder>(){

            @Override
            public StringBuilder read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return new StringBuilder(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, StringBuilder charSequence) throws IOException {
                charSequence = charSequence == null ? null : charSequence.toString();
                jsonWriter.value((String)charSequence);
            }
        };
        STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, typeAdapter);
        STRING_BUFFER = typeAdapter = new TypeAdapter<StringBuffer>(){

            @Override
            public StringBuffer read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return new StringBuffer(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, StringBuffer charSequence) throws IOException {
                charSequence = charSequence == null ? null : charSequence.toString();
                jsonWriter.value((String)charSequence);
            }
        };
        STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, typeAdapter);
        URL = typeAdapter = new TypeAdapter<URL>(){

            @Override
            public URL read(JsonReader object) throws IOException {
                JsonToken jsonToken = ((JsonReader)object).peek();
                JsonToken jsonToken2 = JsonToken.NULL;
                Object var4_4 = null;
                if (jsonToken == jsonToken2) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                object = "null".equals(object = ((JsonReader)object).nextString()) ? var4_4 : new URL((String)object);
                return object;
            }

            @Override
            public void write(JsonWriter jsonWriter, URL object) throws IOException {
                object = object == null ? null : ((URL)object).toExternalForm();
                jsonWriter.value((String)object);
            }
        };
        URL_FACTORY = TypeAdapters.newFactory(URL.class, typeAdapter);
        URI = typeAdapter = new TypeAdapter<URI>(){

            @Override
            public URI read(JsonReader object) throws IOException {
                block5: {
                    block4: {
                        JsonToken jsonToken = ((JsonReader)object).peek();
                        JsonToken jsonToken2 = JsonToken.NULL;
                        Object var4_5 = null;
                        if (jsonToken == jsonToken2) {
                            ((JsonReader)object).nextNull();
                            return null;
                        }
                        try {
                            object = ((JsonReader)object).nextString();
                            if (!"null".equals(object)) break block4;
                            object = var4_5;
                            break block5;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new JsonIOException(uRISyntaxException);
                        }
                    }
                    object = new URI((String)object);
                }
                return object;
            }

            @Override
            public void write(JsonWriter jsonWriter, URI object) throws IOException {
                object = object == null ? null : ((URI)object).toASCIIString();
                jsonWriter.value((String)object);
            }
        };
        URI_FACTORY = TypeAdapters.newFactory(URI.class, typeAdapter);
        INET_ADDRESS = typeAdapter = new TypeAdapter<InetAddress>(){

            @Override
            public InetAddress read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return InetAddress.getByName(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, InetAddress object) throws IOException {
                object = object == null ? null : ((InetAddress)object).getHostAddress();
                jsonWriter.value((String)object);
            }
        };
        INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, typeAdapter);
        UUID = typeAdapter = new TypeAdapter<UUID>(){

            @Override
            public UUID read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return java.util.UUID.fromString(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, UUID object) throws IOException {
                object = object == null ? null : ((UUID)object).toString();
                jsonWriter.value((String)object);
            }
        };
        UUID_FACTORY = TypeAdapters.newFactory(UUID.class, typeAdapter);
        TIMESTAMP_FACTORY = new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.getRawType() != Timestamp.class) {
                    return null;
                }
                return new TypeAdapter<Timestamp>(gson.getAdapter(Date.class)){
                    final /* synthetic */ TypeAdapter val$dateTypeAdapter;
                    {
                        this.val$dateTypeAdapter = typeAdapter;
                    }

                    @Override
                    public Timestamp read(JsonReader object) throws IOException {
                        object = (object = (Date)this.val$dateTypeAdapter.read((JsonReader)object)) != null ? new Timestamp(((Date)object).getTime()) : null;
                        return object;
                    }

                    @Override
                    public void write(JsonWriter jsonWriter, Timestamp timestamp) throws IOException {
                        this.val$dateTypeAdapter.write(jsonWriter, timestamp);
                    }
                };
            }
        };
        CALENDAR = typeAdapter = new TypeAdapter<Calendar>(){
            private static final String DAY_OF_MONTH = "dayOfMonth";
            private static final String HOUR_OF_DAY = "hourOfDay";
            private static final String MINUTE = "minute";
            private static final String MONTH = "month";
            private static final String SECOND = "second";
            private static final String YEAR = "year";

            @Override
            public Calendar read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                jsonReader.beginObject();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (jsonReader.peek() != JsonToken.END_OBJECT) {
                    String string2 = jsonReader.nextName();
                    int n7 = jsonReader.nextInt();
                    if (YEAR.equals(string2)) {
                        n = n7;
                        continue;
                    }
                    if (MONTH.equals(string2)) {
                        n2 = n7;
                        continue;
                    }
                    if (DAY_OF_MONTH.equals(string2)) {
                        n3 = n7;
                        continue;
                    }
                    if (HOUR_OF_DAY.equals(string2)) {
                        n4 = n7;
                        continue;
                    }
                    if (MINUTE.equals(string2)) {
                        n5 = n7;
                        continue;
                    }
                    if (!SECOND.equals(string2)) continue;
                    n6 = n7;
                }
                jsonReader.endObject();
                return new GregorianCalendar(n, n2, n3, n4, n5, n6);
            }

            @Override
            public void write(JsonWriter jsonWriter, Calendar calendar) throws IOException {
                if (calendar == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.beginObject();
                jsonWriter.name(YEAR);
                jsonWriter.value(calendar.get(1));
                jsonWriter.name(MONTH);
                jsonWriter.value(calendar.get(2));
                jsonWriter.name(DAY_OF_MONTH);
                jsonWriter.value(calendar.get(5));
                jsonWriter.name(HOUR_OF_DAY);
                jsonWriter.value(calendar.get(11));
                jsonWriter.name(MINUTE);
                jsonWriter.value(calendar.get(12));
                jsonWriter.name(SECOND);
                jsonWriter.value(calendar.get(13));
                jsonWriter.endObject();
            }
        };
        CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, typeAdapter);
        LOCALE = typeAdapter = new TypeAdapter<Locale>(){

            @Override
            public Locale read(JsonReader object) throws IOException {
                Object object2 = ((JsonReader)object).peek();
                Object object3 = JsonToken.NULL;
                String string2 = null;
                if (object2 == object3) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                object3 = new StringTokenizer(((JsonReader)object).nextString(), "_");
                object = ((StringTokenizer)object3).hasMoreElements() ? ((StringTokenizer)object3).nextToken() : null;
                object2 = ((StringTokenizer)object3).hasMoreElements() ? ((StringTokenizer)object3).nextToken() : null;
                if (((StringTokenizer)object3).hasMoreElements()) {
                    string2 = ((StringTokenizer)object3).nextToken();
                }
                if (object2 == null && string2 == null) {
                    return new Locale((String)object);
                }
                if (string2 == null) {
                    return new Locale((String)object, (String)object2);
                }
                return new Locale((String)object, (String)object2, string2);
            }

            @Override
            public void write(JsonWriter jsonWriter, Locale object) throws IOException {
                object = object == null ? null : ((Locale)object).toString();
                jsonWriter.value((String)object);
            }
        };
        LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, typeAdapter);
        JSON_ELEMENT = typeAdapter = new TypeAdapter<JsonElement>(){

            @Override
            public JsonElement read(JsonReader jsonReader) throws IOException {
                switch (32.$SwitchMap$com$google$gson$stream$JsonToken[jsonReader.peek().ordinal()]) {
                    default: {
                        throw new IllegalArgumentException();
                    }
                    case 6: {
                        JsonObject jsonObject = new JsonObject();
                        jsonReader.beginObject();
                        while (jsonReader.hasNext()) {
                            jsonObject.add(jsonReader.nextName(), this.read(jsonReader));
                        }
                        jsonReader.endObject();
                        return jsonObject;
                    }
                    case 5: {
                        JsonArray jsonArray = new JsonArray();
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            jsonArray.add(this.read(jsonReader));
                        }
                        jsonReader.endArray();
                        return jsonArray;
                    }
                    case 4: {
                        jsonReader.nextNull();
                        return JsonNull.INSTANCE;
                    }
                    case 3: {
                        return new JsonPrimitive(jsonReader.nextString());
                    }
                    case 2: {
                        return new JsonPrimitive(jsonReader.nextBoolean());
                    }
                    case 1: 
                }
                return new JsonPrimitive(new LazilyParsedNumber(jsonReader.nextString()));
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter object, JsonElement object2) throws IOException {
                if (object2 != null && !((JsonElement)object2).isJsonNull()) {
                    if (((JsonElement)object2).isJsonPrimitive()) {
                        if (((JsonPrimitive)(object2 = ((JsonElement)object2).getAsJsonPrimitive())).isNumber()) {
                            ((JsonWriter)object).value(((JsonPrimitive)object2).getAsNumber());
                            return;
                        }
                        if (((JsonPrimitive)object2).isBoolean()) {
                            ((JsonWriter)object).value(((JsonPrimitive)object2).getAsBoolean());
                            return;
                        }
                        ((JsonWriter)object).value(((JsonPrimitive)object2).getAsString());
                        return;
                    }
                    if (((JsonElement)object2).isJsonArray()) {
                        ((JsonWriter)object).beginArray();
                        object2 = ((JsonElement)object2).getAsJsonArray().iterator();
                        while (true) {
                            if (!object2.hasNext()) {
                                ((JsonWriter)object).endArray();
                                return;
                            }
                            this.write((JsonWriter)object, object2.next());
                        }
                    }
                    if (!((JsonElement)object2).isJsonObject()) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Couldn't write ");
                        ((StringBuilder)object).append(object2.getClass());
                        throw new IllegalArgumentException(((StringBuilder)object).toString());
                    }
                    ((JsonWriter)object).beginObject();
                    Iterator<Map.Entry<String, JsonElement>> iterator2 = ((JsonElement)object2).getAsJsonObject().entrySet().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            ((JsonWriter)object).endObject();
                            return;
                        }
                        object2 = iterator2.next();
                        ((JsonWriter)object).name((String)object2.getKey());
                        this.write((JsonWriter)object, (JsonElement)object2.getValue());
                    }
                }
                ((JsonWriter)object).nullValue();
            }
        };
        JSON_ELEMENT_FACTORY = TypeAdapters.newFactory(JsonElement.class, typeAdapter);
        ENUM_FACTORY = TypeAdapters.newEnumTypeHierarchyFactory();
    }

    private TypeAdapters() {
    }

    public static TypeAdapterFactory newEnumTypeHierarchyFactory() {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson clazz, TypeToken<T> object) {
                if (Enum.class.isAssignableFrom((Class<?>)(object = ((TypeToken)object).getRawType())) && object != Enum.class) {
                    clazz = object;
                    if (!((Class)object).isEnum()) {
                        clazz = ((Class)object).getSuperclass();
                    }
                    return new EnumTypeAdapter(clazz);
                }
                return null;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final TypeToken<TT> typeToken, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson typeAdapter2, TypeToken<T> typeToken2) {
                typeAdapter2 = typeToken2.equals(typeToken) ? typeAdapter : null;
                return typeAdapter2;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson typeAdapter2, TypeToken<T> typeToken) {
                typeAdapter2 = typeToken.getRawType() == clazz ? typeAdapter : null;
                return typeAdapter2;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[type=");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final Class<TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson clazz3, TypeToken<T> typeToken) {
                clazz3 = typeToken.getRawType();
                clazz3 = clazz3 != clazz && clazz3 != clazz2 ? null : typeAdapter;
                return clazz3;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[type=");
                stringBuilder.append(clazz2.getName());
                stringBuilder.append("+");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(final Class<TT> clazz, final Class<? extends TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson clazz3, TypeToken<T> typeToken) {
                clazz3 = typeToken.getRawType();
                clazz3 = clazz3 != clazz && clazz3 != clazz2 ? null : typeAdapter;
                return clazz3;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[type=");
                stringBuilder.append(clazz.getName());
                stringBuilder.append("+");
                stringBuilder.append(clazz2.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    public static <TT> TypeAdapterFactory newTypeHierarchyFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson typeAdapter2, TypeToken<T> typeToken) {
                typeAdapter2 = clazz.isAssignableFrom(typeToken.getRawType()) ? typeAdapter : null;
                return typeAdapter2;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[typeHierarchy=");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<T, String> constantToName;
        private final Map<String, T> nameToConstant = new HashMap<String, T>();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public EnumTypeAdapter(Class<T> clazz) {
            int n;
            int n2;
            Enum[] enumArray;
            this.constantToName = new HashMap<T, String>();
            try {
                enumArray = (Enum[])clazz.getEnumConstants();
                n2 = enumArray.length;
                n = 0;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError();
            }
            while (true) {
                if (n >= n2) {
                    return;
                }
                Enum enum_ = enumArray[n];
                String string2 = enum_.name();
                SerializedName serializedName = clazz.getField(string2).getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    string2 = serializedName.value();
                }
                this.nameToConstant.put(string2, enum_);
                this.constantToName.put(enum_, string2);
                ++n;
                continue;
                break;
            }
        }

        @Override
        public T read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return (T)((Enum)this.nameToConstant.get(jsonReader.nextString()));
        }

        @Override
        public void write(JsonWriter jsonWriter, T object) throws IOException {
            object = object == null ? null : this.constantToName.get(object);
            jsonWriter.value((String)object);
        }
    }
}

