/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core;

import com.quickblox.core.LogLevel;
import com.quickblox.core.TransferProtocol;
import com.quickblox.core.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class QBSettings {
    static QBSettings qbSettings;
    private String applicationId;
    private String authorizationKey;
    private String authorizationSecret;
    private String chatServerDomain = "chat.quickblox.com";
    private String contentBucketName = "qbprod";
    private LogLevel logLevel;
    private String restApiVersion = "0.1.1";
    private String serverDomain = "api.quickblox.com";
    private TransferProtocol transferProtocol = TransferProtocol.HTTPS;
    private String turnServerDomain = "turnserver.quickblox.com";
    private String versionCode;
    private String versionName;

    private QBSettings() {
        this.logLevel = LogLevel.DEBUG;
        this.loadProperties();
    }

    public static QBSettings getInstance() {
        synchronized (QBSettings.class) {
            QBSettings qBSettings;
            if (qbSettings == null) {
                qbSettings = qBSettings = new QBSettings();
            }
            qBSettings = qbSettings;
            return qBSettings;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadProperties() {
        Throwable throwable2222222;
        InputStream inputStream;
        block5: {
            InputStream inputStream2;
            block4: {
                this.versionCode = "0";
                this.versionName = "0.0.0";
                Properties properties = new Properties();
                InputStream inputStream3 = null;
                inputStream = null;
                inputStream2 = this.getClass().getResourceAsStream("version.properties");
                if (inputStream2 == null) break block4;
                inputStream = inputStream2;
                inputStream3 = inputStream2;
                properties.load(inputStream2);
                inputStream = inputStream2;
                inputStream3 = inputStream2;
                this.versionCode = properties.getProperty("versionCode", "0");
                inputStream = inputStream2;
                inputStream3 = inputStream2;
                this.versionName = properties.getProperty("versionName", "0.0.0");
                {
                    catch (Throwable throwable2222222) {
                        break block5;
                    }
                    catch (IOException iOException) {}
                    inputStream = inputStream3;
                    {
                        iOException.printStackTrace();
                    }
                    IOUtils.closeInputStreams(inputStream3);
                    return;
                }
            }
            IOUtils.closeInputStreams(inputStream2);
            return;
        }
        IOUtils.closeInputStreams(inputStream);
        throw throwable2222222;
    }

    public QBSettings fastConfigInit(String string2, String string3, String string4) {
        this.applicationId = string2;
        this.authorizationKey = string3;
        this.authorizationSecret = string4;
        return this;
    }

    public String getApiVersion() {
        return this.restApiVersion;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getAuthorizationKey() {
        return this.authorizationKey;
    }

    public String getAuthorizationSecret() {
        return this.authorizationSecret;
    }

    public String getChatServerDomain() {
        return this.chatServerDomain;
    }

    public String getContentBucketName() {
        return this.contentBucketName;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String getServerApiDomain() {
        return this.serverDomain;
    }

    public TransferProtocol getTransferProtocol() {
        return this.transferProtocol;
    }

    public String getTurnServerDomain() {
        return this.turnServerDomain;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public QBSettings setApiVersion(String string2) {
        this.restApiVersion = string2;
        return this;
    }

    public QBSettings setApplicationId(String string2) {
        this.applicationId = string2;
        return this;
    }

    public QBSettings setAuthorizationKey(String string2) {
        this.authorizationKey = string2;
        return this;
    }

    public QBSettings setAuthorizationSecret(String string2) {
        this.authorizationSecret = string2;
        return this;
    }

    public QBSettings setChatServerDomain(String string2) {
        this.chatServerDomain = string2;
        return this;
    }

    public QBSettings setContentBucketName(String string2) {
        this.contentBucketName = string2;
        return this;
    }

    public QBSettings setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public QBSettings setServerApiDomain(String string2) {
        this.serverDomain = string2;
        return this;
    }

    public QBSettings setTransferProtocol(TransferProtocol transferProtocol) {
        this.transferProtocol = transferProtocol;
        return this;
    }

    public QBSettings setTurnServerDomain(String string2) {
        this.turnServerDomain = string2;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("QBSettings{applicationId=");
        stringBuilder.append(this.applicationId);
        stringBuilder.append(", authorizationKey='");
        stringBuilder.append(this.authorizationKey);
        stringBuilder.append('\'');
        stringBuilder.append(", authorizationSecret='");
        stringBuilder.append(this.authorizationSecret);
        stringBuilder.append('\'');
        stringBuilder.append(", transferProtocol=");
        stringBuilder.append((Object)this.transferProtocol);
        stringBuilder.append(", logLevel=");
        stringBuilder.append((Object)this.logLevel);
        stringBuilder.append(", chatServerDomain='");
        stringBuilder.append(this.chatServerDomain);
        stringBuilder.append('\'');
        stringBuilder.append(", serverDomain='");
        stringBuilder.append(this.serverDomain);
        stringBuilder.append('\'');
        stringBuilder.append(", restApiVersion='");
        stringBuilder.append(this.restApiVersion);
        stringBuilder.append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

