/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeInputStreams(InputStream ... inputStreamArray) {
        for (InputStream inputStream : inputStreamArray) {
            if (inputStream == null) continue;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void closeOutputStreams(OutputStream ... outputStreamArray) {
        for (OutputStream outputStream : outputStreamArray) {
            if (outputStream == null) continue;
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = IOUtils.copyLarge(inputStream, outputStream);
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }
}

