/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.parser;

import android.os.Bundle;
import com.qb.gson.Gson;
import com.qb.gson.GsonBuilder;
import com.qb.gson.JsonDeserializer;
import com.qb.gson.JsonIOException;
import com.qb.gson.JsonSyntaxException;
import com.quickblox.core.exception.QBResponseException;
import com.quickblox.core.model.QBEntityWrap;
import com.quickblox.core.parser.QBResponseParser;
import com.quickblox.core.query.JsonQuery;
import com.quickblox.core.rest.RestResponse;
import com.quickblox.core.result.RestResult;
import com.quickblox.core.result.Result;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class QBJsonParser<T>
implements QBResponseParser<T> {
    private Bundle additionalResult = new Bundle();
    protected Type deserializer;
    protected boolean isCancel = false;
    private JsonQuery query;
    protected JsonDeserializer typeAdapterForDeserializer;
    protected Type typeForDeserializer;
    private Map<Type, Object> typesAdapterForDeserializer;

    public QBJsonParser(JsonQuery jsonQuery) {
        this.query = jsonQuery;
    }

    private boolean buildGsonFromMap(GsonBuilder gsonBuilder) {
        Map<Type, Object> map = this.typesAdapterForDeserializer;
        boolean bl = map != null && !map.isEmpty();
        if (bl) {
            for (Map.Entry entry : this.typesAdapterForDeserializer.entrySet()) {
                gsonBuilder.registerTypeAdapter((Type)entry.getKey(), entry.getValue());
            }
        }
        return bl;
    }

    private void setBundle(Bundle bundle) {
        this.additionalResult = bundle;
    }

    @Override
    public void cancel() {
        this.isCancel = true;
    }

    protected T extractEntity(Object object) {
        Object object2 = object;
        if (object != null) {
            object2 = object;
            if (object instanceof QBEntityWrap) {
                object2 = ((QBEntityWrap)object).getEntity();
            }
        }
        return (T)object2;
    }

    protected Bundle getBundle() {
        return this.additionalResult;
    }

    protected Class getResultClass() {
        return Result.class;
    }

    public void initParser(Type type, Type type2, JsonDeserializer jsonDeserializer) {
        this.setDeserializer(type);
        if (type2 != null) {
            type = type2;
        }
        this.putJsonTypeAdapter(type, jsonDeserializer);
    }

    @Override
    public T parse(RestResponse restResponse, Bundle object) throws QBResponseException {
        this.setBundle((Bundle)object);
        object = new Result();
        ((RestResult)object).setQuery(this.query);
        ((RestResult)object).setResponse(restResponse);
        if (((Result)object).isSuccess()) {
            return this.extractEntity(this.parseJsonResponse(restResponse, (Result)object));
        }
        throw new QBResponseException(((RestResult)object).getErrors());
    }

    protected Object parseJsonResponse(RestResponse object, Result object2) throws QBResponseException {
        if (this.deserializer != null) {
            JsonDeserializer jsonDeserializer;
            object2 = ((RestResponse)object).getRawBody();
            GsonBuilder gsonBuilder = new GsonBuilder();
            if (!this.buildGsonFromMap(gsonBuilder) && (jsonDeserializer = this.typeAdapterForDeserializer) != null) {
                object = this.typeForDeserializer;
                if (object == null) {
                    object = this.deserializer;
                }
                gsonBuilder.registerTypeAdapter((Type)object, jsonDeserializer);
            }
            object = gsonBuilder.create();
            try {
                object = ((Gson)object).fromJson((String)object2, this.deserializer);
            }
            catch (JsonIOException jsonIOException) {
                throw new QBResponseException(jsonIOException.getLocalizedMessage());
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                throw new QBResponseException(jsonSyntaxException.getLocalizedMessage());
            }
        } else {
            object = null;
        }
        return object;
    }

    public void putJsonTypeAdapter(Type type, Object object) {
        if (this.typesAdapterForDeserializer == null) {
            this.typesAdapterForDeserializer = new HashMap<Type, Object>();
        }
        this.typesAdapterForDeserializer.put(type, object);
    }

    public void setDeserializer(Type type) {
        this.deserializer = type;
    }

    public void setTypeAdapterForDeserializer(JsonDeserializer jsonDeserializer) {
        this.typeAdapterForDeserializer = jsonDeserializer;
    }

    public void setTypeForDeserializer(Type type) {
        this.typeForDeserializer = type;
    }
}

