/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.parser;

import android.os.Bundle;
import com.quickblox.core.exception.QBResponseException;
import com.quickblox.core.parser.QBResponseParser;
import com.quickblox.core.parser.xml.XMLDeserializer;
import com.quickblox.core.parser.xml.exception.QBXMLParserSyntaxException;
import com.quickblox.core.query.Query;
import com.quickblox.core.rest.RestResponse;
import com.quickblox.core.result.Result;
import java.util.concurrent.atomic.AtomicBoolean;

public class QBXmlParser<T>
implements QBResponseParser<T> {
    protected AtomicBoolean canceled = new AtomicBoolean(false);
    protected Class deserializer;
    private Query query;

    public QBXmlParser(Query query) {
        this.query = query;
    }

    @Override
    public void cancel() {
        this.canceled.set(true);
    }

    protected Class getResultClass() {
        return Result.class;
    }

    @Override
    public T parse(RestResponse restResponse, Bundle object) throws QBResponseException {
        object = new XMLDeserializer.Builder();
        ((XMLDeserializer.Builder)object).registerDeserializer(this.deserializer);
        object = ((XMLDeserializer.Builder)object).build();
        try {
            restResponse = ((XMLDeserializer)object).deserialize(this.deserializer, restResponse.getRawBody());
        }
        catch (QBXMLParserSyntaxException qBXMLParserSyntaxException) {
            throw new QBResponseException(qBXMLParserSyntaxException.getLocalizedMessage());
        }
        return (T)restResponse;
    }

    public void setDeserializer(Class clazz) {
        this.deserializer = clazz;
    }
}

