/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.parser.xml;

import com.quickblox.core.parser.xml.XMLHandler;
import com.quickblox.core.parser.xml.exception.QBXMLParserSyntaxException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDeserializer {
    private Set<Class> deserializers = new HashSet<Class>();

    public XMLDeserializer(Builder builder) {
        this.deserializers = builder.deserializers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T deserialize(Class<T> xMLHandler, String object) throws QBXMLParserSyntaxException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        object = new InputSource(new StringReader((String)object));
        xMLHandler = new XMLHandler(xMLHandler);
        try {
            sAXParserFactory.newSAXParser().parse((InputSource)object, xMLHandler);
            return xMLHandler.produceInstance();
        }
        catch (IOException iOException) {
            throw new QBXMLParserSyntaxException(iOException.getLocalizedMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new QBXMLParserSyntaxException(parserConfigurationException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            return xMLHandler.produceInstance();
        }
    }

    public static class Builder {
        private Set<Class> deserializers = new HashSet<Class>();

        public XMLDeserializer build() {
            return new XMLDeserializer(this);
        }

        public Builder registerDeserializer(Class clazz) {
            this.deserializers.add(clazz);
            return this;
        }
    }
}

