/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.rest;

import com.quickblox.core.QBProgressCallback;
import com.quickblox.core.QBSettings;
import com.quickblox.core.RestMethod;
import com.quickblox.core.helper.StringUtils;
import com.quickblox.core.helper.ToStringHelper;
import com.quickblox.core.interfaces.QBCancelable;
import com.quickblox.core.request.ProgressHttpEntityWrapper;
import com.quickblox.core.rest.RestResponse;
import com.quickblox.core.server.HttpRequestTask;
import com.quickblox.core.server.RestRequestCallback;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.message.BasicNameValuePair;

public class RestRequest
implements QBCancelable {
    private HttpEntity body;
    private RestRequestCallback callback;
    private Map<String, String> headers;
    private RestMethod method;
    private MultipartEntity multipartEntity;
    private Map<String, Object> parameters;
    private QBProgressCallback progressCallback;
    QBSettings qbSettings;
    private HttpRequestTask requestTask;
    private URL url;
    private UUID uuid = UUID.randomUUID();

    public RestRequest() {
        this.qbSettings = QBSettings.getInstance();
    }

    private String getEncodedParamsOnlyString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.parameters;
        if (object != null && object.size() > 0) {
            for (String string2 : this.parameters.keySet()) {
                object = this.parameters.get(string2).toString();
                if (object == null) continue;
                try {
                    String string3 = URLEncoder.encode((String)object, "UTF-8");
                    object = string3;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                stringBuilder.append(String.format("%s=%s&", string2, object));
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private HttpRequestBase getHttpRequest() {
        Object object;
        HttpGet httpGet;
        int n;
        if (this.method == null) {
            this.method = RestMethod.GET;
        }
        if ((n = 1.$SwitchMap$com$quickblox$core$RestMethod[this.method.ordinal()]) != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        httpGet = null;
                    } else {
                        httpGet = new HttpPut(this.getFinalURL().toString());
                        httpGet.setEntity(this.getBody());
                    }
                } else {
                    httpGet = new HttpPost(this.getFinalURL().toString());
                    object = this.multipartEntity;
                    if (object != null) {
                        if (this.progressCallback == null) {
                            httpGet.setEntity((HttpEntity)object);
                        } else {
                            httpGet.setEntity((HttpEntity)new ProgressHttpEntityWrapper((HttpEntity)this.multipartEntity, this.progressCallback));
                        }
                    } else {
                        httpGet.setEntity(this.getBody());
                    }
                }
            } else {
                httpGet = new HttpDelete(this.getFinalURL().toString());
            }
        } else {
            httpGet = new HttpGet(this.getFinalURL().toString());
            if (this.progressCallback != null) {
                httpGet.addHeader("progress_callback_enabled", "enabled");
            } else {
                httpGet = new HttpGet(this.getFinalURL().toString());
            }
        }
        object = this.headers;
        if (object != null) {
            for (String string2 : object.keySet()) {
                httpGet.addHeader(string2, this.headers.get(string2));
            }
        }
        return httpGet;
    }

    public void asyncRequestWithCallback(RestRequestCallback object) {
        HttpRequestTask httpRequestTask;
        this.callback = object;
        HttpRequestBase httpRequestBase = this.getHttpRequest();
        this.requestTask = httpRequestTask = new HttpRequestTask();
        object = this.progressCallback;
        if (object != null) {
            httpRequestTask.setProgressCallback((QBProgressCallback)object);
        }
        this.requestTask.execute(this.callback, httpRequestBase, this.uuid);
    }

    @Override
    public void cancel() {
        this.requestTask.cancel();
    }

    public HttpEntity getBody() {
        Object object;
        block7: {
            Object object2;
            object = object2 = this.body;
            if (object2 == null) {
                if ((this.method == RestMethod.POST || this.method == RestMethod.PUT) && this.parameters.size() > 0) {
                    object2 = new ArrayList();
                    for (String string2 : this.parameters.keySet()) {
                        Iterator iterator2 = this.parameters.get(string2);
                        if (iterator2 instanceof List) {
                            iterator2 = ((List)((Object)iterator2)).iterator();
                            while (iterator2.hasNext()) {
                                object2.add(new BasicNameValuePair(string2, iterator2.next().toString()));
                            }
                            continue;
                        }
                        object2.add(new BasicNameValuePair(string2, iterator2.toString()));
                    }
                    try {
                        object = new UrlEncodedFormEntity((List)object2, "UTF-8");
                        break block7;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                }
                object = null;
            }
        }
        return object;
    }

    public URL getFinalURL() {
        if (this.method != RestMethod.GET && this.method != RestMethod.DELETE) {
            return this.getUrl();
        }
        Object object = this.getUrlWithParamsString();
        try {
            object = new URL((String)object);
            return object;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        return this.headers;
    }

    public RestMethod getMethod() {
        return this.method;
    }

    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        return this.parameters;
    }

    public String getParamsOnlyString() {
        return this.getEncodedParamsOnlyString(true);
    }

    public String getParamsOnlyStringNotEncoded() {
        return this.getEncodedParamsOnlyString(false);
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUrlWithParamsString() {
        StringBuilder stringBuilder = new StringBuilder(this.getUrl().toString());
        if (!StringUtils.isEmpty(this.getParamsOnlyString())) {
            stringBuilder.append("?");
        }
        stringBuilder.append(this.getParamsOnlyString());
        return stringBuilder.toString();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = map;
    }

    public void setMethod(RestMethod restMethod) {
        this.method = restMethod;
    }

    public void setMultipartEntity(MultipartEntity multipartEntity) {
        this.multipartEntity = multipartEntity;
    }

    public void setParameters(Map<String, Object> map) {
        this.parameters = map;
    }

    public void setProgressCallback(QBProgressCallback qBProgressCallback) {
        this.progressCallback = qBProgressCallback;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public RestResponse syncRequest() {
        HttpRequestTask httpRequestTask;
        HttpRequestBase httpRequestBase = this.getHttpRequest();
        this.requestTask = httpRequestTask = new HttpRequestTask();
        QBProgressCallback qBProgressCallback = this.progressCallback;
        if (qBProgressCallback != null) {
            httpRequestTask.setProgressCallback(qBProgressCallback);
        }
        return this.requestTask.executeSync(httpRequestBase, this.uuid);
    }

    public String toString() {
        return String.format("=========================================================\n=== REQUEST ==== %s ===\nREQUEST\n    %s %s\nHEADERS\n%s\nPARAMETERS\n%s\nINLINE\n    %s %s", new Object[]{String.valueOf(this.uuid), this.method, this.getUrl().toString(), ToStringHelper.toString(this.getHeaders(), "    "), ToStringHelper.toString(this.getParameters(), "    "), this.method, this.getUrlWithParamsString()});
    }
}

