/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.rest;

import com.quickblox.core.helper.ToStringHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class RestResponse {
    private byte[] content;
    private final HttpResponse httpResponse;
    private IOException ioException;
    private String responseBodyString;
    private UUID uuid;

    public RestResponse(HttpResponse httpResponse, UUID uUID, IOException iOException) {
        this.uuid = uUID;
        this.httpResponse = httpResponse;
        this.ioException = iOException;
    }

    public byte[] getContent() {
        return this.content;
    }

    public InputStream getContentStream() {
        return new ByteArrayInputStream(this.getContent());
    }

    public String getContentType() {
        HttpResponse httpResponse = this.httpResponse;
        if (httpResponse != null) {
            httpResponse.getFirstHeader("Content-Type").getValue();
        }
        return null;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HttpResponse httpResponse2 = this.httpResponse;
        if (httpResponse2 != null) {
            for (Header header : httpResponse2.getAllHeaders()) {
                hashMap.put(header.getName(), header.getValue());
            }
        }
        return hashMap;
    }

    public IOException getIOException() {
        return this.ioException;
    }

    public String getRawBody() {
        if (this.responseBodyString == null) {
            this.responseBodyString = this.getContent() != null ? new String(this.getContent()) : "";
        }
        return this.responseBodyString;
    }

    public int getStatusCode() {
        HttpResponse httpResponse = this.httpResponse;
        if (httpResponse != null) {
            return httpResponse.getStatusLine().getStatusCode();
        }
        return 0;
    }

    public void setContent(byte[] byArray) {
        this.content = byArray;
    }

    public String toString() {
        return String.format("*********************************************************\n*** RESPONSE *** %s ***\nSTATUS : %s \nHEADERS\n%s\nBODY\n    '%s'\n\n", String.valueOf(this.uuid), this.getStatusCode(), ToStringHelper.toString(new TreeMap<String, String>(this.getHeaders()), "    "), this.getRawBody());
    }
}

