/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.server;

import com.quickblox.core.QBSettings;
import com.quickblox.core.exception.BaseServiceException;
import java.util.Date;
import java.util.TimeZone;

public class BaseService {
    private static BaseService baseService;
    private String token;
    private Date tokenExpirationDate;

    protected BaseService() {
    }

    protected static void createBaseService() {
        if (baseService == null) {
            baseService = new BaseService();
        }
    }

    public static BaseService createFromExistentToken(String string2, Date date) throws BaseServiceException {
        if (string2 != null && date != null) {
            BaseService baseService;
            BaseService baseService2 = null;
            try {
                baseService2 = baseService = BaseService.getBaseService();
            }
            catch (BaseServiceException baseServiceException) {
                // empty catch block
            }
            baseService = baseService2;
            if (baseService2 == null) {
                BaseService.createBaseService();
                baseService = BaseService.baseService;
            }
            if (baseService != null) {
                baseService.setToken(string2);
                baseService.setTokenExpirationDate(date);
            }
            return baseService;
        }
        return BaseService.getBaseService();
    }

    public static BaseService getBaseService() throws BaseServiceException {
        synchronized (BaseService.class) {
            Object object;
            block4: {
                object = baseService;
                if (object == null) break block4;
                return object;
            }
            String string2 = String.format("\nYou have missed the authorization call.\nPlease insert following code inside your application:\n    QBAuth.createSession(new QBCallback() { ... });\nbefore any other code, that uses our service. Thank you.", BaseService.class.getName());
            object = new BaseServiceException(string2);
            throw object;
        }
    }

    public static String getServiceEndpointURL() {
        return String.format("%s://%s", new Object[]{QBSettings.getInstance().getTransferProtocol(), QBSettings.getInstance().getServerApiDomain()});
    }

    public String getToken() {
        return this.token;
    }

    public Date getTokenExpirationDate() {
        return this.tokenExpirationDate;
    }

    public void resetCredentials() {
        this.token = null;
    }

    public void setToken(String string2) {
        this.token = string2;
    }

    public void setTokenExpirationDate(Date date) {
        int n = TimeZone.getDefault().getOffset(System.currentTimeMillis());
        this.tokenExpirationDate = new Date(date.getTime() + (long)n);
    }
}

