/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.core.server;

import android.os.Handler;
import android.os.Message;
import com.quickblox.core.QBProgressCallback;
import com.quickblox.core.io.ByteStreams;
import com.quickblox.core.rest.RestResponse;
import com.quickblox.core.server.HttpExecutor;
import com.quickblox.core.server.RestRequestCallback;
import java.io.IOException;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class HttpRequestRunnable
implements Runnable {
    private final int EMPTY_MSG;
    private HttpRequestBase httpRequestBase;
    private IOException ioException;
    private QBProgressCallback progressCallback;
    private RestRequestCallback requestCallback;
    private Handler requestHandler;
    private RestResponse restResponse;
    private UUID uuid;

    public HttpRequestRunnable(RestRequestCallback restRequestCallback, UUID uUID, HttpRequestBase httpRequestBase) {
        this.EMPTY_MSG = 0;
        this.uuid = uUID;
        this.httpRequestBase = httpRequestBase;
        this.requestCallback = restRequestCallback;
        this.requestHandler = new Handler(){

            public void handleMessage(Message message) {
                if (HttpRequestRunnable.this.requestCallback != null) {
                    HttpRequestRunnable.this.requestCallback.completedWithResponse(HttpRequestRunnable.this.restResponse);
                }
            }
        };
    }

    public HttpRequestRunnable(RestRequestCallback restRequestCallback, UUID uUID, HttpRequestBase httpRequestBase, QBProgressCallback qBProgressCallback) {
        this.EMPTY_MSG = 0;
        this.uuid = uUID;
        this.httpRequestBase = httpRequestBase;
        this.requestCallback = restRequestCallback;
        this.progressCallback = qBProgressCallback;
        this.requestHandler = new Handler(){

            public void handleMessage(Message message) {
                if (HttpRequestRunnable.this.requestCallback != null) {
                    HttpRequestRunnable.this.requestCallback.completedWithResponse(HttpRequestRunnable.this.restResponse);
                }
            }
        };
    }

    private static boolean isProgresCallbackRequired(HttpRequestBase headerArray) {
        headerArray = headerArray.getAllHeaders();
        int n = headerArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Header header = headerArray[i];
            if (!header.getName().equals("progress_callback_enabled")) continue;
            bl = header.getValue().equals("enabled");
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.restResponse = null;
        try {
            RestResponse restResponse;
            QBProgressCallback qBProgressCallback = this.progressCallback;
            qBProgressCallback = qBProgressCallback == null ? HttpExecutor.execute(this.httpRequestBase) : HttpExecutor.execute(this.httpRequestBase, qBProgressCallback);
            this.restResponse = restResponse = new RestResponse((HttpResponse)qBProgressCallback, this.uuid, this.ioException);
            restResponse.setContent(ByteStreams.toByteArray(qBProgressCallback.getEntity().getContent()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.ioException = iOException;
        }
        this.requestHandler.sendEmptyMessage(0);
    }
}

