/*
 * Decompiled with CFR 0.152.
 */
package com.quickblox.users.model;

import com.qb.gson.annotations.SerializedName;
import com.quickblox.core.helper.StringifyArrayList;
import com.quickblox.core.model.QBEntity;
import com.quickblox.users.helper.CustomDataObjectParserHelper;
import java.util.Date;

public class QBUser
extends QBEntity {
    @SerializedName(value="blob_id")
    protected Integer blobId;
    @SerializedName(value="custom_data")
    private String customData;
    private Class customDataClass;
    protected String email;
    @SerializedName(value="external_user_id")
    protected String externalId;
    @SerializedName(value="facebook_id")
    protected String facebookId;
    @SerializedName(value="full_name")
    protected String fullName;
    @SerializedName(value="last_request_at")
    protected Date lastRequestAt;
    protected String login;
    protected String oldPassword;
    protected String password;
    protected String phone;
    @SerializedName(value="user_tags")
    protected String tags;
    @SerializedName(value="twitter_id")
    protected String twitterId;
    protected String website;

    public QBUser() {
    }

    public QBUser(Integer n) {
        this.id = n;
    }

    public QBUser(String string2) {
        this.login = string2;
    }

    public QBUser(String string2, String string3) {
        this.login = string2;
        this.password = string3;
    }

    public QBUser(String string2, String string3, String string4) {
        this.login = string2;
        this.password = string3;
        this.email = string4;
    }

    public void copyFieldsTo(QBUser qBUser) {
        if (qBUser != null) {
            super.copyFieldsTo(qBUser);
            qBUser.setFullName(this.fullName);
            qBUser.setEmail(this.email);
            qBUser.setLogin(this.login);
            qBUser.setPhone(this.phone);
            qBUser.setWebsite(this.website);
            qBUser.setLastRequestAt(this.lastRequestAt);
            qBUser.setExternalId(this.externalId);
            qBUser.setFacebookId(this.facebookId);
            qBUser.setTwitterId(this.twitterId);
            qBUser.setCustomData(this.customData);
            qBUser.tags = this.tags;
        }
    }

    public String getCustomData() {
        return this.customData;
    }

    public Object getCustomDataAsObject() {
        return CustomDataObjectParserHelper.parseStringToObject(this.customDataClass, this.customData);
    }

    public String getEmail() {
        return this.email;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getFacebookId() {
        return this.facebookId;
    }

    public Integer getFileId() {
        return this.blobId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Date getLastRequestAt() {
        return this.lastRequestAt;
    }

    public String getLogin() {
        return this.login;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPhone() {
        return this.phone;
    }

    public StringifyArrayList<String> getTags() {
        StringifyArrayList<String> stringifyArrayList = new StringifyArrayList<String>();
        String[] stringArray = this.tags;
        if (stringArray != null) {
            stringArray = stringArray.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringifyArrayList.add(stringArray[i].trim());
            }
        }
        return stringifyArrayList;
    }

    public String getTwitterId() {
        return this.twitterId;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setCustomData(String string2) {
        this.customData = string2;
    }

    public void setCustomDataAsObject(Object object) {
        this.customData = CustomDataObjectParserHelper.parseCustomDataObjectToString(object);
    }

    public void setCustomDataClass(Class clazz) {
        this.customDataClass = clazz;
    }

    public void setEmail(String string2) {
        this.email = string2;
    }

    public void setExternalId(String string2) {
        this.externalId = string2;
    }

    public void setFacebookId(String string2) {
        this.facebookId = string2;
    }

    public void setFileId(Integer n) {
        this.blobId = n;
    }

    public void setFullName(String string2) {
        this.fullName = string2;
    }

    public void setLastRequestAt(Date date) {
        this.lastRequestAt = date;
    }

    public void setLogin(String string2) {
        this.login = string2;
    }

    public void setOldPassword(String string2) {
        this.oldPassword = string2;
    }

    public void setPassword(String string2) {
        this.password = string2;
    }

    public void setPhone(String string2) {
        this.phone = string2;
    }

    public void setTags(StringifyArrayList<String> stringifyArrayList) {
        this.tags = stringifyArrayList.getItemsAsString();
    }

    public void setTwitterId(String string2) {
        this.twitterId = string2;
    }

    public void setWebsite(String string2) {
        this.website = string2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("QBUser{id=");
        stringBuilder.append(this.id);
        stringBuilder.append(", createdAt=");
        stringBuilder.append(this.createdAt);
        stringBuilder.append(", updatedAt=");
        stringBuilder.append(this.updatedAt);
        stringBuilder.append(", fullName='");
        stringBuilder.append(this.fullName);
        stringBuilder.append('\'');
        stringBuilder.append(", email='");
        stringBuilder.append(this.email);
        stringBuilder.append('\'');
        stringBuilder.append(", login='");
        stringBuilder.append(this.login);
        stringBuilder.append('\'');
        stringBuilder.append(", phone='");
        stringBuilder.append(this.phone);
        stringBuilder.append('\'');
        stringBuilder.append(", website='");
        stringBuilder.append(this.website);
        stringBuilder.append('\'');
        stringBuilder.append(", lastRequestAt='");
        stringBuilder.append(this.lastRequestAt);
        stringBuilder.append('\'');
        stringBuilder.append(", externalId=");
        stringBuilder.append(this.externalId);
        stringBuilder.append(", facebookId=");
        stringBuilder.append(this.facebookId);
        stringBuilder.append(", twitterId=");
        stringBuilder.append(this.twitterId);
        stringBuilder.append(", blobId=");
        stringBuilder.append(this.blobId);
        stringBuilder.append(", tags='");
        stringBuilder.append(this.tags);
        stringBuilder.append('\'');
        stringBuilder.append(", password='");
        stringBuilder.append(this.password);
        stringBuilder.append('\'');
        stringBuilder.append(", oldPassword='");
        stringBuilder.append(this.oldPassword);
        stringBuilder.append('\'');
        stringBuilder.append(", customData='");
        stringBuilder.append(this.customData);
        stringBuilder.append('\'');
        stringBuilder.append("}");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

