/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.javascript;

import java.util.Objects;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class JSAdapter
implements Scriptable,
Function {
    private static final String DEL_PROP = "__delete__";
    private static final String GET_PROP = "__get__";
    private static final String GET_PROPIDS = "__getIds__";
    private static final String HAS_PROP = "__has__";
    private static final String PUT_PROP = "__put__";
    private Scriptable adaptee;
    private boolean isPrototype;
    private Scriptable parent;
    private Scriptable prototype;

    private JSAdapter(Scriptable scriptable) {
        this.setAdaptee(scriptable);
    }

    private Object call(Function object, Object[] objectArray) {
        Context context = Context.getCurrentContext();
        Scriptable scriptable = this.getAdaptee();
        Scriptable scriptable2 = object.getParentScope();
        try {
            object = object.call(context, scriptable2, scriptable, objectArray);
            return object;
        }
        catch (RhinoException rhinoException) {
            throw Context.reportRuntimeError((String)rhinoException.getMessage());
        }
    }

    private Function getAdapteeFunction(String object) {
        object = ScriptableObject.getProperty((Scriptable)this.getAdaptee(), (String)object);
        object = object instanceof Function ? (Function)object : null;
        return object;
    }

    private static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return ScriptableObject.getFunctionPrototype((Scriptable)scriptable);
    }

    public static void init(Context object, Scriptable scriptable, boolean bl) throws RhinoException {
        object = new JSAdapter(object.newObject(scriptable));
        ((JSAdapter)object).setParentScope(scriptable);
        ((JSAdapter)object).setPrototype(JSAdapter.getFunctionPrototype(scriptable));
        ((JSAdapter)object).isPrototype = true;
        ScriptableObject.defineProperty((Scriptable)scriptable, (String)"JSAdapter", (Object)object, (int)2);
    }

    private Object mapToId(Object object) {
        if (object instanceof Double) {
            return new Integer(((Double)object).intValue());
        }
        return Context.toString((Object)object);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws RhinoException {
        if (this.isPrototype) {
            return this.construct(context, scriptable, objectArray);
        }
        scriptable2 = this.getAdaptee();
        if (scriptable2 instanceof Function) {
            return ((Function)scriptable2).call(context, scriptable, scriptable2, objectArray);
        }
        throw Context.reportRuntimeError((String)"TypeError: not a function");
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws RhinoException {
        if (this.isPrototype) {
            context = ScriptableObject.getTopLevelScope((Scriptable)scriptable);
            if (objectArray.length > 0) {
                return new JSAdapter(Context.toObject((Object)objectArray[0], (Scriptable)context));
            }
            throw Context.reportRuntimeError((String)"JSAdapter requires adaptee");
        }
        Scriptable scriptable2 = this.getAdaptee();
        if (scriptable2 instanceof Function) {
            return ((Function)scriptable2).construct(context, scriptable, objectArray);
        }
        throw Context.reportRuntimeError((String)"TypeError: not a constructor");
    }

    public void delete(int n) {
        Function function = this.getAdapteeFunction(DEL_PROP);
        if (function != null) {
            this.call(function, new Object[]{new Integer(n)});
        } else {
            this.getAdaptee().delete(n);
        }
    }

    public void delete(String string2) {
        Function function = this.getAdapteeFunction(DEL_PROP);
        if (function != null) {
            this.call(function, new Object[]{string2});
        } else {
            this.getAdaptee().delete(string2);
        }
    }

    public Object get(int n, Scriptable scriptable) {
        scriptable = this.getAdapteeFunction(GET_PROP);
        if (scriptable != null) {
            return this.call((Function)scriptable, new Object[]{new Integer(n)});
        }
        scriptable = this.getAdaptee();
        return scriptable.get(n, scriptable);
    }

    public Object get(String string2, Scriptable scriptable) {
        scriptable = this.getAdapteeFunction(GET_PROP);
        if (scriptable != null) {
            return this.call((Function)scriptable, new Object[]{string2});
        }
        scriptable = this.getAdaptee();
        return scriptable.get(string2, scriptable);
    }

    public Scriptable getAdaptee() {
        return this.adaptee;
    }

    public String getClassName() {
        return "JSAdapter";
    }

    public Object getDefaultValue(Class clazz) {
        return this.getAdaptee().getDefaultValue(clazz);
    }

    public Object[] getIds() {
        Object object = this.getAdapteeFunction(GET_PROPIDS);
        if (object != null) {
            int n;
            int n2 = 0;
            if ((object = this.call((Function)object, new Object[0])) instanceof NativeArray) {
                object = (NativeArray)object;
                n2 = (int)object.getLength();
                Object[] objectArray = new Object[n2];
                for (n = 0; n < n2; ++n) {
                    objectArray[n] = this.mapToId(object.get(n, (Scriptable)object));
                }
                return objectArray;
            }
            if (object instanceof NativeJavaArray) {
                if ((object = ((NativeJavaArray)object).unwrap()).getClass() == Object[].class) {
                    Object[] objectArray = (Object[])object;
                    Object[] objectArray2 = new Object[objectArray.length];
                    n = n2;
                    while (true) {
                        object = objectArray2;
                        if (n < objectArray.length) {
                            objectArray2[n] = this.mapToId(objectArray[n]);
                            ++n;
                            continue;
                        }
                        break;
                    }
                } else {
                    object = Context.emptyArgs;
                }
                return object;
            }
            return Context.emptyArgs;
        }
        return this.getAdaptee().getIds();
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public boolean has(int n, Scriptable scriptable) {
        scriptable = this.getAdapteeFunction(HAS_PROP);
        if (scriptable != null) {
            return Context.toBoolean((Object)this.call((Function)scriptable, new Object[]{new Integer(n)}));
        }
        scriptable = this.getAdaptee();
        return scriptable.has(n, scriptable);
    }

    public boolean has(String string2, Scriptable scriptable) {
        scriptable = this.getAdapteeFunction(HAS_PROP);
        if (scriptable != null) {
            return Context.toBoolean((Object)this.call((Function)scriptable, new Object[]{string2}));
        }
        scriptable = this.getAdaptee();
        return scriptable.has(string2, scriptable);
    }

    public boolean hasInstance(Scriptable scriptable) {
        if (scriptable instanceof JSAdapter) {
            return true;
        }
        for (scriptable = scriptable.getPrototype(); scriptable != null; scriptable = scriptable.getPrototype()) {
            if (!scriptable.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            scriptable = this.getAdapteeFunction(PUT_PROP);
            if (scriptable != null) {
                this.call((Function)scriptable, new Object[]{new Integer(n), object});
            } else {
                scriptable = this.getAdaptee();
                scriptable.put(n, scriptable, object);
            }
        } else {
            scriptable.put(n, scriptable, object);
        }
    }

    public void put(String string2, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            scriptable = this.getAdapteeFunction(PUT_PROP);
            if (scriptable != null) {
                this.call((Function)scriptable, new Object[]{string2, object});
            } else {
                scriptable = this.getAdaptee();
                scriptable.put(string2, scriptable, object);
            }
        } else {
            scriptable.put(string2, scriptable, object);
        }
    }

    public void setAdaptee(Scriptable scriptable) {
        Objects.requireNonNull(scriptable, "adaptee can not be null");
        this.adaptee = scriptable;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }
}

