/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithmsDD;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.math.MathUtil;

public class CGAlgorithms {
    public static final int CLOCKWISE = -1;
    public static final int COLLINEAR = 0;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int RIGHT = -1;
    public static final int STRAIGHT = 0;

    public static int computeOrientation(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return CGAlgorithms.orientationIndex(coordinate, coordinate2, coordinate3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static double distanceLineLine(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d;
        if (coordinate.equals(coordinate2)) {
            return CGAlgorithms.distancePointLine(coordinate, coordinate3, coordinate4);
        }
        if (coordinate3.equals(coordinate4)) {
            return CGAlgorithms.distancePointLine(coordinate4, coordinate, coordinate2);
        }
        if (Envelope.intersects(coordinate, coordinate2, coordinate3, coordinate4) && (d = (coordinate2.x - coordinate.x) * (coordinate4.y - coordinate3.y) - (coordinate2.y - coordinate.y) * (coordinate4.x - coordinate3.x)) != 0.0) {
            double d2 = coordinate.y;
            double d3 = coordinate3.y;
            double d4 = coordinate4.x;
            double d5 = coordinate3.x;
            double d6 = coordinate.x;
            double d7 = coordinate3.x;
            double d8 = coordinate4.y;
            double d9 = coordinate3.y;
            double d10 = ((coordinate.y - coordinate3.y) * (coordinate2.x - coordinate.x) - (coordinate.x - coordinate3.x) * (coordinate2.y - coordinate.y)) / d;
            if (!((d5 = ((d2 - d3) * (d4 - d5) - (d6 - d7) * (d8 - d9)) / d) < 0.0 || d5 > 1.0 || d10 < 0.0)) {
                if (!(d10 > 1.0)) return 0.0;
            }
        }
        boolean bl = true;
        if (!bl) return 0.0;
        return MathUtil.min(CGAlgorithms.distancePointLine(coordinate, coordinate3, coordinate4), CGAlgorithms.distancePointLine(coordinate2, coordinate3, coordinate4), CGAlgorithms.distancePointLine(coordinate3, coordinate, coordinate2), CGAlgorithms.distancePointLine(coordinate4, coordinate, coordinate2));
    }

    public static double distancePointLine(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (coordinate2.x == coordinate3.x && coordinate2.y == coordinate3.y) {
            return coordinate.distance(coordinate2);
        }
        double d = (coordinate3.x - coordinate2.x) * (coordinate3.x - coordinate2.x) + (coordinate3.y - coordinate2.y) * (coordinate3.y - coordinate2.y);
        double d2 = ((coordinate.x - coordinate2.x) * (coordinate3.x - coordinate2.x) + (coordinate.y - coordinate2.y) * (coordinate3.y - coordinate2.y)) / d;
        if (d2 <= 0.0) {
            return coordinate.distance(coordinate2);
        }
        if (d2 >= 1.0) {
            return coordinate.distance(coordinate3);
        }
        return Math.abs(((coordinate2.y - coordinate.y) * (coordinate3.x - coordinate2.x) - (coordinate2.x - coordinate.x) * (coordinate3.y - coordinate2.y)) / d) * Math.sqrt(d);
    }

    public static double distancePointLine(Coordinate coordinate, Coordinate[] coordinateArray) {
        if (coordinateArray.length != 0) {
            int n = 0;
            double d = coordinate.distance(coordinateArray[0]);
            while (true) {
                if (n >= coordinateArray.length - 1) {
                    return d;
                }
                Coordinate coordinate2 = coordinateArray[n];
                int n2 = n + 1;
                double d2 = CGAlgorithms.distancePointLine(coordinate, coordinate2, coordinateArray[n2]);
                n = n2;
                if (!(d2 < d)) continue;
                d = d2;
                n = n2;
            }
        }
        throw new IllegalArgumentException("Line array must contain at least one vertex");
    }

    public static double distancePointLinePerpendicular(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = (coordinate3.x - coordinate2.x) * (coordinate3.x - coordinate2.x) + (coordinate3.y - coordinate2.y) * (coordinate3.y - coordinate2.y);
        return Math.abs(((coordinate2.y - coordinate.y) * (coordinate3.x - coordinate2.x) - (coordinate2.x - coordinate.x) * (coordinate3.y - coordinate2.y)) / d) * Math.sqrt(d);
    }

    public static boolean isCCW(Coordinate[] object) {
        int n = ((Coordinate[])object).length;
        boolean bl = true;
        int n2 = n - 1;
        if (n2 >= 3) {
            Coordinate coordinate = object[0];
            int n3 = 1;
            n = 0;
            while (true) {
                Coordinate coordinate2;
                if (n3 > n2) {
                    int n4;
                    int n5 = n;
                    do {
                        n3 = --n5;
                        if (n5 < 0) {
                            n3 = n2;
                        }
                        if (!object[n3].equals2D(coordinate)) break;
                        n5 = n3;
                    } while (n3 != n);
                    n5 = n;
                    while (object[n4 = (n5 + 1) % n2].equals2D(coordinate)) {
                        n5 = n4;
                        if (n4 != n) continue;
                    }
                    coordinate2 = object[n3];
                    object = object[n4];
                    if (!(coordinate2.equals2D(coordinate) || ((Coordinate)object).equals2D(coordinate) || coordinate2.equals2D((Coordinate)object))) {
                        n = CGAlgorithms.computeOrientation(coordinate2, coordinate, (Coordinate)object);
                        if (!(n == 0 ? coordinate2.x > ((Coordinate)object).x : n > 0)) {
                            bl = false;
                        }
                        return bl;
                    }
                    return false;
                }
                Coordinate coordinate3 = object[n3];
                coordinate2 = coordinate;
                if (coordinate3.y > coordinate.y) {
                    n = n3;
                    coordinate2 = coordinate3;
                }
                ++n3;
                coordinate = coordinate2;
            }
        }
        throw new IllegalArgumentException("Ring has fewer than 4 points, so orientation cannot be determined");
    }

    public static boolean isOnLine(Coordinate coordinate, Coordinate[] coordinateArray) {
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        int n = 1;
        while (n < coordinateArray.length) {
            ((LineIntersector)robustLineIntersector).computeIntersection(coordinate, coordinateArray[n - 1], coordinateArray[n]);
            if (robustLineIntersector.hasIntersection()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isPointInRing(Coordinate coordinate, Coordinate[] coordinateArray) {
        return CGAlgorithms.locatePointInRing(coordinate, coordinateArray) != 2;
    }

    public static double length(CoordinateSequence coordinateSequence) {
        int n = coordinateSequence.size();
        double d = 0.0;
        int n2 = 1;
        if (n <= 1) {
            return 0.0;
        }
        Coordinate coordinate = new Coordinate();
        coordinateSequence.getCoordinate(0, coordinate);
        double d2 = coordinate.x;
        double d3 = coordinate.y;
        while (n2 < n) {
            coordinateSequence.getCoordinate(n2, coordinate);
            double d4 = coordinate.x;
            double d5 = coordinate.y;
            d2 = d4 - d2;
            d3 = d5 - d3;
            d += Math.sqrt(d2 * d2 + d3 * d3);
            ++n2;
            d2 = d4;
            d3 = d5;
        }
        return d;
    }

    public static int locatePointInRing(Coordinate coordinate, Coordinate[] coordinateArray) {
        return RayCrossingCounter.locatePointInRing(coordinate, coordinateArray);
    }

    public static int orientationIndex(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return CGAlgorithmsDD.orientationIndex(coordinate, coordinate2, coordinate3);
    }

    public static double signedArea(CoordinateSequence coordinateSequence) {
        int n = coordinateSequence.size();
        double d = 0.0;
        if (n < 3) {
            return 0.0;
        }
        Coordinate coordinate = new Coordinate();
        Coordinate coordinate2 = new Coordinate();
        Coordinate coordinate3 = new Coordinate();
        coordinateSequence.getCoordinate(0, coordinate2);
        coordinateSequence.getCoordinate(1, coordinate3);
        double d2 = coordinate2.x;
        coordinate3.x -= d2;
        int n2 = 1;
        while (n2 < n - 1) {
            coordinate.y = coordinate2.y;
            coordinate2.x = coordinate3.x;
            coordinate2.y = coordinate3.y;
            coordinateSequence.getCoordinate(++n2, coordinate3);
            coordinate3.x -= d2;
            d += coordinate2.x * (coordinate.y - coordinate3.y);
        }
        return d / 2.0;
    }

    public static double signedArea(Coordinate[] coordinateArray) {
        int n = coordinateArray.length;
        double d = 0.0;
        if (n < 3) {
            return 0.0;
        }
        double d2 = coordinateArray[0].x;
        n = 1;
        while (n < coordinateArray.length - 1) {
            double d3 = coordinateArray[n].x;
            int n2 = n + 1;
            double d4 = coordinateArray[n2].y;
            d += (d3 - d2) * (coordinateArray[n - 1].y - d4);
            n = n2;
        }
        return d / 2.0;
    }
}

