/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;

public class CentroidPoint {
    private Coordinate centSum = new Coordinate();
    private int ptCount = 0;

    public void add(Coordinate coordinate) {
        ++this.ptCount;
        Coordinate coordinate2 = this.centSum;
        coordinate2.x += coordinate.x;
        coordinate2 = this.centSum;
        coordinate2.y += coordinate.y;
    }

    public void add(Geometry geometry) {
        if (geometry instanceof Point) {
            this.add(geometry.getCoordinate());
        } else if (geometry instanceof GeometryCollection) {
            geometry = (GeometryCollection)geometry;
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                this.add(((GeometryCollection)geometry).getGeometryN(i));
            }
        }
    }

    public Coordinate getCentroid() {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.centSum.x / (double)this.ptCount;
        coordinate.y = this.centSum.y / (double)this.ptCount;
        return coordinate;
    }
}

