/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.geom.Coordinate;

public class HCoordinate {
    public double w;
    public double x;
    public double y;

    public HCoordinate() {
        this.x = 0.0;
        this.y = 0.0;
        this.w = 1.0;
    }

    public HCoordinate(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.w = 1.0;
    }

    public HCoordinate(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.w = d3;
    }

    public HCoordinate(HCoordinate hCoordinate, HCoordinate hCoordinate2) {
        double d = hCoordinate.y;
        double d2 = hCoordinate2.w;
        double d3 = hCoordinate2.y;
        double d4 = hCoordinate.w;
        this.x = d * d2 - d3 * d4;
        d = hCoordinate2.x;
        d3 = hCoordinate.x;
        this.y = d4 * d - d2 * d3;
        this.w = d3 * hCoordinate2.y - d * hCoordinate.y;
    }

    public HCoordinate(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.w = 1.0;
    }

    public HCoordinate(Coordinate coordinate, Coordinate coordinate2) {
        this.x = coordinate.y - coordinate2.y;
        this.y = coordinate2.x - coordinate.x;
        this.w = coordinate.x * coordinate2.y - coordinate2.x * coordinate.y;
    }

    public HCoordinate(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d = coordinate.y - coordinate2.y;
        double d2 = coordinate2.x - coordinate.x;
        double d3 = coordinate.x * coordinate2.y - coordinate2.x * coordinate.y;
        double d4 = coordinate3.y - coordinate4.y;
        double d5 = coordinate4.x - coordinate3.x;
        double d6 = coordinate3.x * coordinate4.y - coordinate4.x * coordinate3.y;
        this.x = d2 * d6 - d5 * d3;
        this.y = d4 * d3 - d * d6;
        this.w = d * d5 - d4 * d2;
    }

    public static Coordinate intersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) throws NotRepresentableException {
        double d = coordinate.y - coordinate2.y;
        double d2 = coordinate2.x - coordinate.x;
        double d3 = coordinate.x * coordinate2.y - coordinate2.x * coordinate.y;
        double d4 = coordinate3.y - coordinate4.y;
        double d5 = coordinate4.x - coordinate3.x;
        double d6 = coordinate3.x * coordinate4.y - coordinate4.x * coordinate3.y;
        double d7 = d * d5 - d4 * d2;
        d5 = (d2 * d6 - d5 * d3) / d7;
        d7 = (d3 * d4 - d6 * d) / d7;
        if (!(Double.isNaN(d5) || Double.isInfinite(d5) || Double.isNaN(d7) || Double.isInfinite(d7))) {
            return new Coordinate(d5, d7);
        }
        throw new NotRepresentableException();
    }

    public Coordinate getCoordinate() throws NotRepresentableException {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.getX();
        coordinate.y = this.getY();
        return coordinate;
    }

    public double getX() throws NotRepresentableException {
        double d = this.x / this.w;
        if (!Double.isNaN(d) && !Double.isInfinite(d)) {
            return d;
        }
        throw new NotRepresentableException();
    }

    public double getY() throws NotRepresentableException {
        double d = this.y / this.w;
        if (!Double.isNaN(d) && !Double.isInfinite(d)) {
            return d;
        }
        throw new NotRepresentableException();
    }
}

