/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.util.Assert;

public abstract class LineIntersector {
    public static final int COLLINEAR = 2;
    public static final int COLLINEAR_INTERSECTION = 2;
    public static final int DONT_INTERSECT = 0;
    public static final int DO_INTERSECT = 1;
    public static final int NO_INTERSECTION = 0;
    public static final int POINT_INTERSECTION = 1;
    protected Coordinate[][] inputLines = new Coordinate[2][2];
    protected int[][] intLineIndex;
    protected Coordinate[] intPt;
    protected boolean isProper;
    protected Coordinate pa;
    protected Coordinate pb;
    protected PrecisionModel precisionModel;
    protected int result;

    public LineIntersector() {
        Coordinate[] coordinateArray = new Coordinate[2];
        this.intPt = coordinateArray;
        this.precisionModel = null;
        coordinateArray[0] = new Coordinate();
        this.intPt[1] = new Coordinate();
        coordinateArray = this.intPt;
        this.pa = coordinateArray[0];
        this.pb = coordinateArray[1];
        this.result = 0;
    }

    public static double computeEdgeDistance(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = Math.abs(coordinate3.x - coordinate2.x);
        double d2 = Math.abs(coordinate3.y - coordinate2.y);
        if (coordinate.equals(coordinate2)) {
            d = 0.0;
        } else if (coordinate.equals(coordinate3)) {
            if (!(d > d2)) {
                d = d2;
            }
        } else {
            double d3 = Math.abs(coordinate.x - coordinate2.x);
            double d4 = Math.abs(coordinate.y - coordinate2.y);
            d2 = d > d2 ? d3 : d4;
            d = d2;
            if (d2 == 0.0) {
                d = d2;
                if (!coordinate.equals(coordinate2)) {
                    d = Math.max(d3, d4);
                }
            }
        }
        boolean bl = d != 0.0 || coordinate.equals(coordinate2);
        Assert.isTrue(bl, "Bad distance calculation");
        return d;
    }

    private String getTopologySummary() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEndPoint()) {
            stringBuffer.append(" endpoint");
        }
        if (this.isProper) {
            stringBuffer.append(" proper");
        }
        if (this.isCollinear()) {
            stringBuffer.append(" collinear");
        }
        return stringBuffer.toString();
    }

    public static double nonRobustComputeEdgeDistance(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate.x - coordinate2.x;
        double d2 = coordinate.y - coordinate2.y;
        boolean bl = (d2 = Math.sqrt(d * d + d2 * d2)) != 0.0 || coordinate.equals(coordinate2);
        Assert.isTrue(bl, "Invalid distance calculation");
        return d2;
    }

    protected void computeIntLineIndex() {
        if (this.intLineIndex == null) {
            this.intLineIndex = new int[2][2];
            this.computeIntLineIndex(0);
            this.computeIntLineIndex(1);
        }
    }

    protected void computeIntLineIndex(int n) {
        if (this.getEdgeDistance(n, 0) > this.getEdgeDistance(n, 1)) {
            int[][] nArray = this.intLineIndex;
            nArray[n][0] = 0;
            nArray[n][1] = 1;
        } else {
            int[][] nArray = this.intLineIndex;
            nArray[n][0] = 1;
            nArray[n][1] = 0;
        }
    }

    protected abstract int computeIntersect(Coordinate var1, Coordinate var2, Coordinate var3, Coordinate var4);

    public abstract void computeIntersection(Coordinate var1, Coordinate var2, Coordinate var3);

    public void computeIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        Coordinate[][] coordinateArray = this.inputLines;
        coordinateArray[0][0] = coordinate;
        coordinateArray[0][1] = coordinate2;
        coordinateArray[1][0] = coordinate3;
        coordinateArray[1][1] = coordinate4;
        this.result = this.computeIntersect(coordinate, coordinate2, coordinate3, coordinate4);
    }

    public double getEdgeDistance(int n, int n2) {
        Coordinate coordinate = this.intPt[n2];
        Coordinate[][] coordinateArray = this.inputLines;
        return LineIntersector.computeEdgeDistance(coordinate, coordinateArray[n][0], coordinateArray[n][1]);
    }

    public Coordinate getEndpoint(int n, int n2) {
        return this.inputLines[n][n2];
    }

    public int getIndexAlongSegment(int n, int n2) {
        this.computeIntLineIndex();
        return this.intLineIndex[n][n2];
    }

    public Coordinate getIntersection(int n) {
        return this.intPt[n];
    }

    public Coordinate getIntersectionAlongSegment(int n, int n2) {
        this.computeIntLineIndex();
        return this.intPt[this.intLineIndex[n][n2]];
    }

    public int getIntersectionNum() {
        return this.result;
    }

    public boolean hasIntersection() {
        return this.result != 0;
    }

    protected boolean isCollinear() {
        return this.result == 2;
    }

    protected boolean isEndPoint() {
        return this.hasIntersection() && !this.isProper;
    }

    public boolean isInteriorIntersection() {
        if (this.isInteriorIntersection(0)) {
            return true;
        }
        return this.isInteriorIntersection(1);
    }

    public boolean isInteriorIntersection(int n) {
        int n2 = 0;
        while (n2 < this.result) {
            if (!this.intPt[n2].equals2D(this.inputLines[n][0]) && !this.intPt[n2].equals2D(this.inputLines[n][1])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isIntersection(Coordinate coordinate) {
        int n = 0;
        while (n < this.result) {
            if (this.intPt[n].equals2D(coordinate)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isProper() {
        return this.hasIntersection() && this.isProper;
    }

    public void setMakePrecise(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public String toString() {
        Coordinate[][] coordinateArray = this.inputLines;
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(WKTWriter.toLineString(coordinateArray[0][0], coordinateArray[0][1])));
        stringBuilder.append(" - ");
        coordinateArray = this.inputLines;
        stringBuilder.append(WKTWriter.toLineString(coordinateArray[1][0], coordinateArray[1][1]));
        stringBuilder.append(this.getTopologySummary());
        return stringBuilder.toString();
    }
}

