/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.util.Assert;

public class MinimumBoundingCircle {
    private Coordinate centre = null;
    private Coordinate[] extremalPts = null;
    private Geometry input;
    private double radius = 0.0;

    public MinimumBoundingCircle(Geometry geometry) {
        this.input = geometry;
    }

    private void compute() {
        if (this.extremalPts != null) {
            return;
        }
        this.computeCirclePoints();
        this.computeCentre();
        Coordinate coordinate = this.centre;
        if (coordinate != null) {
            this.radius = coordinate.distance(this.extremalPts[0]);
        }
    }

    private void computeCentre() {
        Coordinate[] coordinateArray = this.extremalPts;
        int n = coordinateArray.length;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        this.centre = Triangle.circumcentre(coordinateArray[0], coordinateArray[1], coordinateArray[2]);
                    }
                } else {
                    this.centre = new Coordinate((coordinateArray[0].x + this.extremalPts[1].x) / 2.0, (this.extremalPts[0].y + this.extremalPts[1].y) / 2.0);
                }
            } else {
                this.centre = coordinateArray[0];
            }
        } else {
            this.centre = null;
        }
    }

    private void computeCirclePoints() {
        Coordinate coordinate;
        Object object;
        if (this.input.isEmpty()) {
            this.extremalPts = new Coordinate[0];
            return;
        }
        if (this.input.getNumPoints() == 1) {
            this.extremalPts = new Coordinate[]{new Coordinate(this.input.getCoordinates()[0])};
            return;
        }
        Coordinate[] coordinateArray = object = this.input.convexHull().getCoordinates();
        if (object[0].equals2D(object[((Coordinate[])object).length - 1])) {
            coordinateArray = new Coordinate[((Coordinate[])object).length - 1];
            CoordinateArrays.copyDeep(object, 0, coordinateArray, 0, ((Coordinate[])object).length - 1);
        }
        if (coordinateArray.length <= 2) {
            this.extremalPts = CoordinateArrays.copyDeep(coordinateArray);
            return;
        }
        Coordinate coordinate2 = MinimumBoundingCircle.lowestPoint(coordinateArray);
        object = MinimumBoundingCircle.pointWitMinAngleWithX(coordinateArray, coordinate2);
        int n = 0;
        while (true) {
            if (n >= coordinateArray.length) {
                Assert.shouldNeverReachHere("Logic failure in Minimum Bounding Circle algorithm!");
                return;
            }
            coordinate = MinimumBoundingCircle.pointWithMinAngleWithSegment(coordinateArray, coordinate2, (Coordinate)object);
            if (Angle.isObtuse(coordinate2, coordinate, (Coordinate)object)) {
                this.extremalPts = new Coordinate[]{new Coordinate(coordinate2), new Coordinate((Coordinate)object)};
                return;
            }
            if (Angle.isObtuse(coordinate, coordinate2, (Coordinate)object)) {
                coordinate2 = coordinate;
            } else {
                if (!Angle.isObtuse(coordinate, (Coordinate)object, coordinate2)) break;
                object = coordinate;
            }
            ++n;
        }
        this.extremalPts = new Coordinate[]{new Coordinate(coordinate2), new Coordinate((Coordinate)object), new Coordinate(coordinate)};
    }

    private static Coordinate lowestPoint(Coordinate[] coordinateArray) {
        Coordinate coordinate = coordinateArray[0];
        int n = 1;
        while (n < coordinateArray.length) {
            Coordinate coordinate2 = coordinate;
            if (coordinateArray[n].y < coordinate.y) {
                coordinate2 = coordinateArray[n];
            }
            ++n;
            coordinate = coordinate2;
        }
        return coordinate;
    }

    private static Coordinate pointWitMinAngleWithX(Coordinate[] coordinateArray, Coordinate coordinate) {
        double d = Double.MAX_VALUE;
        Coordinate coordinate2 = null;
        int n = 0;
        while (n < coordinateArray.length) {
            double d2;
            Coordinate coordinate3 = coordinateArray[n];
            if (coordinate3 == coordinate) {
                d2 = d;
            } else {
                double d3;
                double d4 = coordinate3.x - coordinate.x;
                d2 = d3 = coordinate3.y - coordinate.y;
                if (d3 < 0.0) {
                    d2 = -d3;
                }
                d3 = d2 / Math.sqrt(d4 * d4 + d2 * d2);
                d2 = d;
                if (d3 < d) {
                    coordinate2 = coordinate3;
                    d2 = d3;
                }
            }
            ++n;
            d = d2;
        }
        return coordinate2;
    }

    private static Coordinate pointWithMinAngleWithSegment(Coordinate[] coordinateArray, Coordinate coordinate, Coordinate coordinate2) {
        double d = Double.MAX_VALUE;
        Coordinate coordinate3 = null;
        int n = 0;
        while (n < coordinateArray.length) {
            double d2;
            Coordinate coordinate4 = coordinateArray[n];
            if (coordinate4 == coordinate) {
                d2 = d;
            } else if (coordinate4 == coordinate2) {
                d2 = d;
            } else {
                double d3 = Angle.angleBetween(coordinate, coordinate4, coordinate2);
                d2 = d;
                if (d3 < d) {
                    coordinate3 = coordinate4;
                    d2 = d3;
                }
            }
            ++n;
            d = d2;
        }
        return coordinate3;
    }

    public Coordinate getCentre() {
        this.compute();
        return this.centre;
    }

    public Geometry getCircle() {
        this.compute();
        if (this.centre == null) {
            return this.input.getFactory().createPolygon(null, null);
        }
        Point point = this.input.getFactory().createPoint(this.centre);
        double d = this.radius;
        if (d == 0.0) {
            return point;
        }
        return point.buffer(d);
    }

    public Geometry getDiameter() {
        this.compute();
        Object object = this.extremalPts;
        int n = ((Coordinate[])object).length;
        if (n != 0) {
            if (n != 1) {
                Coordinate coordinate = object[0];
                object = object[1];
                return this.input.getFactory().createLineString(new Coordinate[]{coordinate, object});
            }
            return this.input.getFactory().createPoint(this.centre);
        }
        return this.input.getFactory().createLineString((CoordinateSequence)null);
    }

    public Coordinate[] getExtremalPoints() {
        this.compute();
        return this.extremalPts;
    }

    public Geometry getFarthestPoints() {
        this.compute();
        Object object = this.extremalPts;
        int n = ((Coordinate[])object).length;
        if (n != 0) {
            if (n != 1) {
                Coordinate coordinate = object[0];
                object = object[((Coordinate[])object).length - 1];
                return this.input.getFactory().createLineString(new Coordinate[]{coordinate, object});
            }
            return this.input.getFactory().createPoint(this.centre);
        }
        return this.input.getFactory().createLineString((CoordinateSequence)null);
    }

    public double getRadius() {
        this.compute();
        return this.radius;
    }
}

