/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;

public class RayCrossingCounter {
    private int crossingCount = 0;
    private boolean isPointOnSegment = false;
    private Coordinate p;

    public RayCrossingCounter(Coordinate coordinate) {
        this.p = coordinate;
    }

    public static int locatePointInRing(Coordinate coordinate, CoordinateSequence coordinateSequence) {
        RayCrossingCounter rayCrossingCounter = new RayCrossingCounter(coordinate);
        coordinate = new Coordinate();
        Coordinate coordinate2 = new Coordinate();
        int n = 1;
        while (n < coordinateSequence.size()) {
            coordinateSequence.getCoordinate(n, coordinate);
            coordinateSequence.getCoordinate(n - 1, coordinate2);
            rayCrossingCounter.countSegment(coordinate, coordinate2);
            if (rayCrossingCounter.isOnSegment()) {
                return rayCrossingCounter.getLocation();
            }
            ++n;
        }
        return rayCrossingCounter.getLocation();
    }

    public static int locatePointInRing(Coordinate object, Coordinate[] coordinateArray) {
        object = new RayCrossingCounter((Coordinate)object);
        int n = 1;
        while (n < coordinateArray.length) {
            ((RayCrossingCounter)object).countSegment(coordinateArray[n], coordinateArray[n - 1]);
            if (((RayCrossingCounter)object).isOnSegment()) {
                return ((RayCrossingCounter)object).getLocation();
            }
            ++n;
        }
        return ((RayCrossingCounter)object).getLocation();
    }

    public void countSegment(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate.x < this.p.x && coordinate2.x < this.p.x) {
            return;
        }
        if (this.p.x == coordinate2.x && this.p.y == coordinate2.y) {
            this.isPointOnSegment = true;
            return;
        }
        if (coordinate.y == this.p.y && coordinate2.y == this.p.y) {
            double d = coordinate.x;
            double d2 = coordinate2.x;
            double d3 = d;
            double d4 = d2;
            if (d > d2) {
                d3 = coordinate2.x;
                d4 = coordinate.x;
            }
            if (this.p.x >= d3 && this.p.x <= d4) {
                this.isPointOnSegment = true;
            }
            return;
        }
        if (coordinate.y > this.p.y && coordinate2.y <= this.p.y || coordinate2.y > this.p.y && coordinate.y <= this.p.y) {
            double d = coordinate.x;
            double d5 = this.p.x;
            double d6 = coordinate.y - this.p.y;
            double d7 = coordinate2.x;
            double d8 = this.p.x;
            double d9 = coordinate2.y - this.p.y;
            if ((d7 = (double)RobustDeterminant.signOfDet2x2(d - d5, d6, d7 - d8, d9)) == 0.0) {
                this.isPointOnSegment = true;
                return;
            }
            d5 = d7;
            if (d9 < d6) {
                d5 = -d7;
            }
            if (d5 > 0.0) {
                ++this.crossingCount;
            }
        }
    }

    public int getLocation() {
        if (this.isPointOnSegment) {
            return 1;
        }
        if (this.crossingCount % 2 == 1) {
            return 0;
        }
        return 2;
    }

    public boolean isOnSegment() {
        return this.isPointOnSegment;
    }

    public boolean isPointInPolygon() {
        return this.getLocation() != 2;
    }
}

