/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;

public class RectangleLineIntersector {
    private Coordinate diagDown0;
    private Coordinate diagDown1;
    private Coordinate diagUp0;
    private Coordinate diagUp1;
    private LineIntersector li = new RobustLineIntersector();
    private Envelope rectEnv;

    public RectangleLineIntersector(Envelope envelope) {
        this.rectEnv = envelope;
        this.diagUp0 = new Coordinate(envelope.getMinX(), envelope.getMinY());
        this.diagUp1 = new Coordinate(envelope.getMaxX(), envelope.getMaxY());
        this.diagDown0 = new Coordinate(envelope.getMinX(), envelope.getMaxY());
        this.diagDown1 = new Coordinate(envelope.getMaxX(), envelope.getMinY());
    }

    public boolean intersects(Coordinate coordinate, Coordinate coordinate2) {
        Comparable comparable = new Envelope(coordinate, coordinate2);
        if (!this.rectEnv.intersects((Envelope)comparable)) {
            return false;
        }
        if (this.rectEnv.intersects(coordinate)) {
            return true;
        }
        if (this.rectEnv.intersects(coordinate2)) {
            return true;
        }
        if (coordinate.compareTo(coordinate2) > 0) {
            comparable = coordinate2;
        } else {
            comparable = coordinate;
            coordinate = coordinate2;
        }
        boolean bl = coordinate.y > ((Coordinate)comparable).y;
        if (bl) {
            this.li.computeIntersection((Coordinate)comparable, coordinate, this.diagDown0, this.diagDown1);
        } else {
            this.li.computeIntersection((Coordinate)comparable, coordinate, this.diagUp0, this.diagUp1);
        }
        return this.li.hasIntersection();
    }
}

