/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.CGAlgorithmsDD;
import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.io.PrintStream;

public class RobustLineIntersector
extends LineIntersector {
    private void checkDD(Coordinate coordinate, Coordinate comparable, Coordinate object, Coordinate coordinate2, Coordinate coordinate3) {
        coordinate = CGAlgorithmsDD.intersection(coordinate, (Coordinate)comparable, (Coordinate)object, coordinate2);
        boolean bl = this.isInSegmentEnvelopes(coordinate);
        object = System.out;
        comparable = new StringBuilder("DD in env = ");
        ((StringBuilder)comparable).append(bl);
        ((StringBuilder)comparable).append("  --------------------- ");
        ((StringBuilder)comparable).append(coordinate);
        ((PrintStream)object).println(((StringBuilder)comparable).toString());
        if (coordinate3.distance(coordinate) > 1.0E-4) {
            object = System.out;
            comparable = new StringBuilder("Distance = ");
            ((StringBuilder)comparable).append(coordinate3.distance(coordinate));
            ((PrintStream)object).println(((StringBuilder)comparable).toString());
        }
    }

    private int computeCollinearIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        boolean bl = Envelope.intersects(coordinate, coordinate2, coordinate3);
        boolean bl2 = Envelope.intersects(coordinate, coordinate2, coordinate4);
        boolean bl3 = Envelope.intersects(coordinate3, coordinate4, coordinate);
        boolean bl4 = Envelope.intersects(coordinate3, coordinate4, coordinate2);
        int n = 2;
        if (bl && bl2) {
            this.intPt[0] = coordinate3;
            this.intPt[1] = coordinate4;
            return 2;
        }
        if (bl3 && bl4) {
            this.intPt[0] = coordinate;
            this.intPt[1] = coordinate2;
            return 2;
        }
        if (bl && bl3) {
            this.intPt[0] = coordinate3;
            this.intPt[1] = coordinate;
            int n2 = n;
            if (coordinate3.equals(coordinate)) {
                n2 = n;
                if (!bl2) {
                    n2 = n;
                    if (!bl4) {
                        n2 = 1;
                    }
                }
            }
            return n2;
        }
        if (bl && bl4) {
            this.intPt[0] = coordinate3;
            this.intPt[1] = coordinate2;
            int n3 = n;
            if (coordinate3.equals(coordinate2)) {
                n3 = n;
                if (!bl2) {
                    n3 = n;
                    if (!bl3) {
                        n3 = 1;
                    }
                }
            }
            return n3;
        }
        if (bl2 && bl3) {
            this.intPt[0] = coordinate4;
            this.intPt[1] = coordinate;
            int n4 = n;
            if (coordinate4.equals(coordinate)) {
                n4 = n;
                if (!bl) {
                    n4 = n;
                    if (!bl4) {
                        n4 = 1;
                    }
                }
            }
            return n4;
        }
        if (bl2 && bl4) {
            this.intPt[0] = coordinate4;
            this.intPt[1] = coordinate2;
            int n5 = n;
            if (coordinate4.equals(coordinate2)) {
                n5 = n;
                if (!bl) {
                    n5 = n;
                    if (!bl3) {
                        n5 = 1;
                    }
                }
            }
            return n5;
        }
        return 0;
    }

    private Coordinate intersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        Coordinate coordinate5;
        Coordinate coordinate6 = coordinate5 = this.intersectionWithNormalization(coordinate, coordinate2, coordinate3, coordinate4);
        if (!this.isInSegmentEnvelopes(coordinate5)) {
            coordinate6 = new Coordinate(RobustLineIntersector.nearestEndpoint(coordinate, coordinate2, coordinate3, coordinate4));
        }
        if (this.precisionModel != null) {
            this.precisionModel.makePrecise(coordinate6);
        }
        return coordinate6;
    }

    private Coordinate intersectionWithNormalization(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        coordinate = new Coordinate(coordinate);
        coordinate2 = new Coordinate(coordinate2);
        coordinate3 = new Coordinate(coordinate3);
        Coordinate coordinate5 = new Coordinate(coordinate4);
        coordinate4 = new Coordinate();
        this.normalizeToEnvCentre(coordinate, coordinate2, coordinate3, coordinate5, coordinate4);
        coordinate = this.safeHCoordinateIntersection(coordinate, coordinate2, coordinate3, coordinate5);
        coordinate.x += coordinate4.x;
        coordinate.y += coordinate4.y;
        return coordinate;
    }

    private boolean isInSegmentEnvelopes(Coordinate coordinate) {
        Envelope envelope = new Envelope(this.inputLines[0][0], this.inputLines[0][1]);
        Envelope envelope2 = new Envelope(this.inputLines[1][0], this.inputLines[1][1]);
        return envelope.contains(coordinate) && envelope2.contains(coordinate);
    }

    private static Coordinate nearestEndpoint(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        Coordinate coordinate5;
        double d = CGAlgorithms.distancePointLine(coordinate, coordinate3, coordinate4);
        double d2 = CGAlgorithms.distancePointLine(coordinate2, coordinate3, coordinate4);
        if (d2 < d) {
            coordinate5 = coordinate2;
        } else {
            coordinate5 = coordinate;
            d2 = d;
        }
        d = CGAlgorithms.distancePointLine(coordinate3, coordinate, coordinate2);
        if (d < d2) {
            d2 = d;
        } else {
            coordinate3 = coordinate5;
        }
        if (!(CGAlgorithms.distancePointLine(coordinate4, coordinate, coordinate2) < d2)) {
            coordinate4 = coordinate3;
        }
        return coordinate4;
    }

    private void normalizeToEnvCentre(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4, Coordinate coordinate5) {
        double d = coordinate.x < coordinate2.x ? coordinate.x : coordinate2.x;
        double d2 = coordinate.y < coordinate2.y ? coordinate.y : coordinate2.y;
        double d3 = coordinate.x > coordinate2.x ? coordinate.x : coordinate2.x;
        double d4 = coordinate.y > coordinate2.y ? coordinate.y : coordinate2.y;
        double d5 = coordinate3.x < coordinate4.x ? coordinate3.x : coordinate4.x;
        double d6 = coordinate3.y < coordinate4.y ? coordinate3.y : coordinate4.y;
        double d7 = coordinate3.x > coordinate4.x ? coordinate3.x : coordinate4.x;
        double d8 = coordinate3.y > coordinate4.y ? coordinate3.y : coordinate4.y;
        if (!(d > d5)) {
            d = d5;
        }
        if (!(d3 < d7)) {
            d3 = d7;
        }
        if (!(d2 > d6)) {
            d2 = d6;
        }
        d6 = d8;
        if (d4 < d8) {
            d6 = d4;
        }
        d4 = (d + d3) / 2.0;
        d2 = (d2 + d6) / 2.0;
        coordinate5.x = d4;
        coordinate5.y = d2;
        coordinate.x -= coordinate5.x;
        coordinate.y -= coordinate5.y;
        coordinate2.x -= coordinate5.x;
        coordinate2.y -= coordinate5.y;
        coordinate3.x -= coordinate5.x;
        coordinate3.y -= coordinate5.y;
        coordinate4.x -= coordinate5.x;
        coordinate4.y -= coordinate5.y;
    }

    private void normalizeToMinimum(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4, Coordinate coordinate5) {
        coordinate5.x = this.smallestInAbsValue(coordinate.x, coordinate2.x, coordinate3.x, coordinate4.x);
        coordinate5.y = this.smallestInAbsValue(coordinate.y, coordinate2.y, coordinate3.y, coordinate4.y);
        coordinate.x -= coordinate5.x;
        coordinate.y -= coordinate5.y;
        coordinate2.x -= coordinate5.x;
        coordinate2.y -= coordinate5.y;
        coordinate3.x -= coordinate5.x;
        coordinate3.y -= coordinate5.y;
        coordinate4.x -= coordinate5.x;
        coordinate4.y -= coordinate5.y;
    }

    private Coordinate safeHCoordinateIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        try {
            Coordinate coordinate5;
            coordinate = coordinate5 = HCoordinate.intersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        catch (NotRepresentableException notRepresentableException) {
            coordinate = RobustLineIntersector.nearestEndpoint(coordinate, coordinate2, coordinate3, coordinate4);
        }
        return coordinate;
    }

    private double smallestInAbsValue(double d, double d2, double d3, double d4) {
        block3: {
            double d5;
            double d6 = d5 = Math.abs(d);
            if (Math.abs(d2) < d5) {
                d6 = Math.abs(d2);
                d = d2;
            }
            if (Math.abs(d3) < d6) {
                d6 = Math.abs(d3);
            } else {
                d3 = d;
            }
            if (!(Math.abs(d4) < d6)) break block3;
            d3 = d4;
        }
        return d3;
    }

    @Override
    protected int computeIntersect(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        this.isProper = false;
        if (!Envelope.intersects(coordinate, coordinate2, coordinate3, coordinate4)) {
            return 0;
        }
        int n = CGAlgorithms.orientationIndex(coordinate, coordinate2, coordinate3);
        int n2 = CGAlgorithms.orientationIndex(coordinate, coordinate2, coordinate4);
        if (n > 0 && n2 > 0 || n < 0 && n2 < 0) {
            return 0;
        }
        int n3 = CGAlgorithms.orientationIndex(coordinate3, coordinate4, coordinate);
        int n4 = CGAlgorithms.orientationIndex(coordinate3, coordinate4, coordinate2);
        if (n3 > 0 && n4 > 0 || n3 < 0 && n4 < 0) {
            return 0;
        }
        boolean bl = n == 0 && n2 == 0 && n3 == 0 && n4 == 0;
        if (bl) {
            return this.computeCollinearIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        if (n != 0 && n2 != 0 && n3 != 0 && n4 != 0) {
            this.isProper = true;
            this.intPt[0] = this.intersection(coordinate, coordinate2, coordinate3, coordinate4);
        } else {
            this.isProper = false;
            if (!coordinate.equals2D(coordinate3) && !coordinate.equals2D(coordinate4)) {
                if (!coordinate2.equals2D(coordinate3) && !coordinate2.equals2D(coordinate4)) {
                    if (n == 0) {
                        this.intPt[0] = new Coordinate(coordinate3);
                    } else if (n2 == 0) {
                        this.intPt[0] = new Coordinate(coordinate4);
                    } else if (n3 == 0) {
                        this.intPt[0] = new Coordinate(coordinate);
                    } else if (n4 == 0) {
                        this.intPt[0] = new Coordinate(coordinate2);
                    }
                } else {
                    this.intPt[0] = coordinate2;
                }
            } else {
                this.intPt[0] = coordinate;
            }
        }
        return 1;
    }

    @Override
    public void computeIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        this.isProper = false;
        if (Envelope.intersects(coordinate2, coordinate3, coordinate) && CGAlgorithms.orientationIndex(coordinate2, coordinate3, coordinate) == 0 && CGAlgorithms.orientationIndex(coordinate3, coordinate2, coordinate) == 0) {
            this.isProper = true;
            if (coordinate.equals(coordinate2) || coordinate.equals(coordinate3)) {
                this.isProper = false;
            }
            this.result = 1;
            return;
        }
        this.result = 0;
    }
}

