/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.distance;

import com.vividsolutions.jts.algorithm.distance.DistanceToPoint;
import com.vividsolutions.jts.algorithm.distance.PointPairDistance;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;

public class DiscreteHausdorffDistance {
    private double densifyFrac = 0.0;
    private Geometry g0;
    private Geometry g1;
    private PointPairDistance ptDist = new PointPairDistance();

    public DiscreteHausdorffDistance(Geometry geometry, Geometry geometry2) {
        this.g0 = geometry;
        this.g1 = geometry2;
    }

    private void compute(Geometry geometry, Geometry geometry2) {
        this.computeOrientedDistance(geometry, geometry2, this.ptDist);
        this.computeOrientedDistance(geometry2, geometry, this.ptDist);
    }

    private void computeOrientedDistance(Geometry geometry, Geometry object, PointPairDistance pointPairDistance) {
        MaxPointDistanceFilter maxPointDistanceFilter = new MaxPointDistanceFilter((Geometry)object);
        geometry.apply(maxPointDistanceFilter);
        pointPairDistance.setMaximum(maxPointDistanceFilter.getMaxPointDistance());
        double d = this.densifyFrac;
        if (d > 0.0) {
            object = new MaxDensifiedByFractionDistanceFilter((Geometry)object, d);
            geometry.apply((CoordinateSequenceFilter)object);
            pointPairDistance.setMaximum(((MaxDensifiedByFractionDistanceFilter)object).getMaxPointDistance());
        }
    }

    public static double distance(Geometry geometry, Geometry geometry2) {
        return new DiscreteHausdorffDistance(geometry, geometry2).distance();
    }

    public static double distance(Geometry object, Geometry geometry, double d) {
        object = new DiscreteHausdorffDistance((Geometry)object, geometry);
        ((DiscreteHausdorffDistance)object).setDensifyFraction(d);
        return ((DiscreteHausdorffDistance)object).distance();
    }

    public double distance() {
        this.compute(this.g0, this.g1);
        return this.ptDist.getDistance();
    }

    public Coordinate[] getCoordinates() {
        return this.ptDist.getCoordinates();
    }

    public double orientedDistance() {
        this.computeOrientedDistance(this.g0, this.g1, this.ptDist);
        return this.ptDist.getDistance();
    }

    public void setDensifyFraction(double d) {
        if (!(d > 1.0) && !(d <= 0.0)) {
            this.densifyFrac = d;
            return;
        }
        throw new IllegalArgumentException("Fraction is not in range (0.0 - 1.0]");
    }

    public static class MaxDensifiedByFractionDistanceFilter
    implements CoordinateSequenceFilter {
        private Geometry geom;
        private PointPairDistance maxPtDist = new PointPairDistance();
        private PointPairDistance minPtDist = new PointPairDistance();
        private int numSubSegs = 0;

        public MaxDensifiedByFractionDistanceFilter(Geometry geometry, double d) {
            this.geom = geometry;
            this.numSubSegs = (int)Math.rint(1.0 / d);
        }

        @Override
        public void filter(CoordinateSequence cloneable, int n) {
            if (n == 0) {
                return;
            }
            Coordinate coordinate = cloneable.getCoordinate(n - 1);
            cloneable = cloneable.getCoordinate(n);
            double d = (((Coordinate)cloneable).x - coordinate.x) / (double)this.numSubSegs;
            double d2 = (((Coordinate)cloneable).y - coordinate.y) / (double)this.numSubSegs;
            n = 0;
            while (n < this.numSubSegs) {
                double d3 = coordinate.x;
                double d4 = n;
                cloneable = new Coordinate(d3 + d4 * d, coordinate.y + d4 * d2);
                this.minPtDist.initialize();
                DistanceToPoint.computeDistance(this.geom, (Coordinate)cloneable, this.minPtDist);
                this.maxPtDist.setMaximum(this.minPtDist);
                ++n;
            }
            return;
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }
    }

    public static class MaxPointDistanceFilter
    implements CoordinateFilter {
        private DistanceToPoint euclideanDist;
        private Geometry geom;
        private PointPairDistance maxPtDist = new PointPairDistance();
        private PointPairDistance minPtDist = new PointPairDistance();

        public MaxPointDistanceFilter(Geometry geometry) {
            this.euclideanDist = new DistanceToPoint();
            this.geom = geometry;
        }

        @Override
        public void filter(Coordinate coordinate) {
            this.minPtDist.initialize();
            DistanceToPoint.computeDistance(this.geom, coordinate, this.minPtDist);
            this.maxPtDist.setMaximum(this.minPtDist);
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist;
        }
    }
}

