/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.distance;

import com.vividsolutions.jts.algorithm.distance.PointPairDistance;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class DistanceToPoint {
    public static void computeDistance(Geometry geometry, Coordinate coordinate, PointPairDistance pointPairDistance) {
        if (geometry instanceof LineString) {
            DistanceToPoint.computeDistance((LineString)geometry, coordinate, pointPairDistance);
        } else if (geometry instanceof Polygon) {
            DistanceToPoint.computeDistance((Polygon)geometry, coordinate, pointPairDistance);
        } else if (geometry instanceof GeometryCollection) {
            geometry = (GeometryCollection)geometry;
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                DistanceToPoint.computeDistance(((GeometryCollection)geometry).getGeometryN(i), coordinate, pointPairDistance);
            }
        } else {
            pointPairDistance.setMinimum(geometry.getCoordinate(), coordinate);
        }
    }

    public static void computeDistance(LineSegment lineSegment, Coordinate coordinate, PointPairDistance pointPairDistance) {
        pointPairDistance.setMinimum(lineSegment.closestPoint(coordinate), coordinate);
    }

    public static void computeDistance(LineString cloneable, Coordinate coordinate, PointPairDistance pointPairDistance) {
        LineSegment lineSegment = new LineSegment();
        Coordinate[] coordinateArray = cloneable.getCoordinates();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            cloneable = coordinateArray[n];
            lineSegment.setCoordinates((Coordinate)cloneable, coordinateArray[++n]);
            pointPairDistance.setMinimum(lineSegment.closestPoint(coordinate), coordinate);
        }
        return;
    }

    public static void computeDistance(Polygon polygon, Coordinate coordinate, PointPairDistance pointPairDistance) {
        DistanceToPoint.computeDistance(polygon.getExteriorRing(), coordinate, pointPairDistance);
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            DistanceToPoint.computeDistance(polygon.getInteriorRingN(n), coordinate, pointPairDistance);
            ++n;
        }
        return;
    }
}

