/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.awt;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

public class PolygonShape
implements Shape {
    private GeneralPath polygonPath;
    private GeneralPath ringPath;

    public PolygonShape() {
    }

    public PolygonShape(Coordinate[] coordinateArray, Collection object) {
        this.polygonPath = this.toPath(coordinateArray);
        object = object.iterator();
        while (object.hasNext()) {
            coordinateArray = (Coordinate[])object.next();
            this.polygonPath.append(this.toPath(coordinateArray), false);
        }
        return;
    }

    private GeneralPath toPath(Coordinate[] coordinateArray) {
        int n = coordinateArray.length;
        GeneralPath generalPath = new GeneralPath(0, n);
        if (coordinateArray.length > 0) {
            generalPath.moveTo((float)coordinateArray[0].x, (float)coordinateArray[0].y);
            for (int i = 0; i < coordinateArray.length; ++i) {
                generalPath.lineTo((float)coordinateArray[i].x, (float)coordinateArray[i].y);
            }
        }
        return generalPath;
    }

    void addToRing(Point2D point2D) {
        GeneralPath generalPath = this.ringPath;
        if (generalPath == null) {
            this.ringPath = generalPath = new GeneralPath(0);
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        } else {
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.polygonPath.contains(d, d2);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return this.polygonPath.contains(d, d2, d3, d4);
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.polygonPath.contains(point2D);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.polygonPath.contains(rectangle2D);
    }

    void endRing() {
        this.ringPath.closePath();
        GeneralPath generalPath = this.polygonPath;
        if (generalPath == null) {
            this.polygonPath = this.ringPath;
        } else {
            generalPath.append(this.ringPath, false);
        }
        this.ringPath = null;
    }

    @Override
    public Rectangle getBounds() {
        return this.polygonPath.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.polygonPath.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.polygonPath.getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform, d);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.polygonPath.intersects(d, d2, d3, d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.polygonPath.intersects(rectangle2D);
    }
}

