/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.dissolve;

import com.vividsolutions.jts.dissolve.DissolveEdgeGraph;
import com.vividsolutions.jts.dissolve.DissolveHalfEdge;
import com.vividsolutions.jts.edgegraph.HalfEdge;
import com.vividsolutions.jts.edgegraph.MarkHalfEdge;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class LineDissolver {
    private GeometryFactory factory;
    private DissolveEdgeGraph graph;
    private List lines = new ArrayList();
    private Stack nodeEdgeStack = new Stack();
    private Geometry result;
    private DissolveHalfEdge ringStartEdge;

    public LineDissolver() {
        this.graph = new DissolveEdgeGraph();
    }

    private void add(LineString cloneable) {
        if (this.factory == null) {
            this.factory = ((Geometry)cloneable).getFactory();
        }
        cloneable = ((LineString)cloneable).getCoordinateSequence();
        boolean bl = false;
        int n = 1;
        while (n < cloneable.size()) {
            boolean bl2;
            DissolveHalfEdge dissolveHalfEdge = (DissolveHalfEdge)this.graph.addEdge(cloneable.getCoordinate(n - 1), cloneable.getCoordinate(n));
            if (dissolveHalfEdge == null) {
                bl2 = bl;
            } else {
                bl2 = bl;
                if (!bl) {
                    dissolveHalfEdge.setStart();
                    bl2 = true;
                }
            }
            ++n;
            bl = bl2;
        }
        return;
    }

    private void addLine(CoordinateList coordinateList) {
        this.lines.add(this.factory.createLineString(coordinateList.toCoordinateArray()));
    }

    private void buildLine(HalfEdge halfEdge) {
        CoordinateList coordinateList = new CoordinateList();
        DissolveHalfEdge dissolveHalfEdge = (DissolveHalfEdge)halfEdge;
        this.ringStartEdge = null;
        MarkHalfEdge.markBoth(dissolveHalfEdge);
        coordinateList.add(dissolveHalfEdge.orig().clone(), false);
        while (true) {
            if (dissolveHalfEdge.sym().degree() != 2) {
                coordinateList.add(dissolveHalfEdge.dest().clone(), false);
                this.stackEdges(dissolveHalfEdge.sym());
                this.addLine(coordinateList);
                return;
            }
            this.updateRingStartEdge(dissolveHalfEdge);
            dissolveHalfEdge = (DissolveHalfEdge)dissolveHalfEdge.next();
            if (dissolveHalfEdge == halfEdge) {
                this.buildRing(this.ringStartEdge);
                return;
            }
            coordinateList.add(dissolveHalfEdge.orig().clone(), false);
            MarkHalfEdge.markBoth(dissolveHalfEdge);
        }
    }

    private void buildLines() {
        while (!this.nodeEdgeStack.empty()) {
            HalfEdge halfEdge = (HalfEdge)this.nodeEdgeStack.pop();
            if (MarkHalfEdge.isMarked(halfEdge)) continue;
            this.buildLine(halfEdge);
        }
        return;
    }

    private void buildRing(HalfEdge halfEdge) {
        CoordinateList coordinateList = new CoordinateList();
        coordinateList.add(halfEdge.orig().clone(), false);
        HalfEdge halfEdge2 = halfEdge;
        while (true) {
            HalfEdge halfEdge3;
            if (halfEdge2.sym().degree() != 2 || (halfEdge3 = halfEdge2.next()) == halfEdge) {
                coordinateList.add(halfEdge2.dest().clone(), false);
                this.addLine(coordinateList);
                return;
            }
            coordinateList.add(halfEdge3.orig().clone(), false);
            halfEdge2 = halfEdge3;
        }
    }

    private void computeResult() {
        Iterator iterator2 = this.graph.getVertexEdges().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                this.result = this.factory.buildGeometry(this.lines);
                return;
            }
            HalfEdge halfEdge = (HalfEdge)iterator2.next();
            if (MarkHalfEdge.isMarked(halfEdge)) continue;
            this.process(halfEdge);
        }
    }

    public static Geometry dissolve(Geometry geometry) {
        LineDissolver lineDissolver = new LineDissolver();
        lineDissolver.add(geometry);
        return lineDissolver.getResult();
    }

    private void process(HalfEdge halfEdge) {
        HalfEdge halfEdge2 = halfEdge.prevNode();
        if (halfEdge2 != null) {
            halfEdge = halfEdge2;
        }
        this.stackEdges(halfEdge);
        this.buildLines();
    }

    private void stackEdges(HalfEdge halfEdge) {
        HalfEdge halfEdge2;
        HalfEdge halfEdge3 = halfEdge;
        do {
            if (!MarkHalfEdge.isMarked(halfEdge3)) {
                this.nodeEdgeStack.add(halfEdge3);
            }
            halfEdge3 = halfEdge2 = halfEdge3.oNext();
        } while (halfEdge2 != halfEdge);
    }

    private void updateRingStartEdge(DissolveHalfEdge dissolveHalfEdge) {
        DissolveHalfEdge dissolveHalfEdge2 = dissolveHalfEdge;
        if (!dissolveHalfEdge.isStart()) {
            dissolveHalfEdge2 = dissolveHalfEdge = (DissolveHalfEdge)dissolveHalfEdge.sym();
            if (!dissolveHalfEdge.isStart()) {
                return;
            }
        }
        if (this.ringStartEdge == null) {
            this.ringStartEdge = dissolveHalfEdge2;
            return;
        }
        if (dissolveHalfEdge2.orig().compareTo(this.ringStartEdge.orig()) < 0) {
            this.ringStartEdge = dissolveHalfEdge2;
        }
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry geometry) {
                if (geometry instanceof LineString) {
                    LineDissolver.this.add((LineString)geometry);
                }
            }
        });
    }

    public void add(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.add((Geometry)object.next());
        }
        return;
    }

    public Geometry getResult() {
        if (this.result == null) {
            this.computeResult();
        }
        return this.result;
    }
}

