/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.NumberUtil;
import java.io.Serializable;
import java.util.Comparator;

public class Coordinate
implements Comparable,
Cloneable,
Serializable {
    public static final double NULL_ORDINATE = Double.NaN;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private static final long serialVersionUID = 6683108902428366910L;
    public double x;
    public double y;
    public double z;

    public Coordinate() {
        this(0.0, 0.0);
    }

    public Coordinate(double d, double d2) {
        this(d, d2, Double.NaN);
    }

    public Coordinate(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Coordinate(Coordinate coordinate) {
        this(coordinate.x, coordinate.y, coordinate.z);
    }

    public static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public Object clone() {
        try {
            Coordinate coordinate = (Coordinate)super.clone();
            return coordinate;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.shouldNeverReachHere("this shouldn't happen because this class is Cloneable");
            return null;
        }
    }

    public int compareTo(Object object) {
        object = (Coordinate)object;
        double d = this.x;
        double d2 = ((Coordinate)object).x;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        d = this.y;
        d2 = ((Coordinate)object).y;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        return 0;
    }

    public double distance(Coordinate coordinate) {
        double d = this.x - coordinate.x;
        double d2 = this.y - coordinate.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public double distance3D(Coordinate coordinate) {
        double d = this.x - coordinate.x;
        double d2 = this.y - coordinate.y;
        double d3 = this.z - coordinate.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public boolean equalInZ(Coordinate coordinate, double d) {
        return NumberUtil.equalsWithTolerance(this.z, coordinate.z, d);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Coordinate)) {
            return false;
        }
        return this.equals2D((Coordinate)object);
    }

    public boolean equals2D(Coordinate coordinate) {
        if (this.x != coordinate.x) {
            return false;
        }
        return this.y == coordinate.y;
    }

    public boolean equals2D(Coordinate coordinate, double d) {
        if (!NumberUtil.equalsWithTolerance(this.x, coordinate.x, d)) {
            return false;
        }
        return NumberUtil.equalsWithTolerance(this.y, coordinate.y, d);
    }

    public boolean equals3D(Coordinate coordinate) {
        double d;
        return this.x == coordinate.x && this.y == coordinate.y && ((d = this.z) == coordinate.z || Double.isNaN(d) && Double.isNaN(coordinate.z));
    }

    public double getOrdinate(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    return this.z;
                }
                StringBuilder stringBuilder = new StringBuilder("Invalid ordinate index: ");
                stringBuilder.append(n);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            return this.y;
        }
        return this.x;
    }

    public int hashCode() {
        return (629 + Coordinate.hashCode(this.x)) * 37 + Coordinate.hashCode(this.y);
    }

    public void setCoordinate(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.z = coordinate.z;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setOrdinate(int n, double d) {
        if (n == 0) {
            this.x = d;
            return;
        }
        if (n == 1) {
            this.y = d;
            return;
        }
        if (n == 2) {
            this.z = d;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("Invalid ordinate index: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(this.x);
        stringBuilder.append(", ");
        stringBuilder.append(this.y);
        stringBuilder.append(", ");
        stringBuilder.append(this.z);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static class DimensionalComparator
    implements Comparator {
        private int dimensionsToTest = 2;

        public DimensionalComparator() {
            this(2);
        }

        public DimensionalComparator(int n) {
            if (n != 2 && n != 3) {
                throw new IllegalArgumentException("only 2 or 3 dimensions may be specified");
            }
            this.dimensionsToTest = n;
        }

        public static int compare(double d, double d2) {
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            if (Double.isNaN(d)) {
                if (Double.isNaN(d2)) {
                    return 0;
                }
                return -1;
            }
            if (Double.isNaN(d2)) {
                return 1;
            }
            return 0;
        }

        public int compare(Object object, Object object2) {
            object = (Coordinate)object;
            object2 = (Coordinate)object2;
            int n = DimensionalComparator.compare(((Coordinate)object).x, ((Coordinate)object2).x);
            if (n != 0) {
                return n;
            }
            n = DimensionalComparator.compare(((Coordinate)object).y, ((Coordinate)object2).y);
            if (n != 0) {
                return n;
            }
            if (this.dimensionsToTest <= 2) {
                return 0;
            }
            return DimensionalComparator.compare(((Coordinate)object).z, ((Coordinate)object2).z);
        }
    }
}

