/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.math.MathUtil;
import java.util.Collection;
import java.util.Comparator;

public class CoordinateArrays {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public static Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] coordinateArray) {
        if (coordinateArray.length < n) {
            coordinateArray = new Coordinate[]{};
        }
        return coordinateArray;
    }

    public static int compare(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        int n;
        for (n = 0; n < coordinateArray.length && n < coordinateArray2.length; ++n) {
            int n2 = coordinateArray[n].compareTo(coordinateArray2[n]);
            if (n2 == 0) continue;
            return n2;
        }
        if (n < coordinateArray2.length) {
            return -1;
        }
        if (n < coordinateArray.length) {
            return 1;
        }
        return 0;
    }

    public static void copyDeep(Coordinate[] coordinateArray, int n, Coordinate[] coordinateArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            coordinateArray2[n2 + n4] = new Coordinate(coordinateArray[n + n4]);
            ++n4;
        }
        return;
    }

    public static Coordinate[] copyDeep(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        int n = 0;
        while (n < coordinateArray.length) {
            coordinateArray2[n] = new Coordinate(coordinateArray[n]);
            ++n;
        }
        return coordinateArray2;
    }

    public static Envelope envelope(Coordinate[] coordinateArray) {
        Envelope envelope = new Envelope();
        int n = 0;
        while (n < coordinateArray.length) {
            envelope.expandToInclude(coordinateArray[n]);
            ++n;
        }
        return envelope;
    }

    public static boolean equals(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        if (coordinateArray == coordinateArray2) {
            return true;
        }
        if (coordinateArray != null && coordinateArray2 != null) {
            if (coordinateArray.length != coordinateArray2.length) {
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= coordinateArray.length) {
                    return true;
                }
                if (!coordinateArray[n].equals(coordinateArray2[n])) {
                    return false;
                }
                ++n;
            }
        }
        return false;
    }

    public static boolean equals(Coordinate[] coordinateArray, Coordinate[] coordinateArray2, Comparator comparator) {
        if (coordinateArray == coordinateArray2) {
            return true;
        }
        if (coordinateArray != null && coordinateArray2 != null) {
            if (coordinateArray.length != coordinateArray2.length) {
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= coordinateArray.length) {
                    return true;
                }
                if (comparator.compare(coordinateArray[n], coordinateArray2[n]) != 0) {
                    return false;
                }
                ++n;
            }
        }
        return false;
    }

    public static Coordinate[] extract(Coordinate[] coordinateArray, int n, int n2) {
        int n3 = coordinateArray.length;
        int n4 = 0;
        n3 = MathUtil.clamp(n, 0, n3);
        int n5 = MathUtil.clamp(n2, -1, coordinateArray.length);
        n = n5 - n3 + 1;
        if (n5 < 0) {
            n = 0;
        }
        if (n3 >= coordinateArray.length) {
            n = 0;
        }
        n2 = n;
        if (n5 < n3) {
            n2 = 0;
        }
        Coordinate[] coordinateArray2 = new Coordinate[n2];
        n = n4;
        n4 = n3;
        if (n2 == 0) {
            return coordinateArray2;
        }
        while (n4 <= n5) {
            coordinateArray2[n] = coordinateArray[n4];
            ++n4;
            ++n;
        }
        return coordinateArray2;
    }

    public static boolean hasRepeatedPoints(Coordinate[] coordinateArray) {
        int n = 1;
        while (n < coordinateArray.length) {
            if (coordinateArray[n - 1].equals(coordinateArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static int increasingDirection(Coordinate[] coordinateArray) {
        int n = 0;
        while (n < coordinateArray.length / 2) {
            int n2 = coordinateArray.length;
            if ((n2 = coordinateArray[n].compareTo(coordinateArray[n2 - 1 - n])) != 0) {
                return n2;
            }
            ++n;
        }
        return 1;
    }

    public static int indexOf(Coordinate coordinate, Coordinate[] coordinateArray) {
        int n = 0;
        while (n < coordinateArray.length) {
            if (coordinate.equals(coordinateArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static Coordinate[] intersection(Coordinate[] coordinateArray, Envelope envelope) {
        CoordinateList coordinateList = new CoordinateList();
        int n = 0;
        while (n < coordinateArray.length) {
            if (envelope.intersects(coordinateArray[n])) {
                coordinateList.add(coordinateArray[n], true);
            }
            ++n;
        }
        return coordinateList.toCoordinateArray();
    }

    private static boolean isEqualReversed(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        int n = 0;
        while (n < coordinateArray.length) {
            if (coordinateArray[n].compareTo(coordinateArray2[coordinateArray.length - n - 1]) != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isRing(Coordinate[] coordinateArray) {
        if (coordinateArray.length < 4) {
            return false;
        }
        return coordinateArray[0].equals2D(coordinateArray[coordinateArray.length - 1]);
    }

    public static Coordinate minCoordinate(Coordinate[] coordinateArray) {
        Coordinate coordinate = null;
        int n = 0;
        while (true) {
            Coordinate coordinate2;
            block6: {
                block5: {
                    if (n >= coordinateArray.length) {
                        return coordinate;
                    }
                    if (coordinate == null) break block5;
                    coordinate2 = coordinate;
                    if (coordinate.compareTo(coordinateArray[n]) <= 0) break block6;
                }
                coordinate2 = coordinateArray[n];
            }
            ++n;
            coordinate = coordinate2;
        }
    }

    public static Coordinate ptNotInList(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        int n = 0;
        while (n < coordinateArray.length) {
            Coordinate coordinate = coordinateArray[n];
            if (CoordinateArrays.indexOf(coordinate, coordinateArray2) < 0) {
                return coordinate;
            }
            ++n;
        }
        return null;
    }

    public static Coordinate[] removeNull(Coordinate[] coordinateArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 >= coordinateArray.length) {
                Coordinate[] coordinateArray2 = new Coordinate[n3];
                if (n3 == 0) {
                    return coordinateArray2;
                }
                n3 = 0;
                n2 = n;
                while (true) {
                    if (n2 >= coordinateArray.length) {
                        return coordinateArray2;
                    }
                    n4 = n3;
                    if (coordinateArray[n2] != null) {
                        coordinateArray2[n3] = coordinateArray[n2];
                        n4 = n3 + 1;
                    }
                    ++n2;
                    n3 = n4;
                }
            }
            n4 = n3;
            if (coordinateArray[n2] != null) {
                n4 = n3 + 1;
            }
            ++n2;
            n3 = n4;
        }
    }

    public static Coordinate[] removeRepeatedPoints(Coordinate[] coordinateArray) {
        if (!CoordinateArrays.hasRepeatedPoints(coordinateArray)) {
            return coordinateArray;
        }
        return new CoordinateList(coordinateArray, false).toCoordinateArray();
    }

    public static void reverse(Coordinate[] coordinateArray) {
        int n = coordinateArray.length - 1;
        int n2 = n / 2;
        int n3 = 0;
        while (n3 <= n2) {
            Coordinate coordinate = coordinateArray[n3];
            int n4 = n - n3;
            coordinateArray[n3] = coordinateArray[n4];
            coordinateArray[n4] = coordinate;
            ++n3;
        }
        return;
    }

    public static void scroll(Coordinate[] coordinateArray, Coordinate coordinateArray2) {
        int n = CoordinateArrays.indexOf((Coordinate)coordinateArray2, coordinateArray);
        if (n < 0) {
            return;
        }
        coordinateArray2 = new Coordinate[coordinateArray.length];
        System.arraycopy(coordinateArray, n, coordinateArray2, 0, coordinateArray.length - n);
        System.arraycopy(coordinateArray, 0, coordinateArray2, coordinateArray.length - n, n);
        System.arraycopy(coordinateArray2, 0, coordinateArray, 0, coordinateArray.length);
    }

    public static Coordinate[] toCoordinateArray(Collection collection) {
        return collection.toArray(coordArrayType);
    }

    public static class BidirectionalComparator
    implements Comparator {
        public int OLDcompare(Object coordinateArray, Object coordinateArray2) {
            if ((coordinateArray = (Coordinate[])coordinateArray).length < (coordinateArray2 = (Coordinate[])coordinateArray2).length) {
                return -1;
            }
            if (coordinateArray.length > coordinateArray2.length) {
                return 1;
            }
            if (coordinateArray.length == 0) {
                return 0;
            }
            int n = CoordinateArrays.increasingDirection(coordinateArray);
            int n2 = CoordinateArrays.increasingDirection(coordinateArray2);
            int n3 = n > 0 ? 0 : coordinateArray.length - 1;
            int n4 = n2 > 0 ? 0 : coordinateArray.length - 1;
            int n5 = 0;
            int n6 = n3;
            n3 = n5;
            while (n3 < coordinateArray.length) {
                n5 = coordinateArray[n6].compareTo(coordinateArray2[n4]);
                if (n5 != 0) {
                    return n5;
                }
                n6 += n;
                n4 += n2;
                ++n3;
            }
            return 0;
        }

        public int compare(Object coordinateArray, Object coordinateArray2) {
            if ((coordinateArray = (Coordinate[])coordinateArray).length < (coordinateArray2 = (Coordinate[])coordinateArray2).length) {
                return -1;
            }
            if (coordinateArray.length > coordinateArray2.length) {
                return 1;
            }
            if (coordinateArray.length == 0) {
                return 0;
            }
            int n = CoordinateArrays.compare(coordinateArray, coordinateArray2);
            if (CoordinateArrays.isEqualReversed(coordinateArray, coordinateArray2)) {
                return 0;
            }
            return n;
        }
    }

    public static class ForwardComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return CoordinateArrays.compare((Coordinate[])object, (Coordinate[])object2);
        }
    }
}

