/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.util.StringUtil;

public class CoordinateSequences {
    public static void copy(CoordinateSequence coordinateSequence, int n, CoordinateSequence coordinateSequence2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            CoordinateSequences.copyCoord(coordinateSequence, n + n4, coordinateSequence2, n2 + n4);
            ++n4;
        }
        return;
    }

    public static void copyCoord(CoordinateSequence coordinateSequence, int n, CoordinateSequence coordinateSequence2, int n2) {
        int n3 = Math.min(coordinateSequence.getDimension(), coordinateSequence2.getDimension());
        int n4 = 0;
        while (n4 < n3) {
            coordinateSequence2.setOrdinate(n2, n4, coordinateSequence.getOrdinate(n, n4));
            ++n4;
        }
        return;
    }

    private static CoordinateSequence createClosedRing(CoordinateSequenceFactory object, CoordinateSequence coordinateSequence, int n) {
        object = object.create(n, coordinateSequence.getDimension());
        int n2 = coordinateSequence.size();
        CoordinateSequences.copy(coordinateSequence, 0, (CoordinateSequence)object, 0, n2);
        while (n2 < n) {
            CoordinateSequences.copy(coordinateSequence, 0, (CoordinateSequence)object, n2, 1);
            ++n2;
        }
        return object;
    }

    public static CoordinateSequence ensureValidRing(CoordinateSequenceFactory coordinateSequenceFactory, CoordinateSequence coordinateSequence) {
        int n = coordinateSequence.size();
        if (n == 0) {
            return coordinateSequence;
        }
        if (n <= 3) {
            return CoordinateSequences.createClosedRing(coordinateSequenceFactory, coordinateSequence, 4);
        }
        boolean bl = false;
        double d = coordinateSequence.getOrdinate(0, 0);
        int n2 = n - 1;
        boolean bl2 = bl;
        if (d == coordinateSequence.getOrdinate(n2, 0)) {
            bl2 = bl;
            if (coordinateSequence.getOrdinate(0, 1) == coordinateSequence.getOrdinate(n2, 1)) {
                bl2 = true;
            }
        }
        if (bl2) {
            return coordinateSequence;
        }
        return CoordinateSequences.createClosedRing(coordinateSequenceFactory, coordinateSequence, n + 1);
    }

    public static CoordinateSequence extend(CoordinateSequenceFactory object, CoordinateSequence coordinateSequence, int n) {
        object = object.create(n, coordinateSequence.getDimension());
        int n2 = coordinateSequence.size();
        CoordinateSequences.copy(coordinateSequence, 0, (CoordinateSequence)object, 0, n2);
        if (n2 > 0) {
            for (int i = n2; i < n; ++i) {
                CoordinateSequences.copy(coordinateSequence, n2 - 1, (CoordinateSequence)object, i, 1);
            }
        }
        return object;
    }

    public static boolean isEqual(CoordinateSequence coordinateSequence, CoordinateSequence coordinateSequence2) {
        int n = coordinateSequence.size();
        if (n != coordinateSequence2.size()) {
            return false;
        }
        int n2 = Math.min(coordinateSequence.getDimension(), coordinateSequence2.getDimension());
        int n3 = 0;
        block0: while (true) {
            if (n3 >= n) {
                return true;
            }
            int n4 = 0;
            while (true) {
                if (n4 >= n2) {
                    ++n3;
                    continue block0;
                }
                double d = coordinateSequence.getOrdinate(n3, n4);
                double d2 = coordinateSequence2.getOrdinate(n3, n4);
                if (coordinateSequence.getOrdinate(n3, n4) != coordinateSequence2.getOrdinate(n3, n4) && (!Double.isNaN(d) || !Double.isNaN(d2))) break block0;
                ++n4;
            }
            break;
        }
        return false;
    }

    public static boolean isRing(CoordinateSequence coordinateSequence) {
        int n = coordinateSequence.size();
        if (n == 0) {
            return true;
        }
        if (n <= 3) {
            return false;
        }
        double d = coordinateSequence.getOrdinate(0, 0);
        return d == coordinateSequence.getOrdinate(--n, 0) && coordinateSequence.getOrdinate(0, 1) == coordinateSequence.getOrdinate(n, 1);
    }

    public static void reverse(CoordinateSequence coordinateSequence) {
        int n = coordinateSequence.size() - 1;
        int n2 = n / 2;
        int n3 = 0;
        while (n3 <= n2) {
            CoordinateSequences.swap(coordinateSequence, n3, n - n3);
            ++n3;
        }
        return;
    }

    public static void swap(CoordinateSequence coordinateSequence, int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = 0;
        while (n3 < coordinateSequence.getDimension()) {
            double d = coordinateSequence.getOrdinate(n, n3);
            coordinateSequence.setOrdinate(n, n3, coordinateSequence.getOrdinate(n2, n3));
            coordinateSequence.setOrdinate(n2, n3, d);
            ++n3;
        }
        return;
    }

    public static String toString(CoordinateSequence coordinateSequence) {
        int n = coordinateSequence.size();
        if (n == 0) {
            return "()";
        }
        int n2 = coordinateSequence.getDimension();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n3 = 0;
        block0: while (true) {
            if (n3 >= n) {
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            if (n3 > 0) {
                stringBuffer.append(" ");
            }
            int n4 = 0;
            while (true) {
                if (n4 >= n2) {
                    ++n3;
                    continue block0;
                }
                if (n4 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(StringUtil.toString(coordinateSequence.getOrdinate(n3, n4)));
                ++n4;
            }
            break;
        }
    }
}

