/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;

public class Envelope
implements Comparable,
Serializable {
    private static final long serialVersionUID = 5873921885273102420L;
    private double maxx;
    private double maxy;
    private double minx;
    private double miny;

    public Envelope() {
        this.init();
    }

    public Envelope(double d, double d2, double d3, double d4) {
        this.init(d, d2, d3, d4);
    }

    public Envelope(Coordinate coordinate) {
        this.init(coordinate.x, coordinate.x, coordinate.y, coordinate.y);
    }

    public Envelope(Coordinate coordinate, Coordinate coordinate2) {
        this.init(coordinate.x, coordinate2.x, coordinate.y, coordinate2.y);
    }

    public Envelope(Envelope envelope) {
        this.init(envelope);
    }

    public static boolean intersects(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate3.x;
        double d2 = coordinate.x < coordinate2.x ? coordinate.x : coordinate2.x;
        return d >= d2 && (d = coordinate3.x) <= (d2 = coordinate.x > coordinate2.x ? coordinate.x : coordinate2.x) && (d = coordinate3.y) >= (d2 = coordinate.y < coordinate2.y ? coordinate.y : coordinate2.y) && (d = coordinate3.y) <= (d2 = coordinate.y > coordinate2.y ? coordinate.y : coordinate2.y);
    }

    public static boolean intersects(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d = Math.min(coordinate3.x, coordinate4.x);
        double d2 = Math.max(coordinate3.x, coordinate4.x);
        double d3 = Math.min(coordinate.x, coordinate2.x);
        double d4 = Math.max(coordinate.x, coordinate2.x);
        if (d3 > d2) {
            return false;
        }
        if (d4 < d) {
            return false;
        }
        d4 = Math.min(coordinate3.y, coordinate4.y);
        d = Math.max(coordinate3.y, coordinate4.y);
        d2 = Math.min(coordinate.y, coordinate2.y);
        d3 = Math.max(coordinate.y, coordinate2.y);
        if (d2 > d) {
            return false;
        }
        return !(d3 < d4);
    }

    public Coordinate centre() {
        if (this.isNull()) {
            return null;
        }
        return new Coordinate((this.getMinX() + this.getMaxX()) / 2.0, (this.getMinY() + this.getMaxY()) / 2.0);
    }

    public int compareTo(Object object) {
        object = (Envelope)object;
        if (this.isNull()) {
            if (((Envelope)object).isNull()) {
                return 0;
            }
            return -1;
        }
        if (((Envelope)object).isNull()) {
            return 1;
        }
        double d = this.minx;
        double d2 = ((Envelope)object).minx;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        d = this.miny;
        d2 = ((Envelope)object).miny;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        d = this.maxx;
        d2 = ((Envelope)object).maxx;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        d = this.maxy;
        d2 = ((Envelope)object).maxy;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        return 0;
    }

    public boolean contains(double d, double d2) {
        return this.covers(d, d2);
    }

    public boolean contains(Coordinate coordinate) {
        return this.covers(coordinate);
    }

    public boolean contains(Envelope envelope) {
        return this.covers(envelope);
    }

    public boolean covers(double d, double d2) {
        if (this.isNull()) {
            return false;
        }
        return d >= this.minx && d <= this.maxx && d2 >= this.miny && d2 <= this.maxy;
    }

    public boolean covers(Coordinate coordinate) {
        return this.covers(coordinate.x, coordinate.y);
    }

    public boolean covers(Envelope envelope) {
        return !this.isNull() && !envelope.isNull() && envelope.getMinX() >= this.minx && envelope.getMaxX() <= this.maxx && envelope.getMinY() >= this.miny && envelope.getMaxY() <= this.maxy;
    }

    public double distance(Envelope envelope) {
        if (this.intersects(envelope)) {
            return 0.0;
        }
        double d = this.maxx;
        double d2 = envelope.minx;
        d = d < d2 ? d2 - d : ((d2 = this.minx) > (d = envelope.maxx) ? d2 - d : 0.0);
        double d3 = this.maxy;
        d2 = envelope.miny;
        d2 = d3 < d2 ? (d2 -= d3) : ((d3 = this.miny) > (d2 = envelope.maxy) ? d3 - d2 : 0.0);
        if (d == 0.0) {
            return d2;
        }
        if (d2 == 0.0) {
            return d;
        }
        return Math.sqrt(d * d + d2 * d2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Envelope)) {
            return false;
        }
        object = (Envelope)object;
        if (this.isNull()) {
            return ((Envelope)object).isNull();
        }
        return this.maxx == ((Envelope)object).getMaxX() && this.maxy == ((Envelope)object).getMaxY() && this.minx == ((Envelope)object).getMinX() && this.miny == ((Envelope)object).getMinY();
    }

    public void expandBy(double d) {
        this.expandBy(d, d);
    }

    public void expandBy(double d, double d2) {
        double d3;
        double d4;
        if (this.isNull()) {
            return;
        }
        this.minx = d4 = this.minx - d;
        this.maxx = d = this.maxx + d;
        this.miny = d3 = this.miny - d2;
        this.maxy = d2 = this.maxy + d2;
        if (d4 > d || d3 > d2) {
            this.setToNull();
        }
    }

    public void expandToInclude(double d, double d2) {
        if (this.isNull()) {
            this.minx = d;
            this.maxx = d;
            this.miny = d2;
            this.maxy = d2;
        } else {
            if (d < this.minx) {
                this.minx = d;
            }
            if (d > this.maxx) {
                this.maxx = d;
            }
            if (d2 < this.miny) {
                this.miny = d2;
            }
            if (d2 > this.maxy) {
                this.maxy = d2;
            }
        }
    }

    public void expandToInclude(Coordinate coordinate) {
        this.expandToInclude(coordinate.x, coordinate.y);
    }

    public void expandToInclude(Envelope envelope) {
        if (envelope.isNull()) {
            return;
        }
        if (this.isNull()) {
            this.minx = envelope.getMinX();
            this.maxx = envelope.getMaxX();
            this.miny = envelope.getMinY();
            this.maxy = envelope.getMaxY();
        } else {
            double d = envelope.minx;
            if (d < this.minx) {
                this.minx = d;
            }
            if ((d = envelope.maxx) > this.maxx) {
                this.maxx = d;
            }
            if ((d = envelope.miny) < this.miny) {
                this.miny = d;
            }
            if ((d = envelope.maxy) > this.maxy) {
                this.maxy = d;
            }
        }
    }

    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    public double getHeight() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxy - this.miny;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMinY() {
        return this.miny;
    }

    public double getWidth() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxx - this.minx;
    }

    public int hashCode() {
        return (((629 + Coordinate.hashCode(this.minx)) * 37 + Coordinate.hashCode(this.maxx)) * 37 + Coordinate.hashCode(this.miny)) * 37 + Coordinate.hashCode(this.maxy);
    }

    public void init() {
        this.setToNull();
    }

    public void init(double d, double d2, double d3, double d4) {
        if (d < d2) {
            this.minx = d;
            this.maxx = d2;
        } else {
            this.minx = d2;
            this.maxx = d;
        }
        if (d3 < d4) {
            this.miny = d3;
            this.maxy = d4;
        } else {
            this.miny = d4;
            this.maxy = d3;
        }
    }

    public void init(Coordinate coordinate) {
        this.init(coordinate.x, coordinate.x, coordinate.y, coordinate.y);
    }

    public void init(Coordinate coordinate, Coordinate coordinate2) {
        this.init(coordinate.x, coordinate2.x, coordinate.y, coordinate2.y);
    }

    public void init(Envelope envelope) {
        this.minx = envelope.minx;
        this.maxx = envelope.maxx;
        this.miny = envelope.miny;
        this.maxy = envelope.maxy;
    }

    public Envelope intersection(Envelope envelope) {
        if (!this.isNull() && !envelope.isNull() && this.intersects(envelope)) {
            double d;
            double d2 = this.minx;
            double d3 = envelope.minx;
            if (d2 > d3) {
                d3 = d2;
            }
            if (!((d2 = this.miny) > (d = envelope.miny))) {
                d2 = d;
            }
            d = this.maxx;
            double d4 = envelope.maxx;
            if (!(d < d4)) {
                d = d4;
            }
            d4 = this.maxy;
            double d5 = envelope.maxy;
            if (!(d4 < d5)) {
                d4 = d5;
            }
            return new Envelope(d3, d, d2, d4);
        }
        return new Envelope();
    }

    public boolean intersects(double d, double d2) {
        boolean bl = this.isNull();
        boolean bl2 = false;
        if (bl) {
            return false;
        }
        bl = bl2;
        if (!(d > this.maxx)) {
            bl = bl2;
            if (!(d < this.minx)) {
                bl = bl2;
                if (!(d2 > this.maxy)) {
                    bl = d2 < this.miny ? bl2 : true;
                }
            }
        }
        return bl;
    }

    public boolean intersects(Coordinate coordinate) {
        return this.intersects(coordinate.x, coordinate.y);
    }

    public boolean intersects(Envelope envelope) {
        boolean bl;
        boolean bl2 = this.isNull();
        boolean bl3 = bl = false;
        if (!bl2) {
            if (envelope.isNull()) {
                bl3 = bl;
            } else {
                bl3 = bl;
                if (!(envelope.minx > this.maxx)) {
                    bl3 = bl;
                    if (!(envelope.maxx < this.minx)) {
                        bl3 = bl;
                        if (!(envelope.miny > this.maxy)) {
                            bl3 = envelope.maxy < this.miny ? bl : true;
                        }
                    }
                }
            }
        }
        return bl3;
    }

    public boolean isNull() {
        return this.maxx < this.minx;
    }

    public double maxExtent() {
        double d;
        if (this.isNull()) {
            return 0.0;
        }
        double d2 = this.getWidth();
        if (d2 > (d = this.getHeight())) {
            return d2;
        }
        return d;
    }

    public double minExtent() {
        double d;
        if (this.isNull()) {
            return 0.0;
        }
        double d2 = this.getWidth();
        if (d2 < (d = this.getHeight())) {
            return d2;
        }
        return d;
    }

    public boolean overlaps(double d, double d2) {
        return this.intersects(d, d2);
    }

    public boolean overlaps(Coordinate coordinate) {
        return this.intersects(coordinate);
    }

    public boolean overlaps(Envelope envelope) {
        return this.intersects(envelope);
    }

    public void setToNull() {
        this.minx = 0.0;
        this.maxx = -1.0;
        this.miny = 0.0;
        this.maxy = -1.0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Env[");
        stringBuilder.append(this.minx);
        stringBuilder.append(" : ");
        stringBuilder.append(this.maxx);
        stringBuilder.append(", ");
        stringBuilder.append(this.miny);
        stringBuilder.append(" : ");
        stringBuilder.append(this.maxy);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void translate(double d, double d2) {
        if (this.isNull()) {
            return;
        }
        this.init(this.getMinX() + d, this.getMaxX() + d, this.getMinY() + d2, this.getMaxY() + d2);
    }
}

