/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.Centroid;
import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.algorithm.InteriorPointArea;
import com.vividsolutions.jts.algorithm.InteriorPointLine;
import com.vividsolutions.jts.algorithm.InteriorPointPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryCollectionMapper;
import com.vividsolutions.jts.geom.util.GeometryMapper;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.IsSimpleOp;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import com.vividsolutions.jts.operation.predicate.RectangleContains;
import com.vividsolutions.jts.operation.predicate.RectangleIntersects;
import com.vividsolutions.jts.operation.relate.RelateOp;
import com.vividsolutions.jts.operation.union.UnaryUnionOp;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.Collection;

public abstract class Geometry
implements Cloneable,
Comparable,
Serializable {
    private static final GeometryComponentFilter geometryChangedFilter;
    private static final long serialVersionUID = 8763622679187376702L;
    private static final Class[] sortedClasses;
    protected int SRID;
    protected Envelope envelope;
    protected final GeometryFactory factory;
    private Object userData = null;

    static {
        sortedClasses = new Class[]{Point.class, MultiPoint.class, LineString.class, LinearRing.class, MultiLineString.class, Polygon.class, MultiPolygon.class, GeometryCollection.class};
        geometryChangedFilter = new GeometryComponentFilter(){

            @Override
            public void filter(Geometry geometry) {
                geometry.geometryChangedAction();
            }
        };
    }

    public Geometry(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
        this.SRID = geometryFactory.getSRID();
    }

    private Point createPointFromInternalCoord(Coordinate coordinate, Geometry geometry) {
        geometry.getPrecisionModel().makePrecise(coordinate);
        return geometry.getFactory().createPoint(coordinate);
    }

    private int getClassSortIndex() {
        int n = 0;
        while (true) {
            Object object;
            if (n >= ((Class[])(object = sortedClasses)).length) {
                object = new StringBuilder("Class not supported: ");
                ((StringBuilder)object).append(this.getClass());
                Assert.shouldNeverReachHere(((StringBuilder)object).toString());
                return -1;
            }
            if (object[n].isInstance(this)) {
                return n;
            }
            ++n;
        }
    }

    protected static boolean hasNonEmptyElements(Geometry[] geometryArray) {
        int n = 0;
        while (n < geometryArray.length) {
            if (!geometryArray[n].isEmpty()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected static boolean hasNullElements(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract void apply(CoordinateFilter var1);

    public abstract void apply(CoordinateSequenceFilter var1);

    public abstract void apply(GeometryComponentFilter var1);

    public abstract void apply(GeometryFilter var1);

    public Geometry buffer(double d) {
        return BufferOp.bufferOp(this, d);
    }

    public Geometry buffer(double d, int n) {
        return BufferOp.bufferOp(this, d, n);
    }

    public Geometry buffer(double d, int n, int n2) {
        return BufferOp.bufferOp(this, d, n, n2);
    }

    protected void checkNotGeometryCollection(Geometry geometry) {
        if (!geometry.getClass().getName().equals("com.vividsolutions.jts.geom.GeometryCollection")) {
            return;
        }
        throw new IllegalArgumentException("This method does not support GeometryCollection arguments");
    }

    public Object clone() {
        Geometry geometry;
        block3: {
            Envelope envelope;
            Envelope envelope2;
            try {
                geometry = (Geometry)super.clone();
                envelope2 = geometry.envelope;
                if (envelope2 == null) break block3;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Assert.shouldNeverReachHere();
                return null;
            }
            geometry.envelope = envelope = new Envelope(envelope2);
        }
        return geometry;
    }

    protected int compare(Collection object, Collection object2) {
        object = object.iterator();
        object2 = object2.iterator();
        while (object.hasNext() && object2.hasNext()) {
            int n = ((Comparable)object.next()).compareTo((Comparable)object2.next());
            if (n == 0) continue;
            return n;
        }
        if (object.hasNext()) {
            return 1;
        }
        if (object2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        Geometry geometry = (Geometry)object;
        if (this.getClassSortIndex() != geometry.getClassSortIndex()) {
            return this.getClassSortIndex() - geometry.getClassSortIndex();
        }
        if (this.isEmpty() && geometry.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (geometry.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(object);
    }

    public int compareTo(Object object, CoordinateSequenceComparator coordinateSequenceComparator) {
        Geometry geometry = (Geometry)object;
        if (this.getClassSortIndex() != geometry.getClassSortIndex()) {
            return this.getClassSortIndex() - geometry.getClassSortIndex();
        }
        if (this.isEmpty() && geometry.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (geometry.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(object, coordinateSequenceComparator);
    }

    protected abstract int compareToSameClass(Object var1);

    protected abstract int compareToSameClass(Object var1, CoordinateSequenceComparator var2);

    protected abstract Envelope computeEnvelopeInternal();

    public boolean contains(Geometry geometry) {
        if (!this.getEnvelopeInternal().contains(geometry.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return RectangleContains.contains((Polygon)this, geometry);
        }
        return this.relate(geometry).isContains();
    }

    public Geometry convexHull() {
        return new ConvexHull(this).getConvexHull();
    }

    public boolean coveredBy(Geometry geometry) {
        return geometry.covers(this);
    }

    public boolean covers(Geometry geometry) {
        if (!this.getEnvelopeInternal().covers(geometry.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return true;
        }
        return this.relate(geometry).isCovers();
    }

    public boolean crosses(Geometry geometry) {
        if (!this.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(geometry).isCrosses(this.getDimension(), geometry.getDimension());
    }

    public Geometry difference(Geometry geometry) {
        if (this.isEmpty()) {
            return OverlayOp.createEmptyResult(3, this, geometry, this.factory);
        }
        if (geometry.isEmpty()) {
            return (Geometry)this.clone();
        }
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return SnapIfNeededOverlayOp.overlayOp(this, geometry, 3);
    }

    public boolean disjoint(Geometry geometry) {
        return this.intersects(geometry) ^ true;
    }

    public double distance(Geometry geometry) {
        return DistanceOp.distance(this, geometry);
    }

    protected boolean equal(Coordinate coordinate, Coordinate coordinate2, double d) {
        if (d == 0.0) {
            return coordinate.equals(coordinate2);
        }
        return coordinate.distance(coordinate2) <= d;
    }

    public boolean equals(Geometry geometry) {
        if (geometry == null) {
            return false;
        }
        return this.equalsTopo(geometry);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Geometry)) {
            return false;
        }
        return this.equalsExact((Geometry)object);
    }

    public boolean equalsExact(Geometry geometry) {
        return this == geometry || this.equalsExact(geometry, 0.0);
    }

    public abstract boolean equalsExact(Geometry var1, double var2);

    public boolean equalsNorm(Geometry geometry) {
        if (geometry == null) {
            return false;
        }
        return this.norm().equalsExact(geometry.norm());
    }

    public boolean equalsTopo(Geometry geometry) {
        if (!this.getEnvelopeInternal().equals(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(geometry).isEquals(this.getDimension(), geometry.getDimension());
    }

    public void geometryChanged() {
        this.apply(geometryChangedFilter);
    }

    protected void geometryChangedAction() {
        this.envelope = null;
    }

    public double getArea() {
        return 0.0;
    }

    public abstract Geometry getBoundary();

    public abstract int getBoundaryDimension();

    public Point getCentroid() {
        if (this.isEmpty()) {
            return this.factory.createPoint((Coordinate)null);
        }
        return this.createPointFromInternalCoord(Centroid.getCentroid(this), this);
    }

    public abstract Coordinate getCoordinate();

    public abstract Coordinate[] getCoordinates();

    public abstract int getDimension();

    public Geometry getEnvelope() {
        return this.getFactory().toGeometry(this.getEnvelopeInternal());
    }

    public Envelope getEnvelopeInternal() {
        if (this.envelope == null) {
            this.envelope = this.computeEnvelopeInternal();
        }
        return new Envelope(this.envelope);
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public Geometry getGeometryN(int n) {
        return this;
    }

    public abstract String getGeometryType();

    public Point getInteriorPoint() {
        if (this.isEmpty()) {
            return this.factory.createPoint((Coordinate)null);
        }
        int n = this.getDimension();
        Coordinate coordinate = n == 0 ? new InteriorPointPoint(this).getInteriorPoint() : (n == 1 ? new InteriorPointLine(this).getInteriorPoint() : new InteriorPointArea(this).getInteriorPoint());
        return this.createPointFromInternalCoord(coordinate, this);
    }

    public double getLength() {
        return 0.0;
    }

    public int getNumGeometries() {
        return 1;
    }

    public abstract int getNumPoints();

    public PrecisionModel getPrecisionModel() {
        return this.factory.getPrecisionModel();
    }

    public int getSRID() {
        return this.SRID;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int hashCode() {
        return this.getEnvelopeInternal().hashCode();
    }

    public Geometry intersection(final Geometry geometry) {
        if (!this.isEmpty() && !geometry.isEmpty()) {
            if (this.isGeometryCollection()) {
                return GeometryCollectionMapper.map((GeometryCollection)this, new GeometryMapper.MapOp(){

                    @Override
                    public Geometry map(Geometry geometry2) {
                        return geometry2.intersection(geometry);
                    }
                });
            }
            this.checkNotGeometryCollection(this);
            this.checkNotGeometryCollection(geometry);
            return SnapIfNeededOverlayOp.overlayOp(this, geometry, 1);
        }
        return OverlayOp.createEmptyResult(1, this, geometry, this.factory);
    }

    public boolean intersects(Geometry geometry) {
        if (!this.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)this, geometry);
        }
        if (geometry.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)geometry, this);
        }
        return this.relate(geometry).isIntersects();
    }

    public abstract boolean isEmpty();

    protected boolean isEquivalentClass(Geometry geometry) {
        return this.getClass().getName().equals(geometry.getClass().getName());
    }

    protected boolean isGeometryCollection() {
        return this.getClass().equals(GeometryCollection.class);
    }

    public boolean isRectangle() {
        return false;
    }

    public boolean isSimple() {
        return new IsSimpleOp(this).isSimple();
    }

    public boolean isValid() {
        return IsValidOp.isValid(this);
    }

    public boolean isWithinDistance(Geometry geometry, double d) {
        if (this.getEnvelopeInternal().distance(geometry.getEnvelopeInternal()) > d) {
            return false;
        }
        return DistanceOp.isWithinDistance(this, geometry, d);
    }

    public Geometry norm() {
        Geometry geometry = (Geometry)this.clone();
        geometry.normalize();
        return geometry;
    }

    public abstract void normalize();

    public boolean overlaps(Geometry geometry) {
        if (!this.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(geometry).isOverlaps(this.getDimension(), geometry.getDimension());
    }

    public IntersectionMatrix relate(Geometry geometry) {
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return RelateOp.relate(this, geometry);
    }

    public boolean relate(Geometry geometry, String string2) {
        return this.relate(geometry).matches(string2);
    }

    public abstract Geometry reverse();

    public void setSRID(int n) {
        this.SRID = n;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Geometry symDifference(Geometry geometry) {
        if (this.isEmpty() || geometry.isEmpty()) {
            if (this.isEmpty() && geometry.isEmpty()) {
                return OverlayOp.createEmptyResult(4, this, geometry, this.factory);
            }
            if (this.isEmpty()) {
                return (Geometry)geometry.clone();
            }
            if (geometry.isEmpty()) {
                return (Geometry)this.clone();
            }
        }
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return SnapIfNeededOverlayOp.overlayOp(this, geometry, 4);
    }

    public String toString() {
        return this.toText();
    }

    public String toText() {
        return new WKTWriter().write(this);
    }

    public boolean touches(Geometry geometry) {
        if (!this.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(geometry).isTouches(this.getDimension(), geometry.getDimension());
    }

    public Geometry union() {
        return UnaryUnionOp.union(this);
    }

    public Geometry union(Geometry geometry) {
        if (this.isEmpty() || geometry.isEmpty()) {
            if (this.isEmpty() && geometry.isEmpty()) {
                return OverlayOp.createEmptyResult(2, this, geometry, this.factory);
            }
            if (this.isEmpty()) {
                return (Geometry)geometry.clone();
            }
            if (geometry.isEmpty()) {
                return (Geometry)this.clone();
            }
        }
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return SnapIfNeededOverlayOp.overlayOp(this, geometry, 2);
    }

    public boolean within(Geometry geometry) {
        return geometry.contains(this);
    }
}

