/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GeometryCollectionIterator
implements Iterator {
    private boolean atStart;
    private int index;
    private int max;
    private Geometry parent;
    private GeometryCollectionIterator subcollectionIterator;

    public GeometryCollectionIterator(Geometry geometry) {
        this.parent = geometry;
        this.atStart = true;
        this.index = 0;
        this.max = geometry.getNumGeometries();
    }

    private static boolean isAtomic(Geometry geometry) {
        return geometry instanceof GeometryCollection ^ true;
    }

    @Override
    public boolean hasNext() {
        if (this.atStart) {
            return true;
        }
        GeometryCollectionIterator geometryCollectionIterator = this.subcollectionIterator;
        if (geometryCollectionIterator != null) {
            if (geometryCollectionIterator.hasNext()) {
                return true;
            }
            this.subcollectionIterator = null;
        }
        return this.index < this.max;
    }

    public Object next() {
        int n;
        if (this.atStart) {
            this.atStart = false;
            if (GeometryCollectionIterator.isAtomic(this.parent)) {
                ++this.index;
            }
            return this.parent;
        }
        Object object = this.subcollectionIterator;
        if (object != null) {
            if (((GeometryCollectionIterator)object).hasNext()) {
                return this.subcollectionIterator.next();
            }
            this.subcollectionIterator = null;
        }
        if ((n = this.index) < this.max) {
            object = this.parent;
            this.index = n + 1;
            Geometry geometry = ((Geometry)object).getGeometryN(n);
            object = geometry;
            if (geometry instanceof GeometryCollection) {
                this.subcollectionIterator = object = new GeometryCollectionIterator((GeometryCollection)geometry);
                object = ((GeometryCollectionIterator)object).next();
            }
            return object;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

