/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import com.vividsolutions.jts.geom.util.GeometryEditor;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class GeometryFactory
implements Serializable {
    private static final long serialVersionUID = -6820524753094095635L;
    private int SRID;
    private CoordinateSequenceFactory coordinateSequenceFactory;
    private PrecisionModel precisionModel;

    public GeometryFactory() {
        this(new PrecisionModel(), 0);
    }

    public GeometryFactory(CoordinateSequenceFactory coordinateSequenceFactory) {
        this(new PrecisionModel(), 0, coordinateSequenceFactory);
    }

    public GeometryFactory(PrecisionModel precisionModel) {
        this(precisionModel, 0, GeometryFactory.getDefaultCoordinateSequenceFactory());
    }

    public GeometryFactory(PrecisionModel precisionModel, int n) {
        this(precisionModel, n, GeometryFactory.getDefaultCoordinateSequenceFactory());
    }

    public GeometryFactory(PrecisionModel precisionModel, int n, CoordinateSequenceFactory coordinateSequenceFactory) {
        this.precisionModel = precisionModel;
        this.coordinateSequenceFactory = coordinateSequenceFactory;
        this.SRID = n;
    }

    public static Point createPointFromInternalCoord(Coordinate coordinate, Geometry geometry) {
        geometry.getPrecisionModel().makePrecise(coordinate);
        return geometry.getFactory().createPoint(coordinate);
    }

    private static CoordinateSequenceFactory getDefaultCoordinateSequenceFactory() {
        return CoordinateArraySequenceFactory.instance();
    }

    public static Geometry[] toGeometryArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new Geometry[collection.size()]);
    }

    public static LineString[] toLineStringArray(Collection collection) {
        return collection.toArray(new LineString[collection.size()]);
    }

    public static LinearRing[] toLinearRingArray(Collection collection) {
        return collection.toArray(new LinearRing[collection.size()]);
    }

    public static MultiLineString[] toMultiLineStringArray(Collection collection) {
        return collection.toArray(new MultiLineString[collection.size()]);
    }

    public static MultiPoint[] toMultiPointArray(Collection collection) {
        return collection.toArray(new MultiPoint[collection.size()]);
    }

    public static MultiPolygon[] toMultiPolygonArray(Collection collection) {
        return collection.toArray(new MultiPolygon[collection.size()]);
    }

    public static Point[] toPointArray(Collection collection) {
        return collection.toArray(new Point[collection.size()]);
    }

    public static Polygon[] toPolygonArray(Collection collection) {
        return collection.toArray(new Polygon[collection.size()]);
    }

    public Geometry buildGeometry(Collection object) {
        Iterator iterator2 = object.iterator();
        boolean bl = false;
        Geometry geometry = null;
        boolean bl2 = false;
        boolean bl3 = false;
        while (true) {
            Serializable serializable;
            if (!iterator2.hasNext()) {
                if (geometry == null) {
                    return this.createGeometryCollection(null);
                }
                if (!bl2 && !bl3) {
                    serializable = (Geometry)object.iterator().next();
                    bl3 = bl;
                    if (object.size() > 1) {
                        bl3 = true;
                    }
                    if (bl3) {
                        if (serializable instanceof Polygon) {
                            return this.createMultiPolygon(GeometryFactory.toPolygonArray((Collection)object));
                        }
                        if (serializable instanceof LineString) {
                            return this.createMultiLineString(GeometryFactory.toLineStringArray((Collection)object));
                        }
                        if (serializable instanceof Point) {
                            return this.createMultiPoint(GeometryFactory.toPointArray((Collection)object));
                        }
                        object = new StringBuilder("Unhandled class: ");
                        ((StringBuilder)object).append(serializable.getClass().getName());
                        Assert.shouldNeverReachHere(((StringBuilder)object).toString());
                    }
                    return serializable;
                }
                return this.createGeometryCollection(GeometryFactory.toGeometryArray((Collection)object));
            }
            Geometry geometry2 = (Geometry)iterator2.next();
            Class<?> clazz = geometry2.getClass();
            serializable = geometry;
            if (geometry == null) {
                serializable = clazz;
            }
            boolean bl4 = bl2;
            if (clazz != serializable) {
                bl4 = true;
            }
            geometry = serializable;
            bl2 = bl4;
            if (!(geometry2 instanceof GeometryCollection)) continue;
            bl3 = true;
            geometry = serializable;
            bl2 = bl4;
        }
    }

    public Geometry createGeometry(Geometry geometry) {
        return new GeometryEditor(this).edit(geometry, new GeometryEditor.CoordinateSequenceOperation(){

            @Override
            public CoordinateSequence edit(CoordinateSequence coordinateSequence, Geometry geometry) {
                return GeometryFactory.this.coordinateSequenceFactory.create(coordinateSequence);
            }
        });
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometryArray) {
        return new GeometryCollection(geometryArray, this);
    }

    public LineString createLineString(CoordinateSequence coordinateSequence) {
        return new LineString(coordinateSequence, this);
    }

    public LineString createLineString(Coordinate[] object) {
        object = object != null ? this.getCoordinateSequenceFactory().create((Coordinate[])object) : null;
        return this.createLineString((CoordinateSequence)object);
    }

    public LinearRing createLinearRing(CoordinateSequence coordinateSequence) {
        return new LinearRing(coordinateSequence, this);
    }

    public LinearRing createLinearRing(Coordinate[] object) {
        object = object != null ? this.getCoordinateSequenceFactory().create((Coordinate[])object) : null;
        return this.createLinearRing((CoordinateSequence)object);
    }

    public MultiLineString createMultiLineString(LineString[] lineStringArray) {
        return new MultiLineString(lineStringArray, this);
    }

    public MultiPoint createMultiPoint(CoordinateSequence coordinateSequence) {
        if (coordinateSequence == null) {
            return this.createMultiPoint(new Point[0]);
        }
        Point[] pointArray = new Point[coordinateSequence.size()];
        int n = 0;
        while (n < coordinateSequence.size()) {
            CoordinateSequence coordinateSequence2 = this.getCoordinateSequenceFactory().create(1, coordinateSequence.getDimension());
            CoordinateSequences.copy(coordinateSequence, n, coordinateSequence2, 0, 1);
            pointArray[n] = this.createPoint(coordinateSequence2);
            ++n;
        }
        return this.createMultiPoint(pointArray);
    }

    public MultiPoint createMultiPoint(Coordinate[] object) {
        object = object != null ? this.getCoordinateSequenceFactory().create((Coordinate[])object) : null;
        return this.createMultiPoint((CoordinateSequence)object);
    }

    public MultiPoint createMultiPoint(Point[] pointArray) {
        return new MultiPoint(pointArray, this);
    }

    public MultiPolygon createMultiPolygon(Polygon[] polygonArray) {
        return new MultiPolygon(polygonArray, this);
    }

    public Point createPoint(Coordinate cloneable) {
        cloneable = cloneable != null ? this.getCoordinateSequenceFactory().create(new Coordinate[]{cloneable}) : null;
        return this.createPoint((CoordinateSequence)cloneable);
    }

    public Point createPoint(CoordinateSequence coordinateSequence) {
        return new Point(coordinateSequence, this);
    }

    public Polygon createPolygon(CoordinateSequence coordinateSequence) {
        return this.createPolygon(this.createLinearRing(coordinateSequence));
    }

    public Polygon createPolygon(LinearRing linearRing) {
        return this.createPolygon(linearRing, null);
    }

    public Polygon createPolygon(LinearRing linearRing, LinearRing[] linearRingArray) {
        return new Polygon(linearRing, linearRingArray, this);
    }

    public Polygon createPolygon(Coordinate[] coordinateArray) {
        return this.createPolygon(this.createLinearRing(coordinateArray));
    }

    public CoordinateSequenceFactory getCoordinateSequenceFactory() {
        return this.coordinateSequenceFactory;
    }

    public PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public int getSRID() {
        return this.SRID;
    }

    public Geometry toGeometry(Envelope envelope) {
        if (envelope.isNull()) {
            return this.createPoint((CoordinateSequence)null);
        }
        if (envelope.getMinX() == envelope.getMaxX() && envelope.getMinY() == envelope.getMaxY()) {
            return this.createPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        }
        if (envelope.getMinX() != envelope.getMaxX() && envelope.getMinY() != envelope.getMaxY()) {
            return this.createPolygon(this.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
        }
        return this.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY())});
    }
}

