/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.BoundaryOp;

public class LineString
extends Geometry
implements Lineal {
    private static final long serialVersionUID = 3110669828065365560L;
    protected CoordinateSequence points;

    public LineString(CoordinateSequence coordinateSequence, GeometryFactory geometryFactory) {
        super(geometryFactory);
        this.init(coordinateSequence);
    }

    public LineString(Coordinate[] coordinateArray, PrecisionModel precisionModel, int n) {
        super(new GeometryFactory(precisionModel, n));
        this.init(this.getFactory().getCoordinateSequenceFactory().create(coordinateArray));
    }

    private void init(CoordinateSequence object) {
        CoordinateSequence coordinateSequence = object;
        if (object == null) {
            coordinateSequence = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        if (coordinateSequence.size() != 1) {
            this.points = coordinateSequence;
            return;
        }
        object = new StringBuilder("Invalid number of points in LineString (found ");
        ((StringBuilder)object).append(coordinateSequence.size());
        ((StringBuilder)object).append(" - must be 0 or >= 2)");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public void apply(CoordinateFilter coordinateFilter) {
        int n = 0;
        while (n < this.points.size()) {
            coordinateFilter.filter(this.points.getCoordinate(n));
            ++n;
        }
        return;
    }

    @Override
    public void apply(CoordinateSequenceFilter coordinateSequenceFilter) {
        if (this.points.size() == 0) {
            return;
        }
        int n = 0;
        while (true) {
            block7: {
                block6: {
                    if (n >= this.points.size()) break block6;
                    coordinateSequenceFilter.filter(this.points, n);
                    if (!coordinateSequenceFilter.isDone()) break block7;
                }
                if (coordinateSequenceFilter.isGeometryChanged()) {
                    this.geometryChanged();
                }
                return;
            }
            ++n;
        }
    }

    @Override
    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
    }

    @Override
    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    @Override
    public Object clone() {
        LineString lineString = (LineString)super.clone();
        lineString.points = (CoordinateSequence)this.points.clone();
        return lineString;
    }

    @Override
    protected int compareToSameClass(Object object) {
        int n;
        object = (LineString)object;
        int n2 = 0;
        for (n = 0; n2 < this.points.size() && n < ((LineString)object).points.size(); ++n2, ++n) {
            int n3 = this.points.getCoordinate(n2).compareTo(((LineString)object).points.getCoordinate(n));
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 < this.points.size()) {
            return 1;
        }
        if (n < ((LineString)object).points.size()) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int compareToSameClass(Object object, CoordinateSequenceComparator coordinateSequenceComparator) {
        object = (LineString)object;
        return coordinateSequenceComparator.compare(this.points, ((LineString)object).points);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return this.points.expandEnvelope(new Envelope());
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        geometry = (LineString)geometry;
        if (this.points.size() != ((LineString)geometry).points.size()) {
            return false;
        }
        int n = 0;
        while (n < this.points.size()) {
            if (!this.equal(this.points.getCoordinate(n), ((LineString)geometry).points.getCoordinate(n), d)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    @Override
    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.points.getCoordinate(0);
    }

    public Coordinate getCoordinateN(int n) {
        return this.points.getCoordinate(n);
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.points;
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.points.toCoordinateArray();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    public Point getEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(this.getNumPoints() - 1);
    }

    @Override
    public String getGeometryType() {
        return "LineString";
    }

    @Override
    public double getLength() {
        return CGAlgorithms.length(this.points);
    }

    @Override
    public int getNumPoints() {
        return this.points.size();
    }

    public Point getPointN(int n) {
        return this.getFactory().createPoint(this.points.getCoordinate(n));
    }

    public Point getStartPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(0);
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints() - 1));
    }

    public boolean isCoordinate(Coordinate coordinate) {
        int n = 0;
        while (n < this.points.size()) {
            if (this.points.getCoordinate(n).equals(coordinate)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    @Override
    protected boolean isEquivalentClass(Geometry geometry) {
        return geometry instanceof LineString;
    }

    public boolean isRing() {
        return this.isClosed() && this.isSimple();
    }

    @Override
    public void normalize() {
        int n = 0;
        while (n < this.points.size() / 2) {
            int n2 = this.points.size() - 1 - n;
            if (!this.points.getCoordinate(n).equals(this.points.getCoordinate(n2))) {
                if (this.points.getCoordinate(n).compareTo(this.points.getCoordinate(n2)) > 0) {
                    CoordinateSequences.reverse(this.points);
                }
                return;
            }
            ++n;
        }
        return;
    }

    @Override
    public Geometry reverse() {
        CoordinateSequence coordinateSequence = (CoordinateSequence)this.points.clone();
        CoordinateSequences.reverse(coordinateSequence);
        return this.getFactory().createLineString(coordinateSequence);
    }
}

