/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;

public class LinearRing
extends LineString {
    public static final int MINIMUM_VALID_SIZE = 4;
    private static final long serialVersionUID = -4261142084085851829L;

    public LinearRing(CoordinateSequence coordinateSequence, GeometryFactory geometryFactory) {
        super(coordinateSequence, geometryFactory);
        this.validateConstruction();
    }

    private LinearRing(Coordinate[] coordinateArray, GeometryFactory geometryFactory) {
        this(geometryFactory.getCoordinateSequenceFactory().create(coordinateArray), geometryFactory);
    }

    public LinearRing(Coordinate[] coordinateArray, PrecisionModel precisionModel, int n) {
        this(coordinateArray, new GeometryFactory(precisionModel, n));
        this.validateConstruction();
    }

    private void validateConstruction() {
        if (!this.isEmpty() && !super.isClosed()) {
            throw new IllegalArgumentException("Points of LinearRing do not form a closed linestring");
        }
        if (this.getCoordinateSequence().size() >= 1 && this.getCoordinateSequence().size() < 4) {
            StringBuilder stringBuilder = new StringBuilder("Invalid number of points in LinearRing (found ");
            stringBuilder.append(this.getCoordinateSequence().size());
            stringBuilder.append(" - must be 0 or >= 4)");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    @Override
    public int getBoundaryDimension() {
        return -1;
    }

    @Override
    public String getGeometryType() {
        return "LinearRing";
    }

    @Override
    public boolean isClosed() {
        if (this.isEmpty()) {
            return true;
        }
        return super.isClosed();
    }

    @Override
    public Geometry reverse() {
        CoordinateSequence coordinateSequence = (CoordinateSequence)this.points.clone();
        CoordinateSequences.reverse(coordinateSequence);
        return this.getFactory().createLinearRing(coordinateSequence);
    }
}

