/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.Serializable;
import java.util.ArrayList;

public class OctagonalEnvelope {
    private static double SQRT2 = Math.sqrt(2.0);
    private double maxA;
    private double maxB;
    private double maxX;
    private double maxY;
    private double minA;
    private double minB;
    private double minX = Double.NaN;
    private double minY;

    public OctagonalEnvelope() {
    }

    public OctagonalEnvelope(Coordinate coordinate) {
        this.expandToInclude(coordinate);
    }

    public OctagonalEnvelope(Coordinate coordinate, Coordinate coordinate2) {
        this.expandToInclude(coordinate);
        this.expandToInclude(coordinate2);
    }

    public OctagonalEnvelope(Envelope envelope) {
        this.expandToInclude(envelope);
    }

    public OctagonalEnvelope(Geometry geometry) {
        this.expandToInclude(geometry);
    }

    public OctagonalEnvelope(OctagonalEnvelope octagonalEnvelope) {
        this.expandToInclude(octagonalEnvelope);
    }

    private static double computeA(double d, double d2) {
        return d + d2;
    }

    private static double computeB(double d, double d2) {
        return d - d2;
    }

    private boolean isValid() {
        if (this.isNull()) {
            return true;
        }
        return this.minX <= this.maxX && this.minY <= this.maxY && this.minA <= this.maxA && this.minB <= this.maxB;
    }

    public static Geometry octagonalEnvelope(Geometry geometry) {
        return new OctagonalEnvelope(geometry).toGeometry(geometry.getFactory());
    }

    public boolean contains(OctagonalEnvelope octagonalEnvelope) {
        return !this.isNull() && !octagonalEnvelope.isNull() && octagonalEnvelope.minX >= this.minX && octagonalEnvelope.maxX <= this.maxX && octagonalEnvelope.minY >= this.minY && octagonalEnvelope.maxY <= this.maxY && octagonalEnvelope.minA >= this.minA && octagonalEnvelope.maxA <= this.maxA && octagonalEnvelope.minB >= this.minB && octagonalEnvelope.maxB <= this.maxB;
    }

    public void expandBy(double d) {
        if (this.isNull()) {
            return;
        }
        double d2 = SQRT2 * d;
        this.minX -= d;
        this.maxX += d;
        this.minY -= d;
        this.maxY += d;
        this.minA -= d2;
        this.maxA += d2;
        this.minB -= d2;
        this.maxB += d2;
        if (!this.isValid()) {
            this.setToNull();
        }
    }

    public OctagonalEnvelope expandToInclude(double d, double d2) {
        double d3 = OctagonalEnvelope.computeA(d, d2);
        double d4 = OctagonalEnvelope.computeB(d, d2);
        if (this.isNull()) {
            this.minX = d;
            this.maxX = d;
            this.minY = d2;
            this.maxY = d2;
            this.minA = d3;
            this.maxA = d3;
            this.minB = d4;
            this.maxB = d4;
        } else {
            if (d < this.minX) {
                this.minX = d;
            }
            if (d > this.maxX) {
                this.maxX = d;
            }
            if (d2 < this.minY) {
                this.minY = d2;
            }
            if (d2 > this.maxY) {
                this.maxY = d2;
            }
            if (d3 < this.minA) {
                this.minA = d3;
            }
            if (d3 > this.maxA) {
                this.maxA = d3;
            }
            if (d4 < this.minB) {
                this.minB = d4;
            }
            if (d4 > this.maxB) {
                this.maxB = d4;
            }
        }
        return this;
    }

    public OctagonalEnvelope expandToInclude(Coordinate coordinate) {
        this.expandToInclude(coordinate.x, coordinate.y);
        return this;
    }

    public OctagonalEnvelope expandToInclude(CoordinateSequence coordinateSequence) {
        int n = 0;
        while (n < coordinateSequence.size()) {
            this.expandToInclude(coordinateSequence.getX(n), coordinateSequence.getY(n));
            ++n;
        }
        return this;
    }

    public OctagonalEnvelope expandToInclude(Envelope envelope) {
        this.expandToInclude(envelope.getMinX(), envelope.getMinY());
        this.expandToInclude(envelope.getMinX(), envelope.getMaxY());
        this.expandToInclude(envelope.getMaxX(), envelope.getMinY());
        this.expandToInclude(envelope.getMaxX(), envelope.getMaxY());
        return this;
    }

    public OctagonalEnvelope expandToInclude(OctagonalEnvelope octagonalEnvelope) {
        if (octagonalEnvelope.isNull()) {
            return this;
        }
        if (this.isNull()) {
            this.minX = octagonalEnvelope.minX;
            this.maxX = octagonalEnvelope.maxX;
            this.minY = octagonalEnvelope.minY;
            this.maxY = octagonalEnvelope.maxY;
            this.minA = octagonalEnvelope.minA;
            this.maxA = octagonalEnvelope.maxA;
            this.minB = octagonalEnvelope.minB;
            this.maxB = octagonalEnvelope.maxB;
            return this;
        }
        double d = octagonalEnvelope.minX;
        if (d < this.minX) {
            this.minX = d;
        }
        if ((d = octagonalEnvelope.maxX) > this.maxX) {
            this.maxX = d;
        }
        if ((d = octagonalEnvelope.minY) < this.minY) {
            this.minY = d;
        }
        if ((d = octagonalEnvelope.maxY) > this.maxY) {
            this.maxY = d;
        }
        if ((d = octagonalEnvelope.minA) < this.minA) {
            this.minA = d;
        }
        if ((d = octagonalEnvelope.maxA) > this.maxA) {
            this.maxA = d;
        }
        if ((d = octagonalEnvelope.minB) < this.minB) {
            this.minB = d;
        }
        if ((d = octagonalEnvelope.maxB) > this.maxB) {
            this.maxB = d;
        }
        return this;
    }

    public void expandToInclude(Geometry geometry) {
        geometry.apply(new BoundingOctagonComponentFilter());
    }

    public double getMaxA() {
        return this.maxA;
    }

    public double getMaxB() {
        return this.maxB;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinA() {
        return this.minA;
    }

    public double getMinB() {
        return this.minB;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public boolean intersects(Coordinate coordinate) {
        if (this.minX > coordinate.x) {
            return false;
        }
        if (this.maxX < coordinate.x) {
            return false;
        }
        if (this.minY > coordinate.y) {
            return false;
        }
        if (this.maxY < coordinate.y) {
            return false;
        }
        double d = OctagonalEnvelope.computeA(coordinate.x, coordinate.y);
        double d2 = OctagonalEnvelope.computeB(coordinate.x, coordinate.y);
        if (this.minA > d) {
            return false;
        }
        if (this.maxA < d) {
            return false;
        }
        if (this.minB > d2) {
            return false;
        }
        return !(this.maxB < d2);
    }

    public boolean intersects(OctagonalEnvelope octagonalEnvelope) {
        if (!this.isNull() && !octagonalEnvelope.isNull()) {
            if (this.minX > octagonalEnvelope.maxX) {
                return false;
            }
            if (this.maxX < octagonalEnvelope.minX) {
                return false;
            }
            if (this.minY > octagonalEnvelope.maxY) {
                return false;
            }
            if (this.maxY < octagonalEnvelope.minY) {
                return false;
            }
            if (this.minA > octagonalEnvelope.maxA) {
                return false;
            }
            if (this.maxA < octagonalEnvelope.minA) {
                return false;
            }
            if (this.minB > octagonalEnvelope.maxB) {
                return false;
            }
            return !(this.maxB < octagonalEnvelope.minB);
        }
        return false;
    }

    public boolean isNull() {
        return Double.isNaN(this.minX);
    }

    public void setToNull() {
        this.minX = Double.NaN;
    }

    public Geometry toGeometry(GeometryFactory geometryFactory) {
        if (this.isNull()) {
            return geometryFactory.createPoint((CoordinateSequence)null);
        }
        double d = this.minX;
        Coordinate coordinate = new Coordinate(d, this.minA - d);
        d = this.minX;
        Coordinate coordinate2 = new Coordinate(d, d - this.minB);
        d = this.maxX;
        Coordinate coordinate3 = new Coordinate(d, d - this.maxB);
        d = this.maxX;
        Coordinate coordinate4 = new Coordinate(d, this.maxA - d);
        d = this.minA;
        double d2 = this.minY;
        Coordinate coordinate5 = new Coordinate(d - d2, d2);
        d = this.minY;
        Coordinate coordinate6 = new Coordinate(this.maxB + d, d);
        d = this.maxY;
        Coordinate coordinate7 = new Coordinate(this.minB + d, d);
        d2 = this.maxA;
        d = this.maxY;
        Coordinate coordinate8 = new Coordinate(d2 - d, d);
        Serializable serializable = geometryFactory.getPrecisionModel();
        ((PrecisionModel)serializable).makePrecise(coordinate);
        ((PrecisionModel)serializable).makePrecise(coordinate2);
        ((PrecisionModel)serializable).makePrecise(coordinate3);
        ((PrecisionModel)serializable).makePrecise(coordinate4);
        ((PrecisionModel)serializable).makePrecise(coordinate5);
        ((PrecisionModel)serializable).makePrecise(coordinate6);
        ((PrecisionModel)serializable).makePrecise(coordinate7);
        ((PrecisionModel)serializable).makePrecise(coordinate8);
        serializable = new CoordinateList();
        ((CoordinateList)serializable).add(coordinate, false);
        ((CoordinateList)serializable).add(coordinate2, false);
        ((CoordinateList)serializable).add(coordinate7, false);
        ((CoordinateList)serializable).add(coordinate8, false);
        ((CoordinateList)serializable).add(coordinate4, false);
        ((CoordinateList)serializable).add(coordinate3, false);
        ((CoordinateList)serializable).add(coordinate6, false);
        ((CoordinateList)serializable).add(coordinate5, false);
        if (((ArrayList)serializable).size() == 1) {
            return geometryFactory.createPoint(coordinate);
        }
        if (((ArrayList)serializable).size() == 2) {
            return geometryFactory.createLineString(((CoordinateList)serializable).toCoordinateArray());
        }
        ((CoordinateList)serializable).add(coordinate, false);
        return geometryFactory.createPolygon(geometryFactory.createLinearRing(((CoordinateList)serializable).toCoordinateArray()), null);
    }

    private class BoundingOctagonComponentFilter
    implements GeometryComponentFilter {
        private BoundingOctagonComponentFilter() {
        }

        @Override
        public void filter(Geometry geometry) {
            if (geometry instanceof LineString) {
                OctagonalEnvelope.this.expandToInclude(((LineString)geometry).getCoordinateSequence());
            } else if (geometry instanceof Point) {
                OctagonalEnvelope.this.expandToInclude(((Point)geometry).getCoordinateSequence());
            }
        }
    }
}

