/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.Arrays;

public class Polygon
extends Geometry
implements Polygonal {
    private static final long serialVersionUID = -3494792200821764533L;
    protected LinearRing[] holes;
    protected LinearRing shell;

    public Polygon(LinearRing linearRing, PrecisionModel serializable, int n) {
        serializable = new GeometryFactory((PrecisionModel)serializable, n);
        this(linearRing, new LinearRing[0], (GeometryFactory)serializable);
    }

    public Polygon(LinearRing objectArray, LinearRing[] linearRingArray, GeometryFactory object) {
        super((GeometryFactory)object);
        this.shell = null;
        object = objectArray;
        if (objectArray == null) {
            object = this.getFactory().createLinearRing((CoordinateSequence)null);
        }
        objectArray = linearRingArray;
        if (linearRingArray == null) {
            objectArray = new LinearRing[]{};
        }
        if (!Polygon.hasNullElements(objectArray)) {
            if (((LineString)object).isEmpty() && Polygon.hasNonEmptyElements((Geometry[])objectArray)) {
                throw new IllegalArgumentException("shell is empty but holes are not");
            }
            this.shell = object;
            this.holes = objectArray;
            return;
        }
        throw new IllegalArgumentException("holes must not contain null elements");
    }

    public Polygon(LinearRing linearRing, LinearRing[] linearRingArray, PrecisionModel precisionModel, int n) {
        this(linearRing, linearRingArray, new GeometryFactory(precisionModel, n));
    }

    private void normalize(LinearRing linearRing, boolean bl) {
        if (linearRing.isEmpty()) {
            return;
        }
        int n = linearRing.getCoordinates().length - 1;
        Coordinate[] coordinateArray = new Coordinate[n];
        System.arraycopy(linearRing.getCoordinates(), 0, coordinateArray, 0, n);
        CoordinateArrays.scroll(coordinateArray, CoordinateArrays.minCoordinate(linearRing.getCoordinates()));
        System.arraycopy(coordinateArray, 0, linearRing.getCoordinates(), 0, n);
        linearRing.getCoordinates()[n] = coordinateArray[0];
        if (CGAlgorithms.isCCW(linearRing.getCoordinates()) == bl) {
            CoordinateArrays.reverse(linearRing.getCoordinates());
        }
    }

    @Override
    public void apply(CoordinateFilter coordinateFilter) {
        this.shell.apply(coordinateFilter);
        int n = 0;
        LinearRing[] linearRingArray;
        while (n < (linearRingArray = this.holes).length) {
            linearRingArray[n].apply(coordinateFilter);
            ++n;
        }
        return;
    }

    @Override
    public void apply(CoordinateSequenceFilter coordinateSequenceFilter) {
        this.shell.apply(coordinateSequenceFilter);
        if (!coordinateSequenceFilter.isDone()) {
            LinearRing[] linearRingArray;
            for (int i = 0; i < (linearRingArray = this.holes).length; ++i) {
                linearRingArray[i].apply(coordinateSequenceFilter);
                if (coordinateSequenceFilter.isDone()) break;
            }
        }
        if (coordinateSequenceFilter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
        this.shell.apply(geometryComponentFilter);
        int n = 0;
        LinearRing[] linearRingArray;
        while (n < (linearRingArray = this.holes).length) {
            linearRingArray[n].apply(geometryComponentFilter);
            ++n;
        }
        return;
    }

    @Override
    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    @Override
    public Object clone() {
        Polygon polygon = (Polygon)super.clone();
        polygon.shell = (LinearRing)this.shell.clone();
        polygon.holes = new LinearRing[this.holes.length];
        int n = 0;
        LinearRing[] linearRingArray;
        while (n < (linearRingArray = this.holes).length) {
            polygon.holes[n] = (LinearRing)linearRingArray[n].clone();
            ++n;
        }
        return polygon;
    }

    @Override
    protected int compareToSameClass(Object object) {
        return this.shell.compareToSameClass(((Polygon)object).shell);
    }

    @Override
    protected int compareToSameClass(Object object, CoordinateSequenceComparator coordinateSequenceComparator) {
        object = (Polygon)object;
        int n = this.shell.compareToSameClass(((Polygon)object).shell, coordinateSequenceComparator);
        if (n != 0) {
            return n;
        }
        int n2 = this.getNumInteriorRing();
        int n3 = ((Polygon)object).getNumInteriorRing();
        for (n = 0; n < n2 && n < n3; ++n) {
            int n4 = ((LinearRing)this.getInteriorRingN(n)).compareToSameClass((LinearRing)((Polygon)object).getInteriorRingN(n), coordinateSequenceComparator);
            if (n4 == 0) continue;
            return n4;
        }
        if (n < n2) {
            return 1;
        }
        if (n < n3) {
            return -1;
        }
        return 0;
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        return this.shell.getEnvelopeInternal();
    }

    @Override
    public Geometry convexHull() {
        return this.getExteriorRing().convexHull();
    }

    @Override
    public boolean equalsExact(Geometry linearRingArray, double d) {
        if (!this.isEquivalentClass((Geometry)linearRingArray)) {
            return false;
        }
        Polygon polygon = (Polygon)linearRingArray;
        if (!((Geometry)this.shell).equalsExact(polygon.shell, d)) {
            return false;
        }
        if (this.holes.length != polygon.holes.length) {
            return false;
        }
        int n = 0;
        while (n < (linearRingArray = this.holes).length) {
            if (!((Geometry)linearRingArray[n]).equalsExact(polygon.holes[n], d)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public double getArea() {
        double d = Math.abs(CGAlgorithms.signedArea(this.shell.getCoordinateSequence())) + 0.0;
        int n = 0;
        LinearRing[] linearRingArray;
        while (n < (linearRingArray = this.holes).length) {
            d -= Math.abs(CGAlgorithms.signedArea(linearRingArray[n].getCoordinateSequence()));
            ++n;
        }
        return d;
    }

    @Override
    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString(null);
        }
        int n = this.holes.length + 1;
        LineString[] lineStringArray = new LinearRing[n];
        lineStringArray[0] = this.shell;
        int n2 = 0;
        while (true) {
            LinearRing[] linearRingArray;
            if (n2 >= (linearRingArray = this.holes).length) {
                if (n <= 1) {
                    return this.getFactory().createLinearRing(lineStringArray[0].getCoordinateSequence());
                }
                return this.getFactory().createMultiLineString(lineStringArray);
            }
            int n3 = n2 + 1;
            lineStringArray[n3] = linearRingArray[n2];
            n2 = n3;
        }
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.shell.getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        if (this.isEmpty()) {
            return new Coordinate[0];
        }
        Coordinate[] coordinateArray = new Coordinate[this.getNumPoints()];
        int n = -1;
        Comparable[] comparableArray = this.shell.getCoordinates();
        int n2 = 0;
        while (true) {
            if (n2 >= comparableArray.length) {
                n2 = 0;
                block1: while (true) {
                    if (n2 >= (comparableArray = this.holes).length) {
                        return coordinateArray;
                    }
                    comparableArray = ((LineString)comparableArray[n2]).getCoordinates();
                    int n3 = 0;
                    while (true) {
                        if (n3 >= comparableArray.length) {
                            ++n2;
                            continue block1;
                        }
                        coordinateArray[++n] = comparableArray[n3];
                        ++n3;
                    }
                    break;
                }
            }
            coordinateArray[++n] = comparableArray[n2];
            ++n2;
        }
    }

    @Override
    public int getDimension() {
        return 2;
    }

    public LineString getExteriorRing() {
        return this.shell;
    }

    @Override
    public String getGeometryType() {
        return "Polygon";
    }

    public LineString getInteriorRingN(int n) {
        return this.holes[n];
    }

    @Override
    public double getLength() {
        double d = this.shell.getLength() + 0.0;
        int n = 0;
        LinearRing[] linearRingArray;
        while (n < (linearRingArray = this.holes).length) {
            d += linearRingArray[n].getLength();
            ++n;
        }
        return d;
    }

    public int getNumInteriorRing() {
        return this.holes.length;
    }

    @Override
    public int getNumPoints() {
        int n = this.shell.getNumPoints();
        int n2 = 0;
        LinearRing[] linearRingArray;
        while (n2 < (linearRingArray = this.holes).length) {
            n += linearRingArray[n2].getNumPoints();
            ++n2;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.shell.isEmpty();
    }

    @Override
    public boolean isRectangle() {
        if (this.getNumInteriorRing() != 0) {
            return false;
        }
        Comparable comparable = this.shell;
        if (comparable == null) {
            return false;
        }
        if (((LineString)comparable).getNumPoints() != 5) {
            return false;
        }
        CoordinateSequence coordinateSequence = this.shell.getCoordinateSequence();
        comparable = this.getEnvelopeInternal();
        int n = 0;
        while (true) {
            double d;
            if (n >= 5) {
                d = coordinateSequence.getX(0);
                double d2 = coordinateSequence.getY(0);
                n = 1;
                while (true) {
                    double d3;
                    boolean bl;
                    if (n > 4) {
                        return true;
                    }
                    double d4 = coordinateSequence.getX(n);
                    boolean bl2 = d4 != d;
                    if (bl2 == (bl = (d3 = coordinateSequence.getY(n)) != d2)) {
                        return false;
                    }
                    ++n;
                    d = d4;
                    d2 = d3;
                }
            }
            d = coordinateSequence.getX(n);
            if (d != ((Envelope)comparable).getMinX() && d != ((Envelope)comparable).getMaxX()) {
                return false;
            }
            d = coordinateSequence.getY(n);
            if (d != ((Envelope)comparable).getMinY() && d != ((Envelope)comparable).getMaxY()) {
                return false;
            }
            ++n;
        }
    }

    @Override
    public void normalize() {
        this.normalize(this.shell, true);
        int n = 0;
        while (true) {
            Object[] objectArray;
            if (n >= (objectArray = this.holes).length) {
                Arrays.sort(objectArray);
                return;
            }
            this.normalize((LinearRing)objectArray[n], false);
            ++n;
        }
    }

    @Override
    public Geometry reverse() {
        Polygon polygon = (Polygon)super.clone();
        polygon.shell = (LinearRing)((LinearRing)this.shell.clone()).reverse();
        polygon.holes = new LinearRing[this.holes.length];
        int n = 0;
        LinearRing[] linearRingArray;
        while (n < (linearRingArray = this.holes).length) {
            polygon.holes[n] = (LinearRing)((LinearRing)linearRingArray[n].clone()).reverse();
            ++n;
        }
        return polygon;
    }
}

