/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.prep.PreparedPolygon;
import com.vividsolutions.jts.geom.prep.PreparedPolygonPredicate;
import com.vividsolutions.jts.noding.SegmentIntersectionDetector;
import com.vividsolutions.jts.noding.SegmentStringUtil;
import java.util.Collection;

abstract class AbstractPreparedPolygonContains
extends PreparedPolygonPredicate {
    private boolean hasNonProperIntersection = false;
    private boolean hasProperIntersection = false;
    private boolean hasSegmentIntersection = false;
    protected boolean requireSomePointInInterior = true;

    public AbstractPreparedPolygonContains(PreparedPolygon preparedPolygon) {
        super(preparedPolygon);
    }

    private void findAndClassifyIntersections(Geometry object) {
        object = SegmentStringUtil.extractSegmentStrings((Geometry)object);
        SegmentIntersectionDetector segmentIntersectionDetector = new SegmentIntersectionDetector();
        segmentIntersectionDetector.setFindAllIntersectionTypes(true);
        this.prepPoly.getIntersectionFinder().intersects((Collection)object, segmentIntersectionDetector);
        this.hasSegmentIntersection = segmentIntersectionDetector.hasIntersection();
        this.hasProperIntersection = segmentIntersectionDetector.hasProperIntersection();
        this.hasNonProperIntersection = segmentIntersectionDetector.hasNonProperIntersection();
    }

    private boolean isProperIntersectionImpliesNotContainedSituation(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            return true;
        }
        return this.isSingleShell(this.prepPoly.getGeometry());
    }

    private boolean isSingleShell(Geometry geometry) {
        if (geometry.getNumGeometries() != 1) {
            return false;
        }
        return ((Polygon)geometry.getGeometryN(0)).getNumInteriorRing() == 0;
    }

    protected boolean eval(Geometry geometry) {
        if (!this.isAllTestComponentsInTarget(geometry)) {
            return false;
        }
        if (this.requireSomePointInInterior && geometry.getDimension() == 0) {
            return this.isAnyTestComponentInTargetInterior(geometry);
        }
        boolean bl = this.isProperIntersectionImpliesNotContainedSituation(geometry);
        this.findAndClassifyIntersections(geometry);
        if (bl && this.hasProperIntersection) {
            return false;
        }
        bl = this.hasSegmentIntersection;
        if (bl && !this.hasNonProperIntersection) {
            return false;
        }
        if (bl) {
            return this.fullTopologicalPredicate(geometry);
        }
        return !(geometry instanceof Polygonal) || !this.isAnyTargetComponentInAreaTest(geometry, this.prepPoly.getRepresentativePoints());
    }

    protected abstract boolean fullTopologicalPredicate(Geometry var1);
}

