/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.util.ComponentCoordinateExtracter;
import java.util.Iterator;
import java.util.List;

class BasicPreparedGeometry
implements PreparedGeometry {
    private final Geometry baseGeom;
    private final List representativePts;

    public BasicPreparedGeometry(Geometry geometry) {
        this.baseGeom = geometry;
        this.representativePts = ComponentCoordinateExtracter.getCoordinates(geometry);
    }

    @Override
    public boolean contains(Geometry geometry) {
        return this.baseGeom.contains(geometry);
    }

    @Override
    public boolean containsProperly(Geometry geometry) {
        if (!this.baseGeom.getEnvelopeInternal().contains(geometry.getEnvelopeInternal())) {
            return false;
        }
        return this.baseGeom.relate(geometry, "T**FF*FF*");
    }

    @Override
    public boolean coveredBy(Geometry geometry) {
        return this.baseGeom.coveredBy(geometry);
    }

    @Override
    public boolean covers(Geometry geometry) {
        return this.baseGeom.covers(geometry);
    }

    @Override
    public boolean crosses(Geometry geometry) {
        return this.baseGeom.crosses(geometry);
    }

    @Override
    public boolean disjoint(Geometry geometry) {
        return this.intersects(geometry) ^ true;
    }

    protected boolean envelopeCovers(Geometry geometry) {
        return this.baseGeom.getEnvelopeInternal().covers(geometry.getEnvelopeInternal());
    }

    protected boolean envelopesIntersect(Geometry geometry) {
        return this.baseGeom.getEnvelopeInternal().intersects(geometry.getEnvelopeInternal());
    }

    @Override
    public Geometry getGeometry() {
        return this.baseGeom;
    }

    public List getRepresentativePoints() {
        return this.representativePts;
    }

    @Override
    public boolean intersects(Geometry geometry) {
        return this.baseGeom.intersects(geometry);
    }

    public boolean isAnyTargetComponentInTest(Geometry geometry) {
        PointLocator pointLocator = new PointLocator();
        Iterator iterator2 = this.representativePts.iterator();
        do {
            if (iterator2.hasNext()) continue;
            return false;
        } while (!pointLocator.intersects((Coordinate)iterator2.next(), geometry));
        return true;
    }

    @Override
    public boolean overlaps(Geometry geometry) {
        return this.baseGeom.overlaps(geometry);
    }

    public String toString() {
        return this.baseGeom.toString();
    }

    @Override
    public boolean touches(Geometry geometry) {
        return this.baseGeom.touches(geometry);
    }

    @Override
    public boolean within(Geometry geometry) {
        return this.baseGeom.within(geometry);
    }
}

