/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedLineString;
import com.vividsolutions.jts.geom.util.ComponentCoordinateExtracter;
import com.vividsolutions.jts.noding.SegmentStringUtil;
import java.util.List;

class PreparedLineStringIntersects {
    protected PreparedLineString prepLine;

    public PreparedLineStringIntersects(PreparedLineString preparedLineString) {
        this.prepLine = preparedLineString;
    }

    public static boolean intersects(PreparedLineString preparedLineString, Geometry geometry) {
        return new PreparedLineStringIntersects(preparedLineString).intersects(geometry);
    }

    public boolean intersects(Geometry geometry) {
        List list = SegmentStringUtil.extractSegmentStrings(geometry);
        if (list.size() > 0 && this.prepLine.getIntersectionFinder().intersects(list)) {
            return true;
        }
        if (geometry.getDimension() == 1) {
            return false;
        }
        if (geometry.getDimension() == 2 && this.prepLine.isAnyTargetComponentInTest(geometry)) {
            return true;
        }
        if (geometry.getDimension() == 0) {
            return this.isAnyTestPointInTarget(geometry);
        }
        return false;
    }

    protected boolean isAnyTestPointInTarget(Geometry object) {
        PointLocator pointLocator = new PointLocator();
        object = ComponentCoordinateExtracter.getCoordinates((Geometry)object).iterator();
        do {
            if (object.hasNext()) continue;
            return false;
        } while (!pointLocator.intersects((Coordinate)object.next(), this.prepLine.getGeometry()));
        return true;
    }
}

