/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.geom.util.AffineTransformationBuilder;

public class AffineTransformationFactory {
    public static AffineTransformation createFromBaseLines(Coordinate cloneable, Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = Angle.angleBetweenOriented(coordinate, (Coordinate)cloneable, new Coordinate(((Coordinate)cloneable).x + coordinate3.x - coordinate2.x, ((Coordinate)cloneable).y + coordinate3.y - coordinate2.y));
        double d2 = coordinate.distance((Coordinate)cloneable);
        double d3 = coordinate3.distance(coordinate2);
        if (d2 == 0.0) {
            return new AffineTransformation();
        }
        d2 = d3 / d2;
        cloneable = AffineTransformation.translationInstance(-((Coordinate)cloneable).x, -((Coordinate)cloneable).y);
        ((AffineTransformation)cloneable).rotate(d);
        ((AffineTransformation)cloneable).scale(d2, d2);
        ((AffineTransformation)cloneable).translate(coordinate2.x, coordinate2.y);
        return cloneable;
    }

    public static AffineTransformation createFromControlVectors(Coordinate coordinate, Coordinate coordinate2) {
        return AffineTransformation.translationInstance(coordinate2.x - coordinate.x, coordinate2.y - coordinate.y);
    }

    public static AffineTransformation createFromControlVectors(Coordinate cloneable, Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = Angle.angleBetweenOriented(coordinate, (Coordinate)cloneable, new Coordinate(coordinate3.x - coordinate2.x, coordinate3.y - coordinate2.y));
        double d2 = coordinate.distance((Coordinate)cloneable);
        double d3 = coordinate3.distance(coordinate2);
        if (d2 == 0.0) {
            return null;
        }
        d2 = d3 / d2;
        cloneable = AffineTransformation.translationInstance(-((Coordinate)cloneable).x, -((Coordinate)cloneable).y);
        ((AffineTransformation)cloneable).rotate(d);
        ((AffineTransformation)cloneable).scale(d2, d2);
        ((AffineTransformation)cloneable).translate(coordinate2.x, coordinate2.y);
        return cloneable;
    }

    public static AffineTransformation createFromControlVectors(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4, Coordinate coordinate5, Coordinate coordinate6) {
        return new AffineTransformationBuilder(coordinate, coordinate2, coordinate3, coordinate4, coordinate5, coordinate6).getTransformation();
    }

    public static AffineTransformation createFromControlVectors(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        if (coordinateArray.length == coordinateArray2.length) {
            if (coordinateArray.length > 0) {
                if (coordinateArray.length <= 3) {
                    if (coordinateArray.length == 1) {
                        return AffineTransformationFactory.createFromControlVectors(coordinateArray[0], coordinateArray2[0]);
                    }
                    if (coordinateArray.length == 2) {
                        return AffineTransformationFactory.createFromControlVectors(coordinateArray[0], coordinateArray[1], coordinateArray2[0], coordinateArray2[1]);
                    }
                    return AffineTransformationFactory.createFromControlVectors(coordinateArray[0], coordinateArray[1], coordinateArray[2], coordinateArray2[0], coordinateArray2[1], coordinateArray2[2]);
                }
                throw new IllegalArgumentException("Too many control points");
            }
            throw new IllegalArgumentException("Too few control points");
        }
        throw new IllegalArgumentException("Src and Dest arrays are not the same length");
    }
}

