/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;

public class GeometryEditor {
    private GeometryFactory factory = null;
    private boolean isUserDataCopied = false;

    public GeometryEditor() {
    }

    public GeometryEditor(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    private GeometryCollection editGeometryCollection(GeometryCollection cloneable, GeometryEditorOperation geometryEditorOperation) {
        GeometryCollection geometryCollection = (GeometryCollection)geometryEditorOperation.edit((Geometry)cloneable, this.factory);
        cloneable = new ArrayList();
        int n = 0;
        while (true) {
            if (n >= geometryCollection.getNumGeometries()) {
                if (geometryCollection.getClass() == MultiPoint.class) {
                    return this.factory.createMultiPoint(((ArrayList)cloneable).toArray(new Point[0]));
                }
                if (geometryCollection.getClass() == MultiLineString.class) {
                    return this.factory.createMultiLineString(((ArrayList)cloneable).toArray(new LineString[0]));
                }
                if (geometryCollection.getClass() == MultiPolygon.class) {
                    return this.factory.createMultiPolygon(((ArrayList)cloneable).toArray(new Polygon[0]));
                }
                return this.factory.createGeometryCollection(((ArrayList)cloneable).toArray(new Geometry[0]));
            }
            Geometry geometry = this.edit(geometryCollection.getGeometryN(n), geometryEditorOperation);
            if (geometry != null && !geometry.isEmpty()) {
                ((ArrayList)cloneable).add(geometry);
            }
            ++n;
        }
    }

    private Geometry editInternal(Geometry geometry, GeometryEditorOperation object) {
        if (this.factory == null) {
            this.factory = geometry.getFactory();
        }
        if (geometry instanceof GeometryCollection) {
            return this.editGeometryCollection((GeometryCollection)geometry, (GeometryEditorOperation)object);
        }
        if (geometry instanceof Polygon) {
            return this.editPolygon((Polygon)geometry, (GeometryEditorOperation)object);
        }
        if (geometry instanceof Point) {
            return object.edit(geometry, this.factory);
        }
        if (geometry instanceof LineString) {
            return object.edit(geometry, this.factory);
        }
        object = new StringBuilder("Unsupported Geometry class: ");
        ((StringBuilder)object).append(geometry.getClass().getName());
        Assert.shouldNeverReachHere(((StringBuilder)object).toString());
        return null;
    }

    private Polygon editPolygon(Polygon polygon, GeometryEditorOperation geometryEditorOperation) {
        Geometry geometry = (Polygon)geometryEditorOperation.edit(polygon, this.factory);
        polygon = geometry;
        if (geometry == null) {
            polygon = this.factory.createPolygon((CoordinateSequence)null);
        }
        if (polygon.isEmpty()) {
            return polygon;
        }
        LinearRing linearRing = (LinearRing)this.edit(polygon.getExteriorRing(), geometryEditorOperation);
        if (linearRing != null && !linearRing.isEmpty()) {
            ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
            int n = 0;
            while (true) {
                if (n >= polygon.getNumInteriorRing()) {
                    return this.factory.createPolygon(linearRing, arrayList.toArray(new LinearRing[0]));
                }
                geometry = (LinearRing)this.edit(polygon.getInteriorRingN(n), geometryEditorOperation);
                if (geometry != null && !((LineString)geometry).isEmpty()) {
                    arrayList.add(geometry);
                }
                ++n;
            }
        }
        return this.factory.createPolygon(null, null);
    }

    public Geometry edit(Geometry geometry, GeometryEditorOperation object) {
        if (geometry == null) {
            return null;
        }
        object = this.editInternal(geometry, (GeometryEditorOperation)object);
        if (this.isUserDataCopied) {
            ((Geometry)object).setUserData(geometry.getUserData());
        }
        return object;
    }

    public void setCopyUserData(boolean bl) {
        this.isUserDataCopied = bl;
    }

    public static abstract class CoordinateOperation
    implements GeometryEditorOperation {
        @Override
        public final Geometry edit(Geometry object, GeometryFactory geometryFactory) {
            if (object instanceof LinearRing) {
                return geometryFactory.createLinearRing(this.edit(object.getCoordinates(), (Geometry)object));
            }
            if (object instanceof LineString) {
                return geometryFactory.createLineString(this.edit(object.getCoordinates(), (Geometry)object));
            }
            Object object2 = object;
            if (object instanceof Point) {
                object = ((Coordinate[])(object = this.edit(object.getCoordinates(), (Geometry)object))).length > 0 ? object[0] : null;
                object2 = geometryFactory.createPoint((Coordinate)object);
            }
            return object2;
        }

        public abstract Coordinate[] edit(Coordinate[] var1, Geometry var2);
    }

    public static abstract class CoordinateSequenceOperation
    implements GeometryEditorOperation {
        public abstract CoordinateSequence edit(CoordinateSequence var1, Geometry var2);

        @Override
        public final Geometry edit(Geometry geometry, GeometryFactory geometryFactory) {
            if (geometry instanceof LinearRing) {
                return geometryFactory.createLinearRing(this.edit(((LinearRing)geometry).getCoordinateSequence(), geometry));
            }
            if (geometry instanceof LineString) {
                return geometryFactory.createLineString(this.edit(((LineString)geometry).getCoordinateSequence(), geometry));
            }
            Geometry geometry2 = geometry;
            if (geometry instanceof Point) {
                geometry2 = geometryFactory.createPoint(this.edit(((Point)geometry).getCoordinateSequence(), geometry));
            }
            return geometry2;
        }
    }

    public static interface GeometryEditorOperation {
        public Geometry edit(Geometry var1, GeometryFactory var2);
    }

    public static class NoOpGeometryOperation
    implements GeometryEditorOperation {
        @Override
        public Geometry edit(Geometry geometry, GeometryFactory geometryFactory) {
            return geometry;
        }
    }
}

