/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Position;
import java.io.PrintStream;

public class DirectedEdge
extends EdgeEnd {
    private int[] depth;
    private EdgeRing edgeRing;
    protected boolean isForward;
    private boolean isInResult = false;
    private boolean isVisited = false;
    private EdgeRing minEdgeRing;
    private DirectedEdge next;
    private DirectedEdge nextMin;
    private DirectedEdge sym;

    public DirectedEdge(Edge edge, boolean bl) {
        super(edge);
        int[] nArray = new int[3];
        nArray[1] = -999;
        nArray[2] = -999;
        this.depth = nArray;
        this.isForward = bl;
        if (bl) {
            this.init(edge.getCoordinate(0), edge.getCoordinate(1));
        } else {
            int n = edge.getNumPoints() - 1;
            this.init(edge.getCoordinate(n), edge.getCoordinate(n - 1));
        }
        this.computeDirectedLabel();
    }

    private void computeDirectedLabel() {
        this.label = new Label(this.edge.getLabel());
        if (!this.isForward) {
            this.label.flip();
        }
    }

    public static int depthFactor(int n, int n2) {
        if (n == 2 && n2 == 0) {
            return 1;
        }
        if (n == 0 && n2 == 2) {
            return -1;
        }
        return 0;
    }

    public int getDepth(int n) {
        return this.depth[n];
    }

    public int getDepthDelta() {
        int n;
        int n2 = n = this.edge.getDepthDelta();
        if (!this.isForward) {
            n2 = -n;
        }
        return n2;
    }

    @Override
    public Edge getEdge() {
        return this.edge;
    }

    public EdgeRing getEdgeRing() {
        return this.edgeRing;
    }

    public EdgeRing getMinEdgeRing() {
        return this.minEdgeRing;
    }

    public DirectedEdge getNext() {
        return this.next;
    }

    public DirectedEdge getNextMin() {
        return this.nextMin;
    }

    public DirectedEdge getSym() {
        return this.sym;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public boolean isInResult() {
        return this.isInResult;
    }

    public boolean isInteriorAreaEdge() {
        int n = 0;
        boolean bl = true;
        while (n < 2) {
            if (!this.label.isArea(n) || this.label.getLocation(n, 1) != 0 || this.label.getLocation(n, 2) != 0) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public boolean isLineEdge() {
        boolean bl = this.label.isLine(0) || this.label.isLine(1);
        boolean bl2 = !this.label.isArea(0) || this.label.allPositionsEqual(0, 2);
        boolean bl3 = !this.label.isArea(1) || this.label.allPositionsEqual(1, 2);
        return bl && bl2 && bl3;
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    @Override
    public void print(PrintStream printStream) {
        super.print(printStream);
        StringBuilder stringBuilder = new StringBuilder(" ");
        stringBuilder.append(this.depth[1]);
        stringBuilder.append("/");
        stringBuilder.append(this.depth[2]);
        printStream.print(stringBuilder.toString());
        stringBuilder = new StringBuilder(" (");
        stringBuilder.append(this.getDepthDelta());
        stringBuilder.append(")");
        printStream.print(stringBuilder.toString());
        if (this.isInResult) {
            printStream.print(" inResult");
        }
    }

    public void printEdge(PrintStream printStream) {
        this.print(printStream);
        printStream.print(" ");
        if (this.isForward) {
            this.edge.print(printStream);
        } else {
            this.edge.printReverse(printStream);
        }
    }

    public void setDepth(int n, int n2) {
        int[] nArray = this.depth;
        if (nArray[n] != -999 && nArray[n] != n2) {
            throw new TopologyException("assigned depths do not match", this.getCoordinate());
        }
        nArray[n] = n2;
    }

    public void setEdgeDepths(int n, int n2) {
        int n3;
        int n4 = n3 = this.getEdge().getDepthDelta();
        if (!this.isForward) {
            n4 = -n3;
        }
        n3 = 1;
        if (n == 1) {
            n3 = -1;
        }
        int n5 = Position.opposite(n);
        this.setDepth(n, n2);
        this.setDepth(n5, n4 * n3 + n2);
    }

    public void setEdgeRing(EdgeRing edgeRing) {
        this.edgeRing = edgeRing;
    }

    public void setInResult(boolean bl) {
        this.isInResult = bl;
    }

    public void setMinEdgeRing(EdgeRing edgeRing) {
        this.minEdgeRing = edgeRing;
    }

    public void setNext(DirectedEdge directedEdge) {
        this.next = directedEdge;
    }

    public void setNextMin(DirectedEdge directedEdge) {
        this.nextMin = directedEdge;
    }

    public void setSym(DirectedEdge directedEdge) {
        this.sym = directedEdge;
    }

    public void setVisited(boolean bl) {
        this.isVisited = bl;
    }

    public void setVisitedEdge(boolean bl) {
        this.setVisited(bl);
        this.sym.setVisited(bl);
    }
}

