/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeEndStar;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DirectedEdgeStar
extends EdgeEndStar {
    private final int LINKING_TO_OUTGOING;
    private final int SCANNING_FOR_INCOMING;
    private Label label;
    private List resultAreaEdgeList;

    public DirectedEdgeStar() {
        this.SCANNING_FOR_INCOMING = 1;
        this.LINKING_TO_OUTGOING = 2;
    }

    private int computeDepths(int n, int n2, int n3) {
        while (n < n2) {
            DirectedEdge directedEdge = (DirectedEdge)this.edgeList.get(n);
            directedEdge.getLabel();
            directedEdge.setEdgeDepths(2, n3);
            n3 = directedEdge.getDepth(1);
            ++n;
        }
        return n3;
    }

    private List getResultAreaEdges() {
        Object object = this.resultAreaEdgeList;
        if (object != null) {
            return object;
        }
        this.resultAreaEdgeList = new ArrayList();
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            object = (DirectedEdge)iterator2.next();
            if (!((DirectedEdge)object).isInResult() && !((DirectedEdge)object).getSym().isInResult()) continue;
            this.resultAreaEdgeList.add(object);
        }
        return this.resultAreaEdgeList;
    }

    public void computeDepths(DirectedEdge directedEdge) {
        int n = this.findIndex(directedEdge);
        directedEdge.getLabel();
        int n2 = directedEdge.getDepth(1);
        int n3 = directedEdge.getDepth(2);
        if (this.computeDepths(0, n, this.computeDepths(n + 1, this.edgeList.size(), n2)) == n3) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("depth mismatch at ");
        stringBuilder.append(directedEdge.getCoordinate());
        throw new TopologyException(stringBuilder.toString());
    }

    @Override
    public void computeLabelling(GeometryGraph[] object) {
        super.computeLabelling((GeometryGraph[])object);
        this.label = new Label(-1);
        object = this.iterator();
        block0: while (object.hasNext()) {
            Label label = ((EdgeEnd)object.next()).getEdge().getLabel();
            int n = 0;
            while (true) {
                if (n >= 2) continue block0;
                int n2 = label.getLocation(n);
                if (n2 == 0 || n2 == 1) {
                    this.label.setLocation(n, 0);
                }
                ++n;
            }
            break;
        }
        return;
    }

    public void findCoveredLineEdges() {
        DirectedEdge directedEdge;
        Object object;
        int n;
        Iterator iterator2;
        block8: {
            iterator2 = this.iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    n = -1;
                    break block8;
                }
                object = (DirectedEdge)iterator2.next();
                directedEdge = ((DirectedEdge)object).getSym();
                if (((DirectedEdge)object).isLineEdge()) continue;
                if (((DirectedEdge)object).isInResult()) {
                    n = 0;
                    break block8;
                }
                if (directedEdge.isInResult()) break;
            }
            n = 2;
        }
        if (n == -1) {
            return;
        }
        iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            object = (DirectedEdge)iterator2.next();
            directedEdge = ((DirectedEdge)object).getSym();
            if (((DirectedEdge)object).isLineEdge()) {
                object = ((DirectedEdge)object).getEdge();
                boolean bl = n == 0;
                ((GraphComponent)object).setCovered(bl);
                continue;
            }
            if (((DirectedEdge)object).isInResult()) {
                n = 2;
            }
            if (!directedEdge.isInResult()) continue;
            n = 0;
        }
        return;
    }

    public Label getLabel() {
        return this.label;
    }

    public int getOutgoingDegree() {
        Iterator iterator2 = this.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            if (!((DirectedEdge)iterator2.next()).isInResult()) continue;
            ++n;
        }
        return n;
    }

    public int getOutgoingDegree(EdgeRing edgeRing) {
        Iterator iterator2 = this.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            if (((DirectedEdge)iterator2.next()).getEdgeRing() != edgeRing) continue;
            ++n;
        }
        return n;
    }

    public DirectedEdge getRightmostEdge() {
        Object object = this.getEdges();
        int n = object.size();
        if (n < 1) {
            return null;
        }
        DirectedEdge directedEdge = (DirectedEdge)object.get(0);
        if (n == 1) {
            return directedEdge;
        }
        object = (DirectedEdge)object.get(n - 1);
        int n2 = directedEdge.getQuadrant();
        n = ((EdgeEnd)object).getQuadrant();
        if (Quadrant.isNorthern(n2) && Quadrant.isNorthern(n)) {
            return directedEdge;
        }
        if (!Quadrant.isNorthern(n2) && !Quadrant.isNorthern(n)) {
            return object;
        }
        if (directedEdge.getDy() != 0.0) {
            return directedEdge;
        }
        if (((EdgeEnd)object).getDy() != 0.0) {
            return object;
        }
        Assert.shouldNeverReachHere("found two horizontal edges incident on node");
        return null;
    }

    @Override
    public void insert(EdgeEnd edgeEnd) {
        edgeEnd = (DirectedEdge)edgeEnd;
        this.insertEdgeEnd(edgeEnd, edgeEnd);
    }

    public void linkAllDirectedEdges() {
        this.getEdges();
        int n = this.edgeList.size() - 1;
        DirectedEdge directedEdge = null;
        DirectedEdge directedEdge2 = null;
        while (true) {
            if (n < 0) {
                directedEdge.setNext(directedEdge2);
                return;
            }
            DirectedEdge directedEdge3 = (DirectedEdge)this.edgeList.get(n);
            DirectedEdge directedEdge4 = directedEdge3.getSym();
            DirectedEdge directedEdge5 = directedEdge;
            if (directedEdge == null) {
                directedEdge5 = directedEdge4;
            }
            if (directedEdge2 != null) {
                directedEdge4.setNext(directedEdge2);
            }
            --n;
            directedEdge2 = directedEdge3;
            directedEdge = directedEdge5;
        }
    }

    public void linkMinimalDirectedEdges(EdgeRing edgeRing) {
        int n = this.resultAreaEdgeList.size();
        boolean bl = true;
        int n2 = n - 1;
        DirectedEdge directedEdge = null;
        DirectedEdge directedEdge2 = null;
        n = 1;
        while (true) {
            if (n2 < 0) {
                if (n == 2) {
                    boolean bl2 = directedEdge != null;
                    Assert.isTrue(bl2, "found null for first outgoing dirEdge");
                    bl2 = directedEdge.getEdgeRing() == edgeRing ? bl : false;
                    Assert.isTrue(bl2, "unable to link last incoming dirEdge");
                    directedEdge2.setNextMin(directedEdge);
                }
                return;
            }
            DirectedEdge directedEdge3 = (DirectedEdge)this.resultAreaEdgeList.get(n2);
            DirectedEdge directedEdge4 = directedEdge3.getSym();
            DirectedEdge directedEdge5 = directedEdge;
            if (directedEdge == null) {
                directedEdge5 = directedEdge;
                if (directedEdge3.getEdgeRing() == edgeRing) {
                    directedEdge5 = directedEdge3;
                }
            }
            if (n != 1) {
                if (n == 2 && directedEdge3.getEdgeRing() == edgeRing) {
                    directedEdge2.setNextMin(directedEdge3);
                    n = 1;
                }
            } else if (directedEdge4.getEdgeRing() == edgeRing) {
                directedEdge2 = directedEdge4;
                n = 2;
            }
            --n2;
            directedEdge = directedEdge5;
        }
    }

    public void linkResultDirectedEdges() {
        this.getResultAreaEdges();
        DirectedEdge directedEdge = null;
        DirectedEdge directedEdge2 = null;
        int n = 0;
        int n2 = 1;
        while (true) {
            DirectedEdge directedEdge3;
            if (n >= this.resultAreaEdgeList.size()) {
                if (n2 == 2) {
                    if (directedEdge != null) {
                        Assert.isTrue(directedEdge.isInResult(), "unable to link last incoming dirEdge");
                        directedEdge2.setNext(directedEdge);
                    } else {
                        throw new TopologyException("no outgoing dirEdge found", this.getCoordinate());
                    }
                }
                return;
            }
            DirectedEdge directedEdge4 = (DirectedEdge)this.resultAreaEdgeList.get(n);
            DirectedEdge directedEdge5 = directedEdge4.getSym();
            if (!directedEdge4.getLabel().isArea()) {
                directedEdge3 = directedEdge;
            } else {
                directedEdge3 = directedEdge;
                if (directedEdge == null) {
                    directedEdge3 = directedEdge;
                    if (directedEdge4.isInResult()) {
                        directedEdge3 = directedEdge4;
                    }
                }
                if (n2 != 1) {
                    if (n2 == 2 && directedEdge4.isInResult()) {
                        directedEdge2.setNext(directedEdge4);
                        n2 = 1;
                    }
                } else if (directedEdge5.isInResult()) {
                    directedEdge2 = directedEdge5;
                    n2 = 2;
                }
            }
            ++n;
            directedEdge = directedEdge3;
        }
    }

    public void mergeSymLabels() {
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator2.next();
            directedEdge.getLabel().merge(directedEdge.getSym().getLabel());
        }
        return;
    }

    @Override
    public void print(PrintStream printStream) {
        Object object = System.out;
        Object object2 = new StringBuilder("DirectedEdgeStar: ");
        ((StringBuilder)object2).append(this.getCoordinate());
        ((PrintStream)object).println(((StringBuilder)object2).toString());
        object2 = this.iterator();
        while (object2.hasNext()) {
            object = (DirectedEdge)object2.next();
            printStream.print("out ");
            ((DirectedEdge)object).print(printStream);
            printStream.println();
            printStream.print("in ");
            ((DirectedEdge)object).getSym().print(printStream);
            printStream.println();
        }
        return;
    }

    public void updateLabelling(Label label) {
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            Label label2 = ((DirectedEdge)iterator2.next()).getLabel();
            label2.setAllLocationsIfNull(0, label.getLocation(0));
            label2.setAllLocationsIfNull(1, label.getLocation(1));
        }
        return;
    }
}

