/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;

public class EdgeEnd
implements Comparable {
    private double dx;
    private double dy;
    protected Edge edge;
    protected Label label;
    private Node node;
    private Coordinate p0;
    private Coordinate p1;
    private int quadrant;

    protected EdgeEnd(Edge edge) {
        this.edge = edge;
    }

    public EdgeEnd(Edge edge, Coordinate coordinate, Coordinate coordinate2) {
        this(edge, coordinate, coordinate2, null);
    }

    public EdgeEnd(Edge edge, Coordinate coordinate, Coordinate coordinate2, Label label) {
        this(edge);
        this.init(coordinate, coordinate2);
        this.label = label;
    }

    public int compareDirection(EdgeEnd edgeEnd) {
        if (this.dx == edgeEnd.dx && this.dy == edgeEnd.dy) {
            return 0;
        }
        int n = this.quadrant;
        int n2 = edgeEnd.quadrant;
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return CGAlgorithms.computeOrientation(edgeEnd.p0, edgeEnd.p1, this.p1);
    }

    public int compareTo(Object object) {
        return this.compareDirection((EdgeEnd)object);
    }

    public void computeLabel(BoundaryNodeRule boundaryNodeRule) {
    }

    public Coordinate getCoordinate() {
        return this.p0;
    }

    public Coordinate getDirectedCoordinate() {
        return this.p1;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Label getLabel() {
        return this.label;
    }

    public Node getNode() {
        return this.node;
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    protected void init(Coordinate coordinate, Coordinate coordinate2) {
        double d;
        this.p0 = coordinate;
        this.p1 = coordinate2;
        this.dx = coordinate2.x - coordinate.x;
        this.dy = d = coordinate2.y - coordinate.y;
        this.quadrant = Quadrant.quadrant(this.dx, d);
        boolean bl = this.dx != 0.0 || this.dy != 0.0;
        Assert.isTrue(bl, "EdgeEnd with identical endpoints found");
    }

    public void print(PrintStream printStream) {
        double d = Math.atan2(this.dy, this.dx);
        CharSequence charSequence = this.getClass().getName();
        String string2 = ((String)charSequence).substring(((String)charSequence).lastIndexOf(46) + 1);
        charSequence = new StringBuilder("  ");
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(": ");
        ((StringBuilder)charSequence).append(this.p0);
        ((StringBuilder)charSequence).append(" - ");
        ((StringBuilder)charSequence).append(this.p1);
        ((StringBuilder)charSequence).append(" ");
        ((StringBuilder)charSequence).append(this.quadrant);
        ((StringBuilder)charSequence).append(":");
        ((StringBuilder)charSequence).append(d);
        ((StringBuilder)charSequence).append("   ");
        ((StringBuilder)charSequence).append(this.label);
        printStream.print(((StringBuilder)charSequence).toString());
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String toString() {
        double d = Math.atan2(this.dy, this.dx);
        CharSequence charSequence = this.getClass().getName();
        String string2 = ((String)charSequence).substring(((String)charSequence).lastIndexOf(46) + 1);
        charSequence = new StringBuilder("  ");
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(": ");
        ((StringBuilder)charSequence).append(this.p0);
        ((StringBuilder)charSequence).append(" - ");
        ((StringBuilder)charSequence).append(this.p1);
        ((StringBuilder)charSequence).append(" ");
        ((StringBuilder)charSequence).append(this.quadrant);
        ((StringBuilder)charSequence).append(":");
        ((StringBuilder)charSequence).append(d);
        ((StringBuilder)charSequence).append("   ");
        ((StringBuilder)charSequence).append(this.label);
        return ((StringBuilder)charSequence).toString();
    }
}

