/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.Label;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EdgeIntersectionList {
    Edge edge;
    private Map nodeMap = new TreeMap();

    public EdgeIntersectionList(Edge edge) {
        this.edge = edge;
    }

    public EdgeIntersection add(Coordinate comparable, int n, double d) {
        EdgeIntersection edgeIntersection = (EdgeIntersection)this.nodeMap.get(comparable = new EdgeIntersection((Coordinate)comparable, n, d));
        if (edgeIntersection != null) {
            return edgeIntersection;
        }
        this.nodeMap.put(comparable, comparable);
        return comparable;
    }

    public void addEndpoints() {
        int n = this.edge.pts.length - 1;
        this.add(this.edge.pts[0], 0, 0.0);
        this.add(this.edge.pts[n], n, 0.0);
    }

    public void addSplitEdges(List list) {
        this.addEndpoints();
        Iterator iterator2 = this.iterator();
        EdgeIntersection edgeIntersection = (EdgeIntersection)iterator2.next();
        while (iterator2.hasNext()) {
            EdgeIntersection edgeIntersection2 = (EdgeIntersection)iterator2.next();
            list.add(this.createSplitEdge(edgeIntersection, edgeIntersection2));
            edgeIntersection = edgeIntersection2;
        }
        return;
    }

    Edge createSplitEdge(EdgeIntersection edgeIntersection, EdgeIntersection edgeIntersection2) {
        int n = edgeIntersection2.segmentIndex - edgeIntersection.segmentIndex + 2;
        Coordinate[] coordinateArray = this.edge.pts[edgeIntersection2.segmentIndex];
        double d = edgeIntersection2.dist;
        int n2 = 1;
        boolean bl = d > 0.0 || !edgeIntersection2.coord.equals2D((Coordinate)coordinateArray);
        int n3 = n;
        if (!bl) {
            n3 = n - 1;
        }
        coordinateArray = new Coordinate[n3];
        coordinateArray[0] = new Coordinate(edgeIntersection.coord);
        n3 = edgeIntersection.segmentIndex + 1;
        while (true) {
            if (n3 > edgeIntersection2.segmentIndex) {
                if (bl) {
                    coordinateArray[n2] = edgeIntersection2.coord;
                }
                return new Edge(coordinateArray, new Label(this.edge.label));
            }
            coordinateArray[n2] = this.edge.pts[n3];
            ++n3;
            ++n2;
        }
    }

    public boolean isIntersection(Coordinate coordinate) {
        Iterator iterator2 = this.iterator();
        do {
            if (iterator2.hasNext()) continue;
            return false;
        } while (!((EdgeIntersection)iterator2.next()).coord.equals(coordinate));
        return true;
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public void print(PrintStream printStream) {
        printStream.println("Intersections:");
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            ((EdgeIntersection)iterator2.next()).print(printStream);
        }
        return;
    }
}

