/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.noding.OrientedCoordinateArray;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EdgeList {
    private List edges = new ArrayList();
    private Map ocaMap = new TreeMap();

    public void add(Edge edge) {
        this.edges.add(edge);
        OrientedCoordinateArray orientedCoordinateArray = new OrientedCoordinateArray(edge.getCoordinates());
        this.ocaMap.put(orientedCoordinateArray, edge);
    }

    public void addAll(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.add((Edge)object.next());
        }
        return;
    }

    public int findEdgeIndex(Edge edge) {
        int n = 0;
        while (n < this.edges.size()) {
            if (((Edge)this.edges.get(n)).equals(edge)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Edge findEqualEdge(Edge object) {
        object = new OrientedCoordinateArray(((Edge)object).getCoordinates());
        return (Edge)this.ocaMap.get(object);
    }

    public Edge get(int n) {
        return (Edge)this.edges.get(n);
    }

    public List getEdges() {
        return this.edges;
    }

    public Iterator iterator() {
        return this.edges.iterator();
    }

    public void print(PrintStream printStream) {
        printStream.print("MULTILINESTRING ( ");
        int n = 0;
        block0: while (true) {
            if (n >= this.edges.size()) {
                printStream.print(")  ");
                return;
            }
            Coordinate[] coordinateArray = (Coordinate[])this.edges.get(n);
            if (n > 0) {
                printStream.print(",");
            }
            printStream.print("(");
            coordinateArray = coordinateArray.getCoordinates();
            int n2 = 0;
            while (true) {
                if (n2 >= coordinateArray.length) {
                    printStream.println(")");
                    ++n;
                    continue block0;
                }
                if (n2 > 0) {
                    printStream.print(",");
                }
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(coordinateArray[n2].x));
                stringBuilder.append(" ");
                stringBuilder.append(coordinateArray[n2].y);
                printStream.print(stringBuilder.toString());
                ++n2;
            }
            break;
        }
    }
}

