/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public abstract class EdgeRing {
    private List edges = new ArrayList();
    protected GeometryFactory geometryFactory;
    private ArrayList holes;
    private boolean isHole;
    private Label label;
    private int maxNodeDegree = -1;
    private List pts = new ArrayList();
    private LinearRing ring;
    private EdgeRing shell;
    protected DirectedEdge startDe;

    public EdgeRing(DirectedEdge directedEdge, GeometryFactory geometryFactory) {
        this.label = new Label(-1);
        this.holes = new ArrayList();
        this.geometryFactory = geometryFactory;
        this.computePoints(directedEdge);
        this.computeRing();
    }

    private void computeMaxNodeDegree() {
        DirectedEdge directedEdge;
        this.maxNodeDegree = 0;
        DirectedEdge directedEdge2 = this.startDe;
        do {
            int n;
            if ((n = ((DirectedEdgeStar)directedEdge2.getNode().getEdges()).getOutgoingDegree(this)) > this.maxNodeDegree) {
                this.maxNodeDegree = n;
            }
            directedEdge2 = directedEdge = this.getNext(directedEdge2);
        } while (directedEdge != this.startDe);
        this.maxNodeDegree *= 2;
    }

    public void addHole(EdgeRing edgeRing) {
        this.holes.add(edgeRing);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void addPoints(Edge coordinateArray, boolean bl, boolean bl2) {
        int n;
        coordinateArray = coordinateArray.getCoordinates();
        if (!bl) {
            n = coordinateArray.length - 2;
            if (bl2) {
                n = coordinateArray.length - 1;
            }
        } else {
            int n2 = bl2 ^ 1;
            while (true) {
                if (n2 >= coordinateArray.length) {
                    return;
                }
                this.pts.add(coordinateArray[n2]);
                ++n2;
            }
        }
        while (n >= 0) {
            this.pts.add(coordinateArray[n]);
            --n;
        }
        return;
    }

    protected void computePoints(DirectedEdge object) {
        this.startDe = object;
        boolean bl = true;
        while (object != null) {
            Object object2;
            if (((DirectedEdge)object).getEdgeRing() != this) {
                this.edges.add(object);
                object2 = ((EdgeEnd)object).getLabel();
                Assert.isTrue(((Label)object2).isArea());
                this.mergeLabel((Label)object2);
                this.addPoints(((DirectedEdge)object).getEdge(), ((DirectedEdge)object).isForward(), bl);
                bl = false;
                this.setEdgeRing((DirectedEdge)object, this);
                object = object2 = this.getNext((DirectedEdge)object);
                if (object2 != this.startDe) continue;
                return;
            }
            object2 = new StringBuilder("Directed Edge visited twice during ring-building at ");
            ((StringBuilder)object2).append(((EdgeEnd)object).getCoordinate());
            throw new TopologyException(((StringBuilder)object2).toString());
        }
        throw new TopologyException("Found null DirectedEdge");
    }

    public void computeRing() {
        if (this.ring != null) {
            return;
        }
        Object object = new Coordinate[this.pts.size()];
        int n = 0;
        while (true) {
            if (n >= this.pts.size()) {
                this.ring = object = this.geometryFactory.createLinearRing((Coordinate[])object);
                this.isHole = CGAlgorithms.isCCW(((LineString)object).getCoordinates());
                return;
            }
            object[n] = (Coordinate)this.pts.get(n);
            ++n;
        }
    }

    public boolean containsPoint(Coordinate coordinate) {
        Object object = this.getLinearRing();
        if (!((Geometry)object).getEnvelopeInternal().contains(coordinate)) {
            return false;
        }
        if (!CGAlgorithms.isPointInRing(coordinate, ((LineString)object).getCoordinates())) {
            return false;
        }
        object = this.holes.iterator();
        do {
            if (object.hasNext()) continue;
            return true;
        } while (!((EdgeRing)object.next()).containsPoint(coordinate));
        return false;
    }

    public Coordinate getCoordinate(int n) {
        return (Coordinate)this.pts.get(n);
    }

    public List getEdges() {
        return this.edges;
    }

    public Label getLabel() {
        return this.label;
    }

    public LinearRing getLinearRing() {
        return this.ring;
    }

    public int getMaxNodeDegree() {
        if (this.maxNodeDegree < 0) {
            this.computeMaxNodeDegree();
        }
        return this.maxNodeDegree;
    }

    public abstract DirectedEdge getNext(DirectedEdge var1);

    public EdgeRing getShell() {
        return this.shell;
    }

    public boolean isHole() {
        return this.isHole;
    }

    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    public boolean isShell() {
        return this.shell == null;
    }

    protected void mergeLabel(Label label) {
        this.mergeLabel(label, 0);
        this.mergeLabel(label, 1);
    }

    protected void mergeLabel(Label label, int n) {
        int n2 = label.getLocation(n, 2);
        if (n2 == -1) {
            return;
        }
        if (this.label.getLocation(n) == -1) {
            this.label.setLocation(n, n2);
        }
    }

    public abstract void setEdgeRing(DirectedEdge var1, EdgeRing var2);

    public void setInResult() {
        DirectedEdge directedEdge;
        DirectedEdge directedEdge2 = this.startDe;
        do {
            directedEdge2.getEdge().setInResult(true);
            directedEdge2 = directedEdge = directedEdge2.getNext();
        } while (directedEdge != this.startDe);
    }

    public void setShell(EdgeRing edgeRing) {
        this.shell = edgeRing;
        if (edgeRing != null) {
            edgeRing.addHole(this);
        }
    }

    public Polygon toPolygon(GeometryFactory geometryFactory) {
        LinearRing[] linearRingArray = new LinearRing[this.holes.size()];
        int n = 0;
        while (n < this.holes.size()) {
            linearRingArray[n] = ((EdgeRing)this.holes.get(n)).getLinearRing();
            ++n;
        }
        return geometryFactory.createPolygon(this.getLinearRing(), linearRingArray);
    }
}

