/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.geomgraph.index.SimpleMCSweepLineIntersector;
import com.vividsolutions.jts.util.Assert;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GeometryGraph
extends PlanarGraph {
    private PointOnGeometryLocator areaPtLocator = null;
    private int argIndex;
    private BoundaryNodeRule boundaryNodeRule = null;
    private Collection boundaryNodes;
    private boolean hasTooFewPoints = false;
    private Coordinate invalidPoint = null;
    private Map lineEdgeMap = new HashMap();
    private Geometry parentGeom;
    private final PointLocator ptLocator = new PointLocator();
    private boolean useBoundaryDeterminationRule = true;

    public GeometryGraph(int n, Geometry geometry) {
        this(n, geometry, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE);
    }

    public GeometryGraph(int n, Geometry geometry, BoundaryNodeRule boundaryNodeRule) {
        this.argIndex = n;
        this.parentGeom = geometry;
        this.boundaryNodeRule = boundaryNodeRule;
        if (geometry != null) {
            this.add(geometry);
        }
    }

    private void add(Geometry geometry) {
        block12: {
            block6: {
                block11: {
                    boolean bl;
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        if (geometry.isEmpty()) {
                                            return;
                                        }
                                        bl = geometry instanceof MultiPolygon;
                                        if (bl) {
                                            this.useBoundaryDeterminationRule = false;
                                        }
                                        if (!(geometry instanceof Polygon)) break block5;
                                        this.addPolygon((Polygon)geometry);
                                        break block6;
                                    }
                                    if (!(geometry instanceof LineString)) break block7;
                                    this.addLineString((LineString)geometry);
                                    break block6;
                                }
                                if (!(geometry instanceof Point)) break block8;
                                this.addPoint((Point)geometry);
                                break block6;
                            }
                            if (!(geometry instanceof MultiPoint)) break block9;
                            this.addCollection((MultiPoint)geometry);
                            break block6;
                        }
                        if (!(geometry instanceof MultiLineString)) break block10;
                        this.addCollection((MultiLineString)geometry);
                        break block6;
                    }
                    if (!bl) break block11;
                    this.addCollection((MultiPolygon)geometry);
                    break block6;
                }
                if (!(geometry instanceof GeometryCollection)) break block12;
                this.addCollection((GeometryCollection)geometry);
            }
            return;
        }
        throw new UnsupportedOperationException(geometry.getClass().getName());
    }

    private void addCollection(GeometryCollection geometryCollection) {
        int n = 0;
        while (n < geometryCollection.getNumGeometries()) {
            this.add(geometryCollection.getGeometryN(n));
            ++n;
        }
        return;
    }

    private void addLineString(LineString lineString) {
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(lineString.getCoordinates());
        if (coordinateArray.length < 2) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coordinateArray[0];
            return;
        }
        Edge edge = new Edge(coordinateArray, new Label(this.argIndex, 0));
        this.lineEdgeMap.put(lineString, edge);
        this.insertEdge(edge);
        boolean bl = coordinateArray.length >= 2;
        Assert.isTrue(bl, "found LineString with single point");
        this.insertBoundaryPoint(this.argIndex, coordinateArray[0]);
        this.insertBoundaryPoint(this.argIndex, coordinateArray[coordinateArray.length - 1]);
    }

    private void addPoint(Point cloneable) {
        cloneable = cloneable.getCoordinate();
        this.insertPoint(this.argIndex, (Coordinate)cloneable, 0);
    }

    private void addPolygon(Polygon polygon) {
        this.addPolygonRing((LinearRing)polygon.getExteriorRing(), 2, 0);
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            this.addPolygonRing((LinearRing)polygon.getInteriorRingN(n), 0, 2);
            ++n;
        }
        return;
    }

    private void addPolygonRing(LinearRing linearRing, int n, int n2) {
        if (linearRing.isEmpty()) {
            return;
        }
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(linearRing.getCoordinates());
        if (coordinateArray.length < 4) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coordinateArray[0];
            return;
        }
        int n3 = n;
        int n4 = n2;
        if (CGAlgorithms.isCCW(coordinateArray)) {
            n4 = n;
            n3 = n2;
        }
        Edge edge = new Edge(coordinateArray, new Label(this.argIndex, 1, n3, n4));
        this.lineEdgeMap.put(linearRing, edge);
        this.insertEdge(edge);
        this.insertPoint(this.argIndex, coordinateArray[0], 1);
    }

    private void addSelfIntersectionNode(int n, Coordinate coordinate, int n2) {
        if (this.isBoundaryNode(n, coordinate)) {
            return;
        }
        if (n2 == 1 && this.useBoundaryDeterminationRule) {
            this.insertBoundaryPoint(n, coordinate);
        } else {
            this.insertPoint(n, coordinate, n2);
        }
    }

    private void addSelfIntersectionNodes(int n) {
        Iterator iterator2 = this.edges.iterator();
        block0: while (iterator2.hasNext()) {
            Object object = (Edge)iterator2.next();
            int n2 = ((GraphComponent)object).getLabel().getLocation(n);
            object = ((Edge)object).eiList.iterator();
            while (true) {
                if (!object.hasNext()) continue block0;
                this.addSelfIntersectionNode(n, ((EdgeIntersection)object.next()).coord, n2);
            }
            break;
        }
        return;
    }

    private EdgeSetIntersector createEdgeSetIntersector() {
        return new SimpleMCSweepLineIntersector();
    }

    public static int determineBoundary(BoundaryNodeRule boundaryNodeRule, int n) {
        return boundaryNodeRule.isInBoundary(n) ? 1 : 0;
    }

    private void insertBoundaryPoint(int n, Coordinate object) {
        object = this.nodes.addNode((Coordinate)object).getLabel();
        int n2 = ((Label)object).getLocation(n, 0);
        int n3 = 1;
        if (n2 == 1) {
            n3 = 2;
        }
        ((Label)object).setLocation(n, GeometryGraph.determineBoundary(this.boundaryNodeRule, n3));
    }

    private void insertPoint(int n, Coordinate object, int n2) {
        Label label = ((GraphComponent)(object = this.nodes.addNode((Coordinate)object))).getLabel();
        if (label == null) {
            ((Node)object).label = new Label(n, n2);
        } else {
            label.setLocation(n, n2);
        }
    }

    public void addEdge(Edge coordinateArray) {
        this.insertEdge((Edge)coordinateArray);
        coordinateArray = coordinateArray.getCoordinates();
        this.insertPoint(this.argIndex, coordinateArray[0], 1);
        this.insertPoint(this.argIndex, coordinateArray[coordinateArray.length - 1], 1);
    }

    public void addPoint(Coordinate coordinate) {
        this.insertPoint(this.argIndex, coordinate, 0);
    }

    public SegmentIntersector computeEdgeIntersections(GeometryGraph geometryGraph, LineIntersector object, boolean bl) {
        object = new SegmentIntersector((LineIntersector)object, bl, true);
        ((SegmentIntersector)object).setBoundaryNodes(this.getBoundaryNodes(), geometryGraph.getBoundaryNodes());
        this.createEdgeSetIntersector().computeIntersections(this.edges, geometryGraph.edges, (SegmentIntersector)object);
        return object;
    }

    public SegmentIntersector computeSelfNodes(LineIntersector object, boolean bl) {
        SegmentIntersector segmentIntersector = new SegmentIntersector((LineIntersector)object, true, false);
        EdgeSetIntersector edgeSetIntersector = this.createEdgeSetIntersector();
        if (!bl && ((object = this.parentGeom) instanceof LinearRing || object instanceof Polygon || object instanceof MultiPolygon)) {
            edgeSetIntersector.computeIntersections(this.edges, segmentIntersector, false);
        } else {
            edgeSetIntersector.computeIntersections(this.edges, segmentIntersector, true);
        }
        this.addSelfIntersectionNodes(this.argIndex);
        return segmentIntersector;
    }

    public void computeSplitEdges(List list) {
        Iterator iterator2 = this.edges.iterator();
        while (iterator2.hasNext()) {
            ((Edge)iterator2.next()).eiList.addSplitEdges(list);
        }
        return;
    }

    public Edge findEdge(LineString lineString) {
        return (Edge)this.lineEdgeMap.get(lineString);
    }

    public BoundaryNodeRule getBoundaryNodeRule() {
        return this.boundaryNodeRule;
    }

    public Collection getBoundaryNodes() {
        if (this.boundaryNodes == null) {
            this.boundaryNodes = this.nodes.getBoundaryNodes(this.argIndex);
        }
        return this.boundaryNodes;
    }

    public Coordinate[] getBoundaryPoints() {
        Object object = this.getBoundaryNodes();
        Coordinate[] coordinateArray = new Coordinate[object.size()];
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            coordinateArray[n] = (Coordinate)((Node)object.next()).getCoordinate().clone();
            ++n;
        }
        return coordinateArray;
    }

    public Geometry getGeometry() {
        return this.parentGeom;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public boolean hasTooFewPoints() {
        return this.hasTooFewPoints;
    }

    public int locate(Coordinate coordinate) {
        Geometry geometry = this.parentGeom;
        if (geometry instanceof Polygonal && geometry.getNumGeometries() > 50) {
            if (this.areaPtLocator == null) {
                this.areaPtLocator = new IndexedPointInAreaLocator(this.parentGeom);
            }
            return this.areaPtLocator.locate(coordinate);
        }
        return this.ptLocator.locate(coordinate, this.parentGeom);
    }
}

