/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.util.Assert;

public abstract class GraphComponent {
    private boolean isCovered = false;
    private boolean isCoveredSet = false;
    private boolean isInResult = false;
    private boolean isVisited = false;
    protected Label label;

    public GraphComponent() {
    }

    public GraphComponent(Label label) {
        this.label = label;
    }

    protected abstract void computeIM(IntersectionMatrix var1);

    public abstract Coordinate getCoordinate();

    public Label getLabel() {
        return this.label;
    }

    public boolean isCovered() {
        return this.isCovered;
    }

    public boolean isCoveredSet() {
        return this.isCoveredSet;
    }

    public boolean isInResult() {
        return this.isInResult;
    }

    public abstract boolean isIsolated();

    public boolean isVisited() {
        return this.isVisited;
    }

    public void setCovered(boolean bl) {
        this.isCovered = bl;
        this.isCoveredSet = true;
    }

    public void setInResult(boolean bl) {
        this.isInResult = bl;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void setVisited(boolean bl) {
        this.isVisited = bl;
    }

    public void updateIM(IntersectionMatrix intersectionMatrix) {
        boolean bl = this.label.getGeometryCount() >= 2;
        Assert.isTrue(bl, "found partial label");
        this.computeIM(intersectionMatrix);
    }
}

